/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCCmd;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.util.ArrayList;
import java.util.List;

public class OCmdTransform
extends OCCmd {
    AlgaTransform.Type _type;
    List<AlgaDraw> _graphs;
    List<AlgaPort> _ports;
    List<AlgaLink> _links;

    public OCmdTransform(CeciliaAppl appl, AltaContentEditPanel c, AlgaTransform.Type type) {
        super(appl, c);
        this._type = type;
        this._graphs = new ArrayList<AlgaDraw>(32);
        this._ports = new ArrayList<AlgaPort>(8);
        this._links = new ArrayList<AlgaLink>(32);
    }

    @Override
    protected void firstDo() {
        List<AlgaSheet> sheets = this.getContent().getSheets();
        for (int i = sheets.size() - 1; i >= 0; --i) {
            AlgaSheet sheet = sheets.get(i);
            for (AlgaGraph grf : sheet.getGraphs()) {
                if (sheet.isVisible() && grf.isSelected() && !grf.isLocked() && grf instanceof AlgaDraw) {
                    this._graphs.add((AlgaDraw)grf);
                    if (!(grf instanceof AlgaPort) || !((AlgaPort)grf).isAutomaticPosition()) continue;
                    this._ports.add((AlgaPort)grf);
                    continue;
                }
                if (!(grf instanceof AlgaLink)) continue;
                AlgaLink gLink = (AlgaLink)grf;
                AlgaWithPorts gNode = gLink.getLogical().getFromGraphic();
                if (gNode.isSelected() && !gNode.isLocked()) {
                    this._links.add(gLink);
                    continue;
                }
                gNode = gLink.getLogical().getToGraphic();
                if (!gNode.isSelected() || gNode.isLocked()) continue;
                this._links.add(gLink);
            }
        }
        if (this._graphs.size() > 0) {
            this.redo();
            this.getPanel().addHisto(this);
        }
    }

    protected void doChangeAutomaticPositionPorts() {
        for (int i = this._ports.size() - 1; i >= 0; --i) {
            AlgaPort port;
            port.setAutomaticPosition(!(port = this._ports.get(i)).isAutomaticPosition());
        }
    }

    protected void doComputeControlPointsLinks() {
        for (int i = this._links.size() - 1; i >= 0; --i) {
            AlgaLink link = this._links.get(i);
            link.computeControlPoints();
        }
    }

    @Override
    public void redo() {
        AlgaTransform.Type transform = this._type;
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaDraw graph = this._graphs.get(i);
            graph.getTransform().add(transform);
            graph.computeControlPoints();
        }
        this.doComputeControlPointsLinks();
        this.doChangeAutomaticPositionPorts();
        this.refreshAll();
    }

    @Override
    public void undo() {
        AlgaTransform.Type transform = this._type;
        switch (transform) {
            case ROTATE: {
                transform = AlgaTransform.Type.ROTATE_INV;
                break;
            }
            case ROTATE_INV: {
                transform = AlgaTransform.Type.ROTATE;
            }
        }
        for (int i = this._graphs.size() - 1; i >= 0; --i) {
            AlgaDraw graph = this._graphs.get(i);
            graph.getTransform().add(transform);
            graph.computeControlPoints();
        }
        this.doComputeControlPointsLinks();
        this.doChangeAutomaticPositionPorts();
        this.refreshAll();
    }
}

