/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse;

import com.dassault.cecilia.dbobj.mbsa.component.pref.AltaContentDisplayPreferencies;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaWithPorts;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdLinkCreate;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class DelegateMouseLinkCreate
implements AltaContentView.DelegateMouse {
    int _originX;
    int _originY;
    int _currentX;
    int _currentY;
    AlgaWithPorts _sourceGraphics;
    AltaFlow _sourceFlow;
    Pt _sourcePt;

    public DelegateMouseLinkCreate(AlgaWithPorts subGraphics, AltaFlow flow, Pt pt) {
        this._sourceGraphics = subGraphics;
        this._sourceFlow = flow;
        this._sourcePt = pt;
    }

    @Override
    public boolean mousePressed(MouseEvent e, AltaContentView view) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return false;
        }
        double zoom = view.getZoom();
        this._originX = (int)((double)this._sourcePt.getX() * zoom);
        this._originY = (int)((double)this._sourcePt.getY() * zoom);
        this._currentX = e.getX();
        this._currentY = e.getY();
        this.drawGhost(view.getGraphics());
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent e, AltaContentView view) {
        Graphics g = view.getGraphics();
        this.drawGhost(g);
        this._currentX = e.getX();
        this._currentY = e.getY();
        this.drawGhost(g);
    }

    @Override
    public void mouseReleased(MouseEvent e, AltaContentView view) {
        AltaFlow flow;
        this.drawGhost(view.getGraphics());
        double _zoom = view.getZoom();
        int x = (int)((double)this._currentX / _zoom);
        int y = (int)((double)this._currentY / _zoom);
        AlgaGraph dest = view.getContent().getGraphAtPoint(x, y, AltaContentDisplayPreferencies.LinkDisplay.BG);
        if (dest != null && dest instanceof AlgaWithPorts && (flow = ((AlgaWithPorts)dest).getFlowAt(x, y)) != null) {
            AltaContentEditView edit = (AltaContentEditView)view;
            OCmdLinkCreate cmd = new OCmdLinkCreate(edit.getPanel(), edit.getContext().getLinkDisplay() == AltaContentDisplayPreferencies.LinkDisplay.BG);
            cmd.setSource(this._sourceGraphics, this._sourceFlow);
            cmd.setDestination((AlgaWithPorts)dest, flow);
            cmd.realiseDo();
        }
    }

    private void drawGhost(Graphics g) {
        g.setXORMode(Color.yellow);
        g.drawLine(this._originX, this._originY, this._currentX, this._currentY);
    }
}

