/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdPathAddPoint;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdPathDelPoint;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdPathMovePoint;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class DelegateMousePathMovePoint
implements AltaContentView.DelegateMouse {
    int _sourceX;
    int _sourceY;
    int _originX;
    int _originY;
    Pt _prevPt;
    Pt _nextPt;
    Pt _currentPt;
    int _prevX;
    int _prevY;
    int _nextX;
    int _nextY;
    int _currentX;
    int _currentY;
    int _adjustX;
    int _adjustY;
    AlgaPoints _source;
    int _hitPoint;
    boolean _isGhostPoint;
    boolean _wantMoveBar;
    boolean _wantAdjustPoint;
    private static Logger _LOG = Logger.getLogger(DelegateMousePathMovePoint.class.getPackage().getName());
    private static boolean _TRACE = _LOG.isLoggable(Level.FINEST);

    public DelegateMousePathMovePoint(AlgaPoints source, int hitPoint) {
        this._source = source;
        this._hitPoint = hitPoint;
        this._isGhostPoint = hitPoint % 2 != 0;
    }

    @Override
    public boolean mousePressed(MouseEvent e, AltaContentView view) {
        Pt tmp;
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return false;
        }
        double zoom = view.getZoom();
        this._sourceX = e.getX();
        this._sourceY = e.getY();
        ArrayList<Pt> points = this._source.getPoints();
        int nbrPoints = this._source.getNbrPoints();
        if (_TRACE) {
            _LOG.finest("AllPoints = " + points);
            _LOG.finest("HitPoint = " + this._hitPoint);
        }
        Iterator<Pt> iterPt = this._source.iteratePoint();
        int badPoint = this._hitPoint / 2;
        if (!this._isGhostPoint) {
            // empty if block
        }
        while (true) {
            int n = --badPoint;
            --badPoint;
            if (n <= 0) break;
            tmp = iterPt.next();
            if (!_TRACE) continue;
            _LOG.finest(" BadPoint : " + tmp.toString());
        }
        if (this._isGhostPoint) {
            tmp = iterPt.next();
            if (_TRACE) {
                _LOG.finest("PrevPoint : " + tmp.toString());
            }
            this._prevPt = tmp;
            this._prevX = (int)((double)tmp.getX() * zoom);
            this._prevY = (int)((double)tmp.getY() * zoom);
            if (iterPt.hasNext()) {
                tmp = iterPt.next();
                if (_TRACE) {
                    _LOG.finest("NextPoint : " + tmp.toString());
                }
                this._nextPt = tmp;
                this._nextX = (int)((double)tmp.getX() * zoom);
                this._nextY = (int)((double)tmp.getY() * zoom);
            } else if (this._source.isClosePath()) {
                tmp = (Pt)points.get(0);
                if (_TRACE) {
                    _LOG.finest("NextPoint : " + tmp.toString());
                }
                this._nextPt = tmp;
                this._nextX = (int)((double)tmp.getX() * zoom);
                this._nextY = (int)((double)tmp.getY() * zoom);
            }
            this._originX = (this._prevX + this._nextX) / 2;
            this._originY = (this._prevY + this._nextY) / 2;
            if (_TRACE) {
                _LOG.finest("GhostPoint : {" + (double)this._originX / zoom + "," + (double)this._originY / zoom + "}");
            }
            if (e.isShiftDown()) {
                this._wantMoveBar = this.doYouWantMoveBar();
                if (_TRACE) {
                    _LOG.finest("Does user want move bar ? : " + this._wantMoveBar);
                }
            }
        } else {
            if (this._hitPoint == 0) {
                this._prevY = -1;
                this._prevX = -1;
                if (_TRACE) {
                    _LOG.finest("PrevPoint : none");
                }
            } else {
                tmp = iterPt.next();
                if (_TRACE) {
                    _LOG.finest("PrevPoint : " + tmp.toString());
                }
                this._prevPt = tmp;
                this._prevX = (int)((double)tmp.getX() * zoom);
                this._prevY = (int)((double)tmp.getY() * zoom);
            }
            tmp = iterPt.next();
            if (_TRACE) {
                _LOG.finest("CurrPoint : " + tmp.toString());
            }
            this._currentPt = tmp;
            this._originX = (int)((double)tmp.getX() * zoom);
            this._originY = (int)((double)tmp.getY() * zoom);
            if (this._hitPoint == (nbrPoints - 1) * 2) {
                this._nextY = -1;
                this._nextX = -1;
                if (_TRACE) {
                    _LOG.finest("NextPoint : none");
                }
            } else {
                tmp = iterPt.next();
                if (_TRACE) {
                    _LOG.finest("NextPoint : " + tmp.toString());
                }
                this._nextPt = tmp;
                this._nextX = (int)((double)tmp.getX() * zoom);
                this._nextY = (int)((double)tmp.getY() * zoom);
            }
            if (this._source.isClosePath()) {
                if (this._nextX == -1) {
                    tmp = (Pt)points.get(0);
                    if (_TRACE) {
                        _LOG.finest("NextPoint : " + tmp.toString());
                    }
                    this._nextPt = tmp;
                    this._nextX = (int)((double)tmp.getX() * zoom);
                    this._nextY = (int)((double)tmp.getY() * zoom);
                }
                if (this._prevX == -1) {
                    tmp = (Pt)points.get(nbrPoints - 1);
                    if (_TRACE) {
                        _LOG.finest("PrevPoint : " + tmp.toString());
                    }
                    this._prevPt = tmp;
                    this._prevX = (int)((double)tmp.getX() * zoom);
                    this._prevY = (int)((double)tmp.getY() * zoom);
                }
            }
        }
        boolean bl = this._wantAdjustPoint = e.isControlDown() && !this._wantMoveBar;
        if (_TRACE) {
            while (iterPt.hasNext()) {
                tmp = iterPt.next();
                _LOG.finest(" EndPoint : " + tmp.toString());
            }
        }
        this._currentX = e.getX();
        this._currentY = e.getY();
        this.drawGhost(view.getGraphics(), zoom);
        return true;
    }

    private boolean doYouWantMoveBar() {
        Pt prev;
        if (!this._isGhostPoint) {
            return false;
        }
        if (this._hitPoint == 1) {
            return false;
        }
        Pt last = null;
        Iterator<Pt> iterPt = this._source.iteratePoint();
        int badPoint = this._hitPoint / 2;
        Pt first = iterPt.next();
        while (--badPoint > 0) {
            first = iterPt.next();
        }
        Pt next = prev = iterPt.next();
        if (iterPt.hasNext()) {
            next = iterPt.next();
            if (iterPt.hasNext()) {
                last = iterPt.next();
            } else if (this._source.isClosePath()) {
                last = this._source.getPoints().get(0);
            }
        } else if (this._source.isClosePath()) {
            next = this._source.getPoints().get(0);
            last = this._source.getPoints().get(1);
        }
        if (last == null) {
            return false;
        }
        double dt1 = DelegateMousePathMovePoint.computeDT(first.getX(), first.getY(), prev.getX(), prev.getY());
        double dt2 = DelegateMousePathMovePoint.computeDT(next.getX(), next.getY(), last.getX(), last.getY());
        if (Math.abs(dt1) != Math.abs(dt2)) {
            return false;
        }
        double dt3 = DelegateMousePathMovePoint.computeDT(prev.getX(), prev.getY(), next.getX(), next.getY());
        if (dt1 == Double.POSITIVE_INFINITY) {
            return dt3 == 0.0;
        }
        if (dt3 == Double.POSITIVE_INFINITY) {
            return dt1 == 0.0;
        }
        return dt1 * dt3 == -1.0;
    }

    private static double computeDT(double x1, double y1, double x2, double y2) {
        if (x2 - x1 == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return (y2 - y1) / (x2 - x1);
    }

    @Override
    public void mouseDragged(MouseEvent e, AltaContentView view) {
        Graphics g = view.getGraphics();
        double zoom = view.getZoom();
        this.drawGhost(g, zoom);
        this._wantAdjustPoint = e.isControlDown() && !this._wantMoveBar;
        this._currentX = e.getX();
        this._currentY = e.getY();
        this.drawGhost(g, zoom);
    }

    @Override
    public void mouseReleased(MouseEvent e, AltaContentView view) {
        double zoom = view.getZoom();
        this.drawGhost(view.getGraphics(), zoom);
        boolean bl = this._wantAdjustPoint = e.isControlDown() && !this._wantMoveBar;
        if (this._isGhostPoint) {
            if (this._wantMoveBar) {
                AltaContentEditPanel panel = ((AltaContentEditView)view).getPanel();
                OCmdPathMovePoint cmd = new OCmdPathMovePoint(panel, this._source);
                double a = DelegateMousePathMovePoint.computeDT(this._prevX, this._prevY, this._nextX, this._nextY);
                if (a == Double.POSITIVE_INFINITY) {
                    int dx = this._currentX - this._originX;
                    cmd.addMoveDeltaPoint((double)dx / zoom, 0.0, this._hitPoint / 2);
                    cmd.addMoveDeltaPoint((double)dx / zoom, 0.0, (this._hitPoint + 1) / 2);
                } else if (a == 0.0) {
                    int dy = this._currentY - this._originY;
                    cmd.addMoveDeltaPoint(0.0, (double)dy / zoom, this._hitPoint / 2);
                    cmd.addMoveDeltaPoint(0.0, (double)dy / zoom, (this._hitPoint + 1) / 2);
                } else {
                    double b = (double)this._nextY - a * (double)this._nextX;
                    double y = (a * ((double)this._currentX + a * (double)this._currentY) + b) / (1.0 + a * a);
                    double x = (y - b) / a;
                    int dx = (int)((double)this._currentX - x);
                    int dy = (int)((double)this._currentY - y);
                    cmd.addMoveDeltaPoint((double)dx / zoom, (double)dy / zoom, this._hitPoint / 2);
                    cmd.addMoveDeltaPoint((double)dx / zoom, (double)dy / zoom, (this._hitPoint + 1) / 2);
                }
                if (cmd.realiseDo()) {
                    panel.addHisto(cmd);
                }
            } else {
                if (this._wantAdjustPoint) {
                    this.adjustCurrentPoint(zoom);
                    this._currentX = this._adjustX;
                    this._currentY = this._adjustY;
                }
                if (AlgaPoints.pointIsInside(this._currentX, this._currentY, this._prevX, this._prevY, this._nextX, this._nextY, 3)) {
                    return;
                }
                OCmdPathAddPoint cmd = new OCmdPathAddPoint(((AltaContentEditView)view).getPanel(), this._source, (int)((double)this._currentX / zoom), (int)((double)this._currentY / zoom), this._hitPoint / 2 + 1);
                cmd.realiseDo();
            }
        } else if (this._prevX != -1 && this._nextX != -1 && AlgaPoints.pointIsInside(this._currentX, this._currentY, this._prevX, this._prevY, this._nextX, this._nextY, 3)) {
            OCmdPathDelPoint cmd = new OCmdPathDelPoint(((AltaContentEditView)view).getPanel(), this._source, this._hitPoint / 2);
            cmd.realiseDo();
        } else if (this._sourceX != e.getX() || this._sourceY != e.getY()) {
            if (this._currentPt != null) {
                this._currentPt.setSelected(true);
            }
            AltaContentEditPanel panel = ((AltaContentEditView)view).getPanel();
            OCmdPathMovePoint cmd = new OCmdPathMovePoint(panel, this._source);
            if (this._wantAdjustPoint) {
                this.adjustCurrentPoint(zoom);
                int x = (int)((double)this._currentX / zoom);
                int y = (int)((double)this._currentY / zoom);
                if (this._currentX != this._adjustX) {
                    if ((double)Math.abs(this._adjustX - this._prevX) < 1.0 / zoom) {
                        x = this._prevPt.getX();
                    } else if ((double)Math.abs(this._adjustX - this._nextX) < 1.0 / zoom) {
                        x = this._nextPt.getX();
                    }
                }
                if (this._currentY != this._adjustY) {
                    if ((double)Math.abs(this._adjustY - this._prevY) < 1.0 / zoom) {
                        y = this._prevPt.getY();
                    } else if ((double)Math.abs(this._adjustY - this._nextY) < 1.0 / zoom) {
                        y = this._nextPt.getY();
                    }
                }
                cmd.addMovePoint((double)x, (double)y, this._hitPoint / 2);
            } else {
                cmd.addMovePoint((double)((int)((double)this._currentX / zoom)), (double)((int)((double)this._currentY / zoom)), this._hitPoint / 2);
            }
            if (cmd.realiseDo()) {
                panel.addHisto(cmd);
            }
        } else {
            if (this._currentPt != null) {
                this._currentPt.setSelected(!this._currentPt.isSelected());
            }
            view.fireChangeSelect();
            view.repaint();
        }
    }

    private void drawGhost(Graphics g, double zoom) {
        g.setXORMode(Color.yellow);
        if (this._wantMoveBar) {
            double a = DelegateMousePathMovePoint.computeDT(this._prevX, this._prevY, this._nextX, this._nextY);
            if (a == Double.POSITIVE_INFINITY) {
                int dx = this._currentX - this._originX;
                g.drawLine(this._prevX, this._prevY, this._prevX + dx, this._prevY);
                g.drawLine(this._prevX + dx, this._prevY, this._nextX + dx, this._nextY);
                g.drawLine(this._nextX + dx, this._nextY, this._nextX, this._nextY);
            } else if (a == 0.0) {
                int dy = this._currentY - this._originY;
                g.drawLine(this._prevX, this._prevY, this._prevX, this._prevY + dy);
                g.drawLine(this._prevX, this._prevY + dy, this._nextX, this._nextY + dy);
                g.drawLine(this._nextX, this._nextY + dy, this._nextX, this._nextY);
            } else {
                double b = (double)this._nextY - a * (double)this._nextX;
                double y = (a * ((double)this._currentX + a * (double)this._currentY) + b) / (1.0 + a * a);
                double x = (y - b) / a;
                int dx = (int)((double)this._currentX - x);
                int dy = (int)((double)this._currentY - y);
                g.drawLine(this._prevX, this._prevY, this._prevX + dx, this._prevY + dy);
                g.drawLine(this._prevX + dx, this._prevY + dy, this._nextX + dx, this._nextY + dy);
                g.drawLine(this._nextX + dx, this._nextY + dy, this._nextX, this._nextY);
            }
        } else if (this._wantAdjustPoint) {
            this.adjustCurrentPoint(zoom);
            if (this._prevX != -1) {
                g.drawLine(this._prevX, this._prevY, this._adjustX, this._adjustY);
            }
            if (this._nextX != -1) {
                g.drawLine(this._adjustX, this._adjustY, this._nextX, this._nextY);
            }
        } else {
            if (this._prevX != -1) {
                g.drawLine(this._prevX, this._prevY, this._currentX, this._currentY);
            }
            if (this._nextX != -1) {
                g.drawLine(this._currentX, this._currentY, this._nextX, this._nextY);
            }
        }
    }

    protected double computeAdjust(double refX, double refY, double ptX, double ptY, boolean abscisse, double delta, double alpha, double exclude) {
        if (abscisse) {
            double diffX = Math.abs(ptX - refX);
            if (diffX > delta) {
                return 0.0;
            }
            double diffY = Math.abs(ptY - refY);
            if (diffY <= exclude && diffX <= exclude) {
                return refX + (ptX > refX ? exclude : -exclude) - ptX;
            }
            if (diffY > delta * Math.tan(alpha)) {
                return refX - ptX;
            }
            if (diffY == 0.0) {
                return 0.0;
            }
            if (Math.atan(diffX / diffY) < alpha) {
                return refX - ptX;
            }
        } else {
            double diffY = Math.abs(ptY - refY);
            if (diffY > delta) {
                return 0.0;
            }
            double diffX = Math.abs(ptX - refX);
            if (diffY <= exclude && diffX <= exclude) {
                return refY + (ptY > refY ? exclude : -exclude) - ptY;
            }
            if (diffX > delta * Math.tan(alpha)) {
                return refY - ptY;
            }
            if (diffX == 0.0) {
                return 0.0;
            }
            if (Math.atan(diffY / diffX) < alpha) {
                return refY - ptY;
            }
        }
        return 0.0;
    }

    private boolean adjustCurrentPoint(double zoom) {
        this._adjustX = this._currentX;
        this._adjustY = this._currentY;
        if (this._prevX == -1) {
            return false;
        }
        if (this._nextX == -1) {
            return false;
        }
        double exclude = 4.0 * zoom;
        double delta = 12.0 * zoom;
        double alpha = Math.toRadians(15.0);
        double dxp = this.computeAdjust(this._prevX, this._prevY, this._currentX, this._currentY, true, delta, alpha, exclude);
        double dxn = this.computeAdjust(this._nextX, this._nextY, this._currentX, this._currentY, true, delta, alpha, exclude);
        double dyp = this.computeAdjust(this._prevX, this._prevY, this._currentX, this._currentY, false, delta, alpha, exclude);
        double dyn = this.computeAdjust(this._nextX, this._nextY, this._currentX, this._currentY, false, delta, alpha, exclude);
        if (dxp != 0.0 ^ dxn != 0.0) {
            this._adjustX = (int)((double)this._adjustX + (dxp + dxn));
        }
        if (dyp != 0.0 ^ dyn != 0.0) {
            this._adjustY = (int)((double)this._adjustY + (dyp + dyn));
        }
        return this._currentX != this._adjustX || this._currentY != this._adjustY;
    }
}

