/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse;

import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.actions.OCmdMove;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.mouse.MoveGrfUtility;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;

public class DelegateMouseSelect
implements AltaContentView.DelegateMouse {
    AlgaGraph _src;
    boolean _bSrcWasSelected;
    boolean _bPressWithShift = false;
    boolean _bChangeSelect = false;
    boolean _bDragSelect = false;
    int _originX;
    int _originY;
    int _currentX;
    int _currentY;
    MoveGrfUtility _moveUtility;

    public DelegateMouseSelect(AlgaGraph src) {
        this._src = src;
        this._bSrcWasSelected = src.isSelected();
    }

    @Override
    public boolean mousePressed(MouseEvent e, AltaContentView view) {
        this._currentX = this._originX = e.getX();
        this._currentY = this._originY = e.getY();
        if (e.isShiftDown()) {
            this._bPressWithShift = true;
            if (e.isPopupTrigger()) {
                if (!this._bSrcWasSelected) {
                    this._src.setSelected(true);
                    this._bChangeSelect = true;
                }
            } else {
                this._src.setSelected(!this._src.isSelected());
                this._bChangeSelect = true;
            }
        } else if (!this._src.isSelected()) {
            view.getContent().changeSelectGraphs(null, false);
            this._src.setSelected(true);
            this._bChangeSelect = true;
        }
        if (this._bChangeSelect) {
            view.repaint();
        }
        if (this._src.isSelected()) {
            this._moveUtility = new MoveGrfUtility();
            this._moveUtility.prepare(view, false, false);
        }
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent e, AltaContentView view) {
        if (!this._src.isSelected()) {
            return;
        }
        if (!(view instanceof AltaContentEditView)) {
            return;
        }
        this._bDragSelect = true;
        this.drawRect((Graphics2D)view.getGraphics(), view.getZoom());
        this._currentX = e.getX();
        this._currentY = e.getY();
        this.drawRect((Graphics2D)view.getGraphics(), view.getZoom());
    }

    @Override
    public void mouseReleased(MouseEvent e, AltaContentView view) {
        if (this._bDragSelect && (this._currentX != this._originX || this._currentY != this._originY) && view instanceof AltaContentEditView) {
            double zoom = view.getZoom();
            this.drawRect((Graphics2D)view.getGraphics(), zoom);
            int deltaX = this._moveUtility.adjustX(this._currentX - this._originX);
            int deltaY = this._moveUtility.adjustY(this._currentY - this._originY);
            OCmdMove cmd = new OCmdMove(((AltaContentEditView)view).getPanel(), (int)((double)deltaX / zoom), (int)((double)deltaY / zoom));
            cmd.realiseDo();
        } else if (!(this._bPressWithShift || e.isPopupTrigger() && this._bSrcWasSelected)) {
            view.getContent().changeSelectGraphs(null, false);
            this._src.setSelected(true);
            this._bChangeSelect = true;
            view.repaint();
        }
        if (this._bChangeSelect) {
            view.fireChangeSelect();
        }
    }

    private void drawRect(Graphics2D g, double zoom) {
        int deltaX = this._currentX - this._originX;
        int deltaY = this._currentY - this._originY;
        this._moveUtility.drawRect(deltaX, deltaY, g, zoom);
    }
}

