/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContainer;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaImage;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLine;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPolygone;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaText;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.AlgaContentConstantXml;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.DBEquipmentHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaDefaultHandlerXml;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AlgaContentHandlerXml
extends DBAltaDefaultHandlerXml
implements DBObjectXmlConstant,
AlgaContentConstantXml {
    private static Logger _LOG = Logger.getLogger(AlgaContentHandlerXml.class.getPackage().getName());
    protected DBEquipmentHandlerXml _equipHandler;
    long _idView;
    List<AlgaSheet> _sheets;
    AlgaSheet _currentSheet;
    List<AlgaContainer> _lifoContainer;
    protected String _startEltKey = null;
    protected AlgaGraph _currentGraph = null;

    public AlgaContentHandlerXml(DBLogs.DBLogsManager manager, Locator locator, DBEquipmentHandlerXml equipHandler) {
        super(manager, locator);
        this._equipHandler = equipHandler;
        this._idView = -1L;
        this._sheets = new ArrayList<AlgaSheet>(5);
        this._currentSheet = null;
        this._lifoContainer = new ArrayList<AlgaContainer>();
    }

    public long getID() {
        return this._idView;
    }

    public List<AlgaSheet> getSheets() {
        return this._sheets;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            this._startEltKey = key;
            this._idView = this.readID(key, "id", attrs);
        } else if (this._currentSheet == null) {
            if ("alga.sheet".equals(key)) {
                this._currentSheet = this.readSheet(key, attrs);
                this._sheets.add(this._currentSheet);
                this._lifoContainer.add(this._currentSheet);
            } else {
                this.errorElementUnknown(key);
            }
        } else {
            AlgaGraph grf = null;
            if ("alga.group".equals(key)) {
                this._currentGraph = grf = this.readGroup(key, attrs);
            } else if ("alga.node".equals(key)) {
                this._currentGraph = grf = this.readNode(key, attrs);
            } else if ("alga.port".equals(key)) {
                this._currentGraph = grf = this.readPort(key, attrs);
            } else if ("alga.link".equals(key)) {
                this._currentGraph = grf = this.readLink(key, attrs);
            } else if ("alga.form".equals(key)) {
                this._currentGraph = grf = this.readForm(key, attrs);
            } else if ("alga.icon".equals(key)) {
                this._currentGraph = grf = this.readIcon(key, attrs);
            } else if ("alga.text".equals(key)) {
                this._currentGraph = grf = this.readText(key, attrs);
            } else if ("alga.poly".equals(key)) {
                this._currentGraph = grf = this.readPoly(key, attrs);
            } else if ("alga.line".equals(key)) {
                this._currentGraph = grf = this.readLine(key, attrs);
            } else if ("alga.point".equals(key)) {
                if (this._currentGraph == null) {
                    _LOG.fine("No current graph and you want include points... ");
                } else if (!(this._currentGraph instanceof AlgaPoints)) {
                    _LOG.warning("Current graph is not instance of AlgaPoints, and you want include points... : " + this._currentGraph.toString());
                } else {
                    Pt pt = this.readPoint(key, attrs);
                    ((AlgaPoints)this._currentGraph).addPoint(pt);
                }
            } else {
                this.errorElementUnknown(key);
            }
            if (grf != null) {
                this._lifoContainer.get(this._lifoContainer.size() - 1).add(grf, Integer.MAX_VALUE);
                if ("alga.group".equals(key)) {
                    this._lifoContainer.add((AlgaGroup)grf);
                }
            }
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXParseException {
        if (this._currentSheet != null) {
            if ("alga.text".equals(key)) {
                if (this._currentGraph == null || !(this._currentGraph instanceof AlgaText)) {
                    _LOG.warning("Current graph is not instance of AlgaText");
                } else {
                    ((AlgaText)this._currentGraph).setText(txt);
                }
            } else if ("alga.group".equals(key)) {
                this._lifoContainer.remove(this._lifoContainer.size() - 1);
            } else if ("alga.sheet".equals(key)) {
                this._lifoContainer.remove(this._lifoContainer.size() - 1);
                this._currentSheet = null;
            }
            return false;
        }
        return this._startEltKey.equals(key);
    }

    private AlgaSheet readSheet(String key, Map<String, String> attrs) throws SAXException {
        long id = this.readID(key, "id", attrs);
        if (id > 30L) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "id", Long.toString(id)), this.getLocator()));
        }
        String name = "";
        name = attrs.get("name");
        if (name == null || name.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "name"), this.getLocator()));
        }
        boolean visible = this.readBoolean(key, "visible", attrs, true, true);
        boolean select = this.readBoolean(key, "selected", attrs, true, false);
        if (select) {
            visible = true;
        }
        return new AlgaSheet((int)id, name, -1, select, visible);
    }

    private AlgaGraph readGroup(String key, Map<String, String> attrs) throws SAXException {
        AlgaGroup grf = new AlgaGroup();
        return grf;
    }

    private AlgaGraph readNode(String key, Map<String, String> attrs) throws SAXException {
        String name = this.readAltaName(key, attrs);
        AltaSub sub = this._equipHandler.getSub(name);
        if (sub == null) {
            this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_CONTENT_COMPONENT_UNKNOWN", name), this.getLocator()));
            return null;
        }
        AlgaNode grf = new AlgaNode().setLogical(sub);
        grf.setNamePosition(this.readNamePosition(key, attrs));
        this.configureDraw(grf, key, attrs);
        return grf;
    }

    private AlgaGraph readPort(String key, Map<String, String> attrs) throws SAXException {
        String name = this.readAltaName(key, attrs);
        AltaFlow flow = this._equipHandler.getFlow(name);
        if (flow == null) {
            this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_CONTENT_PORT_UNKNOWN", name), this.getLocator()));
            return null;
        }
        AlgaPort grf = new AlgaPort().setFlow(flow);
        grf.setNamePosition(this.readNamePosition(key, attrs));
        grf.setAutomaticPosition(this.readBoolean(key, "location.automatic", attrs, true, false));
        this.configureDraw(grf, key, attrs);
        return grf;
    }

    private AlgaGraph readLink(String key, Map<String, String> attrs) throws SAXException {
        long id = this.readID(key, "id", attrs);
        AltaLink link = this._equipHandler.getLink(id);
        if (link == null) {
            this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_CONTENT_LINK_UNKNOWN", id), this.getLocator()));
            return null;
        }
        AlgaLink grf = new AlgaLink().setLogical(link);
        this.configureGraph(grf, key, attrs);
        grf.setDrawArrow(this.readBoolean(key, "arrow", attrs, true, false));
        String attrValue = attrs.get("style");
        if (attrValue != null && !attrValue.isEmpty()) {
            if (attrValue.equals("pipe")) {
                grf.setPipeStyle(true);
            } else if (attrValue.equals("standard")) {
                grf.setPipeStyle(false);
            } else {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "style", attrValue), this.getLocator()));
            }
        }
        return grf;
    }

    private AlgaGraph readForm(String key, Map<String, String> attrs) throws SAXException {
        AlgaForm.Type type = this.readFormType(key, attrs);
        if (type != null) {
            AlgaForm grf = new AlgaForm(type);
            this.configureForm(grf, key, attrs);
            return grf;
        }
        return null;
    }

    private AlgaGraph readIcon(String key, Map<String, String> attrs) throws SAXException {
        DBIcon dbIcon = this._equipHandler.readIcon(key, attrs);
        if (dbIcon == null) {
            return null;
        }
        AlgaImage grf = new AlgaImage().setDBIcon(dbIcon);
        this.configureDraw(grf, key, attrs);
        ImageIcon image = dbIcon.getImage();
        grf.setW(this.readPositiveInteger(key, "w", attrs, true, image.getIconWidth()));
        grf.setH(this.readPositiveInteger(key, "h", attrs, true, image.getIconHeight()));
        return grf;
    }

    private AlgaGraph readText(String key, Map<String, String> attrs) throws SAXException {
        AlgaText grf = new AlgaText();
        this.configureForm(grf, key, attrs);
        grf.setFont(this.readPositiveInteger(key, "font.size", attrs, true, 12), this.readBoolean(key, "font.bold", attrs, true, false), this.readBoolean(key, "font.italic", attrs, true, false));
        grf.setHorizontalAlignement(this.readHAlignement(key, attrs));
        grf.setVerticalAlignement(this.readVAlignement(key, attrs));
        return grf;
    }

    private AlgaGraph readPoly(String key, Map<String, String> attrs) throws SAXException {
        AlgaPolygone grf = new AlgaPolygone();
        this.configureGraph(grf, key, attrs);
        this.configureColors(grf, key, attrs);
        return grf;
    }

    private AlgaGraph readLine(String key, Map<String, String> attrs) throws SAXException {
        AlgaLine grf = new AlgaLine();
        this.configureGraph(grf, key, attrs);
        Color fore = this.readColor(key, "color.f", attrs, false);
        if (fore != null) {
            grf.setForeground(fore);
        }
        grf.setArrowBegin(this.readBoolean(key, "arrow.begin", attrs, true, false));
        grf.setArrowEnd(this.readBoolean(key, "arrow.end", attrs, true, false));
        return grf;
    }

    private Pt readPoint(String key, Map<String, String> attrs) throws SAXException {
        int x = this.readPositiveInteger(key, "x", attrs, false, 0);
        int y = this.readPositiveInteger(key, "y", attrs, false, 0);
        Pt.Style style = this.readPointStyle(key, attrs);
        return new Pt(x, y).setStyle(style);
    }

    private AlgaForm.Type readFormType(String key, Map<String, String> attrs) throws SAXException {
        AlgaForm.Type res;
        String attrValue = attrs.get("type");
        if (attrValue == null || attrValue.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "type"), this.getLocator()));
        }
        if ((res = AlgaForm.Type.fromXML(attrValue)) == null) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "text.position", attrValue), this.getLocator()));
            return null;
        }
        return res;
    }

    private NamePosition readNamePosition(String key, Map<String, String> attrs) throws SAXException {
        String attrValue = attrs.get("text.position");
        if (attrValue == null || attrValue.isEmpty()) {
            return NamePosition.TOP;
        }
        NamePosition res = NamePosition.fromXML(attrValue);
        if (res == null) {
            this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "text.position", attrValue), this.getLocator()));
            return NamePosition.TOP;
        }
        return res;
    }

    private AlgaText.VAlignement readVAlignement(String key, Map<String, String> attrs) throws SAXException {
        String attrValue = attrs.get("align.v");
        if (attrValue == null || attrValue.isEmpty()) {
            return AlgaText.VAlignement.TOP;
        }
        AlgaText.VAlignement res = AlgaText.VAlignement.fromXML(attrValue);
        if (res == null) {
            this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "align.v", attrValue), this.getLocator()));
            return AlgaText.VAlignement.TOP;
        }
        return res;
    }

    private AlgaText.HAlignement readHAlignement(String key, Map<String, String> attrs) throws SAXException {
        String attrValue = attrs.get("align.h");
        if (attrValue == null || attrValue.isEmpty()) {
            return AlgaText.HAlignement.LEFT;
        }
        AlgaText.HAlignement res = AlgaText.HAlignement.fromXML(attrValue);
        if (res == null) {
            this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "align.h", attrValue), this.getLocator()));
            return AlgaText.HAlignement.LEFT;
        }
        return res;
    }

    private Pt.Style readPointStyle(String key, Map<String, String> attrs) throws SAXException {
        String attrValue = attrs.get("style");
        if (attrValue == null || attrValue.isEmpty()) {
            return Pt.Style.NONE;
        }
        Pt.Style res = Pt.Style.fromXML(attrValue);
        if (res == null) {
            this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "style", attrValue), this.getLocator()));
            return Pt.Style.NONE;
        }
        return res;
    }

    private boolean readRotation(String key, Map<String, String> attrs) throws SAXException {
        String attrValue = attrs.get("rotate");
        if (attrValue == null || attrValue.isEmpty()) {
            return false;
        }
        int deg = Integer.MIN_VALUE;
        try {
            deg = Integer.parseInt(attrValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (deg == 90) {
            return true;
        }
        if (deg == 0) {
            return false;
        }
        this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "rotate", attrValue), this.getLocator()));
        return false;
    }

    private Color readColor(String eltName, String attrName, Map<String, String> attrs, boolean opt) throws SAXException {
        String attrValue = attrs.get(attrName);
        if (attrValue == null || attrValue.isEmpty()) {
            if (opt) {
                return null;
            }
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", eltName, attrName), this.getLocator()));
        }
        Color result = null;
        try {
            result = DBObjectXmlUtility.readColor(attrValue, opt);
            if (result == null && !opt) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException e) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", eltName, attrName, attrValue), this.getLocator()));
        }
        return result;
    }

    private void configureGraph(AlgaGraph grf, String key, Map<String, String> attrs) throws SAXException {
        grf.setLocked(this.readBoolean(key, "locked", attrs, true, false));
    }

    private void configureDraw(AlgaDraw grf, String key, Map<String, String> attrs) throws SAXException {
        this.configureGraph(grf, key, attrs);
        grf.setCX(this.readPositiveInteger(key, "cx", attrs, false, 0));
        grf.setCY(this.readPositiveInteger(key, "cy", attrs, false, 0));
        if (this.readRotation(key, attrs)) {
            grf.getTransform().add(AlgaTransform.Type.ROTATE);
        }
        if (this.readBoolean(key, "mirror.h", attrs, true, false)) {
            grf.getTransform().add(AlgaTransform.Type.MIRRORH);
        }
        if (this.readBoolean(key, "mirror.v", attrs, true, false)) {
            grf.getTransform().add(AlgaTransform.Type.MIRRORV);
        }
    }

    private void configureForm(AlgaForm grf, String key, Map<String, String> attrs) throws SAXException {
        this.configureDraw(grf, key, attrs);
        grf.setW(this.readPositiveInteger(key, "w", attrs, false, 0));
        grf.setH(this.readPositiveInteger(key, "h", attrs, false, 0));
        this.configureColors(grf, key, attrs);
    }

    private void configureColors(AlgaGraph grf, String key, Map<String, String> attrs) throws SAXException {
        Color back = this.readColor(key, "color.b", attrs, true);
        if (back != null) {
            grf.setOpaque(true).setBackground(back);
        } else {
            grf.setOpaque(false);
        }
        Color fore = this.readColor(key, "color.f", attrs, false);
        if (fore != null) {
            grf.setForeground(fore);
        }
    }
}

