/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.io;

import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaImage;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLine;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPolygone;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaSheet;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaText;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.AlgaContentConstantXml;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;

public class AlgaContentWriterXml
implements DBObjectXmlConstant,
AlgaContentConstantXml {
    private static Logger _LOG = Logger.getLogger(AlgaContentWriterXml.class.getPackage().getName());
    Appendable _out;
    AltaEquipment _equip;
    AlgaContent _content;

    public AlgaContentWriterXml(Appendable out, AlgaContent content, AltaEquipment equip) {
        this._out = out;
        this._content = content;
        this._equip = equip;
    }

    public void write(String indent) throws IOException {
        this._out.append(indent).append("<").append("alga.view").append(" id='0'>\n");
        String indent1 = indent + "  ";
        AlgaSheet current = this._content.getCurrentSheet();
        for (AlgaSheet sheet : this._content.getSheets()) {
            sheet.setSelected(sheet == current);
            this.writeSheet(sheet, indent1);
        }
        this._out.append(indent).append("</").append("alga.view").append(">\n");
    }

    private void writeSheet(AlgaSheet sheet, String indent) throws IOException {
        Collection<AlgaGraph> graphs = sheet.getGraphs();
        this._out.append(indent).append("<").append("alga.sheet");
        this._out.append(" ").append("id").append("='").append(Integer.toString(sheet.getNumber())).append("'");
        DBObjectXmlUtility.appendXML(this._out.append(" ").append("name").append("='"), sheet.getName()).append("'");
        this._out.append(" ").append("visible").append("='").append(Boolean.toString(sheet.isVisible())).append("'");
        if (sheet.isSelected()) {
            this._out.append(" ").append("selected").append("='true'");
        }
        if (graphs.size() > 0) {
            this._out.append(">\n");
            String indent1 = indent + "  ";
            for (AlgaGraph graph : graphs) {
                if (this.writeGraph(graph, indent1)) continue;
                _LOG.severe("An AlgaGraph has not been writed: " + graph.toString());
            }
            this._out.append(indent).append("</").append("alga.sheet").append(">\n");
        } else {
            this._out.append("/>\n");
        }
    }

    private boolean writeGraph(AlgaGraph graph, String indent) throws IOException {
        if (graph instanceof AlgaDraw) {
            if (graph instanceof AlgaForm) {
                if (graph instanceof AlgaText) {
                    return this.writeText((AlgaText)graph, indent);
                }
                if (graph instanceof AlgaImage) {
                    return this.writeIcon((AlgaImage)graph, indent);
                }
                return this.writeForm((AlgaForm)graph, indent);
            }
            if (graph instanceof AlgaNode) {
                return this.writeNode((AlgaNode)graph, indent);
            }
            if (graph instanceof AlgaPort) {
                return this.writePort((AlgaPort)graph, indent);
            }
        } else if (graph instanceof AlgaPoints) {
            if (graph instanceof AlgaPolygone) {
                return this.writePolygone((AlgaPolygone)graph, indent);
            }
            if (graph instanceof AlgaLine) {
                return this.writeLine((AlgaLine)graph, indent);
            }
            if (graph instanceof AlgaLink) {
                return this.writeLink((AlgaLink)graph, indent);
            }
        } else if (graph instanceof AlgaGroup) {
            return this.writeGroup((AlgaGroup)graph, indent);
        }
        return false;
    }

    private boolean writeGroup(AlgaGroup group, String indent) throws IOException {
        this._out.append(indent).append("<").append("alga.group").append(">\n");
        String indent1 = indent + "  ";
        for (AlgaGraph graph : group.getGraphs()) {
            if (this.writeGraph(graph, indent1)) continue;
            _LOG.severe("An AlgaGraph has not been writed: " + graph.toString());
        }
        this._out.append(indent).append("</").append("alga.group").append(">\n");
        return true;
    }

    private boolean writeNode(AlgaNode grf, String indent) throws IOException {
        this._out.append(indent).append("<").append("alga.node");
        DBObjectXmlUtility.appendXML(this._out.append(" ").append("name").append("='"), grf.getLogical().getName()).append("'");
        this.writeAttrsDraw(grf);
        this._out.append(" ").append("text.position").append("='").append(grf.getNamePosition().toXML()).append("'");
        this._out.append("/>\n");
        return true;
    }

    private boolean writePort(AlgaPort grf, String indent) throws IOException {
        this._out.append(indent).append("<").append("alga.port");
        DBObjectXmlUtility.appendXML(this._out.append(" ").append("name").append("='"), grf.getFlow().getName()).append("'");
        this.writeAttrsDraw(grf);
        this._out.append(" ").append("text.position").append("='").append(grf.getNamePosition().toXML()).append("'");
        if (grf.isAutomaticPosition()) {
            this._out.append(" ").append("location.automatic").append("='true'");
        }
        this._out.append("/>\n");
        return true;
    }

    private boolean writeLink(AlgaLink grf, String indent) throws IOException {
        this._out.append(indent).append("<").append("alga.link");
        this._out.append(" ").append("id").append("='").append(Long.toString(grf.getLogical().getID())).append("'");
        if (grf.isLocked()) {
            this._out.append(" ").append("locked").append("='true'");
        }
        if (grf.isDrawArrow()) {
            this._out.append(" ").append("arrow").append("='true'");
        }
        if (grf.isPipeStyle()) {
            this._out.append(" ").append("style").append("='pipe'");
        }
        if (grf.getPoints().size() > 0) {
            this._out.append(">\n");
            this.writePoints(grf, indent + "  ");
            this._out.append(indent).append("</").append("alga.link").append(">\n");
        } else {
            this._out.append("/>\n");
        }
        return true;
    }

    private boolean writeForm(AlgaForm grf, String indent) throws IOException {
        this._out.append(indent).append("<").append("alga.form");
        DBObjectXmlUtility.appendXML(this._out.append(" ").append("type").append("='"), grf.getType().toXML()).append("'");
        this.writeAttrsForm(grf);
        this._out.append("/>\n");
        return true;
    }

    private boolean writeIcon(AlgaImage grf, String indent) throws IOException {
        if (grf.getDBIcon() == null) {
            _LOG.warning("Icon is undefined");
            return false;
        }
        this._out.append(indent).append("<").append("alga.icon");
        DBObjectXmlUtility.writeDBFolder(this._out, grf.getDBIcon().getDBFolder(), null);
        this.writeAttrsDraw(grf);
        this._out.append(" ").append("w").append("='").append(Integer.toString(grf.getW())).append("'");
        this._out.append(" ").append("h").append("='").append(Integer.toString(grf.getH())).append("'");
        this._out.append("/>\n");
        return true;
    }

    private boolean writeText(AlgaText grf, String indent) throws IOException {
        this._out.append(indent).append("<").append("alga.text");
        this.writeAttrsForm(grf);
        this._out.append(" ").append("font.size").append("='").append(Integer.toString(grf.getFontSize())).append("'");
        if (grf.isFontBold()) {
            this._out.append(" ").append("font.bold").append("='true'");
        }
        if (grf.isFontItalic()) {
            this._out.append(" ").append("font.italic").append("='true'");
        }
        DBObjectXmlUtility.appendXML(this._out.append(" ").append("align.h").append("='"), grf.getHorizontalAlignement().toXML()).append("'");
        DBObjectXmlUtility.appendXML(this._out.append(" ").append("align.v").append("='"), grf.getVerticalAlignement().toXML()).append("'");
        this._out.append(">");
        DBObjectXmlUtility.appendXML(this._out, grf.getText());
        this._out.append("</").append("alga.text").append(">\n");
        return true;
    }

    private boolean writePolygone(AlgaPolygone grf, String indent) throws IOException {
        this._out.append(indent).append("<").append("alga.poly");
        if (grf.isLocked()) {
            this._out.append(" ").append("locked").append("='true'");
        }
        DBObjectXmlUtility.writeAttrColor(this._out, "color.b", grf.isOpaque(), grf.getBackground());
        DBObjectXmlUtility.writeAttrColor(this._out, "color.f", true, grf.getForeground());
        this._out.append(">\n");
        this.writePoints(grf, indent + "  ");
        this._out.append(indent).append("</").append("alga.poly").append(">\n");
        return true;
    }

    private boolean writeLine(AlgaLine grf, String indent) throws IOException {
        this._out.append(indent).append("<").append("alga.line");
        if (grf.isLocked()) {
            this._out.append(" ").append("locked").append("='true'");
        }
        DBObjectXmlUtility.writeAttrColor(this._out, "color.f", true, grf.getForeground());
        if (grf.isArrowBegin()) {
            this._out.append(" ").append("arrow.begin").append("='true'");
        }
        if (grf.isArrowEnd()) {
            this._out.append(" ").append("arrow.end").append("='true'");
        }
        this._out.append(">\n");
        this.writePoints(grf, indent + "  ");
        this._out.append(indent).append("</").append("alga.line").append(">\n");
        return true;
    }

    private void writePoints(AlgaPoints grf, String indent) throws IOException {
        for (Pt pt : grf.getPoints()) {
            this._out.append(indent).append("<").append("alga.point");
            this._out.append(" ").append("x").append("='").append(Integer.toString(pt.getX())).append("'");
            this._out.append(" ").append("y").append("='").append(Integer.toString(pt.getY())).append("'");
            if (pt.getStyle() != Pt.Style.NONE) {
                this._out.append(" ").append("style").append("='").append(pt.getStyle().toXML()).append("'");
            }
            this._out.append("/>\n");
        }
    }

    private void writeAttrsDraw(AlgaDraw grf) throws IOException {
        if (grf.isLocked()) {
            this._out.append(" ").append("locked").append("='true'");
        }
        this._out.append(" ").append("cx").append("='").append(Integer.toString(grf.getCX())).append("'");
        this._out.append(" ").append("cy").append("='").append(Integer.toString(grf.getCY())).append("'");
        if (grf.getTransform().isRotate()) {
            this._out.append(" ").append("rotate").append("='90'");
        }
        if (grf.getTransform().isMirrorH()) {
            this._out.append(" ").append("mirror.h").append("='true'");
        }
        if (grf.getTransform().isMirrorV()) {
            this._out.append(" ").append("mirror.v").append("='true'");
        }
    }

    private void writeAttrsForm(AlgaForm grf) throws IOException {
        this.writeAttrsDraw(grf);
        this._out.append(" ").append("w").append("='").append(Integer.toString(grf.getW())).append("'");
        this._out.append(" ").append("h").append("='").append(Integer.toString(grf.getH())).append("'");
        DBObjectXmlUtility.writeAttrColor(this._out, "color.b", grf.isOpaque(), grf.getBackground());
        DBObjectXmlUtility.writeAttrColor(this._out, "color.f", true, grf.getForeground());
    }
}

