/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.io.DBComponentHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.AlgaContentHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.DBAltaSynchroHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBEquipmentHandlerXml
extends DBComponentHandlerXml {
    private static Logger _LOG = Logger.getLogger(DBEquipmentHandlerXml.class.getPackage().getName());
    public static final String ELT_CEC_EQUIPMENT = "cec.equipment";
    public static final String ELT_ALTA_SYNC = "alta.sync";
    public static final String ELT_ALTA_SUB = "alta.sub";
    public static final String ELT_ALTA_LINK = "alta.link";
    public static final String ATT_LINK_FROM = "from";
    public static final String ATT_LINK_TO = "to";
    public static final String ATT_LINK_WITH_ERROR = "withError";
    Map<String, AltaSynchro> _mapSyncs = new LinkedHashMap<String, AltaSynchro>();
    Map<String, AltaSub> _mapSubs = new LinkedHashMap<String, AltaSub>();
    Map<String, AltaSub> _mapSubsWithGraph = new LinkedHashMap<String, AltaSub>();
    Map<Long, AltaLink> _mapLinks = new LinkedHashMap<Long, AltaLink>();
    Map<Long, AltaLink> _mapLinksWithGraph = new LinkedHashMap<Long, AltaLink>();
    AlgaContent _content = null;
    protected String _topElement = "cec.equipment";
    protected DBAltaSynchroHandlerXml _syncHandler = null;
    protected AlgaContentHandlerXml _contentHandler = null;
    private static final String _REGEX_ACCESS_PORT = "(([a-zA-Z_][a-zA-Z0-9_]*)\\.)?(([a-zA-Z_][a-zA-Z0-9_]*)(\\[([0-9]+)\\])?)(\\^(([a-zA-Z_][a-zA-Z0-9_]*)(\\[([0-9]+)\\])?))?";
    private static final Pattern _PATTERN_ACCESS_PORT = Pattern.compile("(([a-zA-Z_][a-zA-Z0-9_]*)\\.)?(([a-zA-Z_][a-zA-Z0-9_]*)(\\[([0-9]+)\\])?)(\\^(([a-zA-Z_][a-zA-Z0-9_]*)(\\[([0-9]+)\\])?))?");

    public DBEquipmentHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory cecFactory) {
        super(manager, locator, cecFactory);
    }

    public DBEquipmentHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory cecFactory, String topElement) {
        this(manager, locator, cecFactory);
        this._topElement = topElement;
    }

    public Collection<AltaSynchro> getSyncs() {
        return this._mapSyncs.values();
    }

    public Collection<AltaSub> getSubs() {
        if (this._mapSubsWithGraph.size() < this._mapSubs.size()) {
            _LOG.warning("Presence de sub(s) logique(s) sans lien graphique : " + (this._mapSubs.size() - this._mapSubsWithGraph.size()));
            for (Map.Entry<String, AltaSub> entry : this._mapSubs.entrySet()) {
                if (this._mapSubsWithGraph.containsKey(entry.getKey())) continue;
                _LOG.fine("Sub supprime : " + entry.getValue().toString());
            }
        }
        return this._mapSubsWithGraph.values();
    }

    public Collection<AltaLink> getLinks() {
        if (this._mapLinksWithGraph.size() < this._mapLinks.size()) {
            _LOG.warning("Presence de lien(s) logique(s) sans lien graphique : " + (this._mapLinks.size() - this._mapLinksWithGraph.size()));
            for (Map.Entry<Long, AltaLink> entry : this._mapLinks.entrySet()) {
                if (this._mapLinksWithGraph.containsKey(entry.getKey())) continue;
                _LOG.fine("Lien supprime : " + entry.getValue().toString());
            }
        }
        return this._mapLinksWithGraph.values();
    }

    public AlgaContent getContent() {
        return this._content;
    }

    AltaSub getSub(String name) {
        AltaSub sub = this._mapSubs.get(name);
        if (sub != null) {
            this._mapSubsWithGraph.put(name, sub);
        }
        return sub;
    }

    AltaLink getLink(long id) {
        AltaLink link = this._mapLinks.get(id);
        if (link != null) {
            this._mapLinksWithGraph.put(id, link);
        }
        return link;
    }

    @Override
    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._syncHandler != null) {
            this._syncHandler.startAction(key, attrs, false);
        } else if (this._contentHandler != null) {
            this._contentHandler.startAction(key, attrs, false);
        } else if (startAction) {
            if (!this._topElement.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", this._topElement), this.getLocator()));
            }
            this.readAttributesComponent(key, attrs);
        } else {
            this.startEquipmentAction(key, attrs, startAction);
        }
    }

    protected void startEquipmentAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (ELT_ALTA_SUB.equals(key)) {
            AltaSub sub = this.readSub(key, attrs);
            if (sub != null) {
                String name = sub.getName();
                if (this._mapSubs.containsKey(name)) {
                    this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_SUB_ALREADY", name), this.getLocator()));
                }
                this._mapSubs.put(name, sub);
            }
        } else if (ELT_ALTA_LINK.equals(key)) {
            AltaLink link = this.readLink(key, attrs);
            if (link != null) {
                Long id = link.getID();
                if (this._mapLinks.containsKey(id)) {
                    this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_ALREADY", id), this.getLocator()));
                }
                this._mapLinks.put(id, link);
            }
        } else if (ELT_ALTA_SYNC.equals(key)) {
            this._syncHandler = new DBAltaSynchroHandlerXml(this.getLogManager(), this.getLocator(), this._cecFactory, this);
            this._syncHandler.startAction(key, attrs, true);
        } else if ("alga.view".equals(key)) {
            this._contentHandler = new AlgaContentHandlerXml(this.getLogManager(), this.getLocator(), this);
            this._contentHandler.startAction(key, attrs, true);
        } else {
            this.startComponentAction(key, attrs, startAction);
        }
    }

    @Override
    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        boolean result;
        if (this._syncHandler != null) {
            boolean result2 = this._syncHandler.endAction(key, attrs, txt);
            if (result2) {
                if (ELT_ALTA_SYNC.equals(key)) {
                    AltaSynchro event = this._syncHandler.getEvent();
                    if (event != null) {
                        String name = event.getName();
                        if (this._mapSyncs.containsKey(name)) {
                            this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_SYNC_ALREADY", name), this.getLocator()));
                        }
                        this._mapSyncs.put(name, event);
                    }
                } else {
                    _LOG.severe("Erreur interne \u00e0 la fermeture de l'\u00e9l\u00e9ment '" + key + "'");
                }
                this._syncHandler = null;
            }
            return false;
        }
        if (this._contentHandler != null && (result = this._contentHandler.endAction(key, attrs, txt))) {
            if ("alga.view".equals(key)) {
                this._content = new AlgaContent();
                this._content.setSheets(this._contentHandler.getSheets());
            } else {
                _LOG.severe("Erreur interne \u00e0 la fermeture de l'\u00e9l\u00e9ment '" + key + "'");
            }
            this._contentHandler = null;
        }
        if ("alta.code".equals(key)) {
            this._code = txt;
        }
        return this._topElement.equals(key);
    }

    protected AltaSub readSub(String key, Map<String, String> attrs) throws SAXException {
        String name = this.readAltaName(key, attrs);
        long refID = this.readID(name, "refID", attrs);
        DAOFolder daoFolder = this._cecFactory.createFolderDAO();
        DBFolder dbFolder = (DBFolder)daoFolder.find(refID);
        if (dbFolder == null) {
            String refPath = attrs.get("refPath");
            if (refPath == null || refPath.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "refPath"), this.getLocator()));
            }
            if ((dbFolder = daoFolder.findFolder("COMPONENT_FAMILIES", refPath)) == null) {
                dbFolder = daoFolder.findFolder("EQUIPMENT_FAMILIES", refPath);
            }
            if (dbFolder == null) {
                this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_SUB_NOREF", refPath), this.getLocator()));
            }
        }
        if (dbFolder != null) {
            DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap != null) {
                return new AltaSub((AltaComponent)dbWrap, name);
            }
            this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_SUB_READ", dbFolder.getRefPath()), this.getLocator()));
        }
        return null;
    }

    protected AltaLink readLink(String key, Map<String, String> attrs) throws SAXException {
        long id = this.readID(key, "id", attrs);
        AltaLink link = new AltaLink().setID(id);
        PortReader portReader = new PortReader();
        if (!portReader.read(key, ATT_LINK_FROM, attrs, id)) {
            return null;
        }
        link.setFrom(portReader._sub, portReader._flow, portReader._field);
        if (!portReader.read(key, ATT_LINK_TO, attrs, id)) {
            return null;
        }
        link.setTo(portReader._sub, portReader._flow, portReader._field);
        return link;
    }

    class PortReader {
        AltaSub _sub = null;
        AltaFlow _flow = null;
        DBRecordField _field = null;

        PortReader() {
        }

        boolean read(String eltName, String attrName, Map<String, String> attrs, long idLink) throws SAXException {
            String str;
            int id;
            Matcher matchFrom;
            this._sub = null;
            this._flow = null;
            this._field = null;
            String attr = attrs.get(attrName);
            if (attr == null || attr.isEmpty()) {
                DBEquipmentHandlerXml.this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", eltName, attrName), DBEquipmentHandlerXml.this.getLocator()));
            }
            if (!(matchFrom = _PATTERN_ACCESS_PORT.matcher(attr)).matches()) {
                DBEquipmentHandlerXml.this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", eltName, attrName, attr), DBEquipmentHandlerXml.this.getLocator()));
                return false;
            }
            String name = matchFrom.group(2);
            if (name != null && !name.isEmpty()) {
                this._sub = DBEquipmentHandlerXml.this._mapSubs.get(name);
                if (this._sub == null) {
                    DBEquipmentHandlerXml.this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_ERR", idLink, attr), DBEquipmentHandlerXml.this.getLocator()));
                    return false;
                }
            }
            if ((name = matchFrom.group(4)) == null || name.isEmpty()) {
                DBEquipmentHandlerXml.this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", eltName, attrName, attr), DBEquipmentHandlerXml.this.getLocator()));
                return false;
            }
            if (this._sub != null) {
                AltaComponent node = this._sub.getNode();
                id = -1;
                str = matchFrom.group(6);
                if (str == null) {
                    id = -2;
                } else if (!str.isEmpty()) {
                    try {
                        id = Integer.parseInt(str);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (id == -2) {
                    this._flow = node.getFlow(name);
                    if (this._flow == null) {
                        this._flow = node.getFlowWithID(0L);
                    }
                } else if (id >= 0) {
                    this._flow = node.getFlowWithID(id);
                }
                if (this._flow == null) {
                    this._flow = node.getFlow(name);
                }
            } else {
                this._flow = (AltaFlow)DBEquipmentHandlerXml.this._mapFlows.get(name);
            }
            if (this._flow == null) {
                DBEquipmentHandlerXml.this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_ERR", idLink, attr), DBEquipmentHandlerXml.this.getLocator()));
                return false;
            }
            name = matchFrom.group(9);
            if (name == null || name.isEmpty()) {
                return true;
            }
            if (this._flow.getType() instanceof DBRecord) {
                DBRecord type = (DBRecord)this._flow.getType();
                id = -1;
                str = matchFrom.group(11);
                if (str != null && !str.isEmpty()) {
                    try {
                        id = Integer.parseInt(str);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (id >= 0) {
                    this._field = type.getFieldWithID(id);
                }
                if (this._field == null) {
                    this._field = type.getValue(name);
                }
            } else {
                this._field = new DBRecordField(name, AltaTypeBool.getInstance());
            }
            if (this._field == null) {
                DBEquipmentHandlerXml.this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_LINK_ERR", idLink, attr), DBEquipmentHandlerXml.this.getLocator()));
                return false;
            }
            return true;
        }
    }
}

