/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.equipment.io;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.icon.DBIcon;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.ParamValue;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.io.LawParser;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.NamePosition;
import com.dassault.cecilia.dbobj.mbsa.component.io.DBComponentReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContainer;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaDraw;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaForm;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGroup;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaImage;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLine;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPoints;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPolygone;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaPort;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaText;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaTransform;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.Pt;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.modellaw.DBModelLaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.io.ocas51.CoreUtil;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBEquipmentReaderRaw
extends DBComponentReaderRaw {
    private static Logger _LOG = Logger.getLogger(DBEquipmentReaderRaw.class.getPackage().getName());
    Map<String, AltaSynchro> _mapSyncs = new LinkedHashMap<String, AltaSynchro>();
    Map<String, AltaSub> _mapSubs = new LinkedHashMap<String, AltaSub>();
    List<AltaLink> _lstLink = new ArrayList<AltaLink>();
    protected static final int DELTA_XY = 3;

    public DBEquipmentReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        super(dbFolder, logMng);
    }

    public Collection<AltaSynchro> getSyncs() {
        return this._mapSyncs.values();
    }

    public Collection<AltaSub> getSubs() {
        return this._mapSubs.values();
    }

    public Collection<AltaLink> getLinks() {
        return this._lstLink;
    }

    @Override
    protected void readSync(BufferedReader inData, String line, CECFactory cecFactory) throws IOException {
        String code;
        String eltLaw;
        String name = "";
        Law law = null;
        DBModelLaw dbModelLaw = null;
        int position = line.indexOf("name=");
        if (position != -1) {
            name = CoreUtil.searchString(line.substring(position));
        }
        if ((position = line.indexOf("law=")) != -1 && !(eltLaw = CoreUtil.searchString(line.substring(position))).isEmpty()) {
            if (FRB_PATH.matcher(eltLaw).matches()) {
                dbModelLaw = this.readDBModelLawFromPath(eltLaw, cecFactory, name);
            } else {
                LawParser lawParser = this.createLawParser(cecFactory);
                law = lawParser.parseLaw(eltLaw);
                if (law == null) {
                    lawParser.traceError(this._logManager, name, eltLaw, _LOG, true);
                }
            }
        }
        AltaSynchro synchro = new AltaSynchro(name);
        synchro.setOccurrence(law);
        synchro.setModelLaw(dbModelLaw);
        position = line.indexOf("type=");
        if (position != -1) {
            AltaSynchro.Type type = null;
            code = CoreUtil.searchString(line.substring(position));
            try {
                switch (Integer.parseInt(code)) {
                    case 0: {
                        type = AltaSynchro.Type.CCF;
                        break;
                    }
                    case 1: {
                        type = AltaSynchro.Type.DIFF;
                        break;
                    }
                    case 2: {
                        type = AltaSynchro.Type.MEC;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (type == null) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_CCF_TYPE", code, name));
            } else {
                synchro.setType(type);
            }
        }
        if ((position = line.indexOf("inspected=")) != -1) {
            float delay = Float.NaN;
            code = CoreUtil.searchString(line.substring(position));
            try {
                delay = Float.parseFloat(code);
                if (delay >= 0.0f) {
                    synchro.setInspected(new ParamValue(TypeParam.DELAY, delay));
                } else {
                    delay = Float.NaN;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (Float.isNaN(delay)) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_CCF_INSPECTED", code, name));
            }
        }
        if ((position = Math.max(line.indexOf("inflighttested="), line.indexOf("inflight-tested="))) != -1) {
            float delay = Float.NaN;
            code = CoreUtil.searchString(line.substring(position));
            try {
                delay = Float.parseFloat(code);
                if (delay >= 0.0f) {
                    synchro.setInflightTested(new ParamValue(TypeParam.DELAY, delay));
                } else {
                    delay = Float.NaN;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (Float.isNaN(delay)) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_CCF_EXPOSED", code, name));
            }
        }
        this._mapSyncs.put(name, synchro);
        while ((line = inData.readLine()) != null && line.indexOf("</synchro>") == -1) {
            if (line.indexOf("<transition") == -1) continue;
            synchro.addTransition(CoreUtil.searchString(line, "name="));
        }
    }

    @Override
    protected void readContent(BufferedReader inData, String line, String endBalise, CECFactory cecFactory) throws IOException {
        while ((line = inData.readLine()) != null) {
            int position = line.indexOf("<");
            if (position == -1) continue;
            if (line.indexOf("<systemLaw>") == 0) {
                this.readSystemLaw(inData, line);
                continue;
            }
            if (line.indexOf("<synchro") == 0) {
                this.readSync(inData, line, cecFactory);
                continue;
            }
            if ((position = (line = line.substring(position + 1)).indexOf(" ")) == -1) {
                if (line.indexOf(endBalise) != 0) continue;
                break;
            }
            String flag = line.substring(0, position);
            if (flag.equals("component")) {
                this.loadComponent(line, inData, cecFactory);
                continue;
            }
            if (flag.equals("equipment")) {
                this.loadEquipment(line, inData, cecFactory);
                continue;
            }
            if (flag.equals("graphic_form")) {
                this.loadGraphicForm(line, inData, null, true, cecFactory);
                continue;
            }
            if (flag.equals("graphic_group")) {
                this.loadGraphicGroup(line, inData, null, true, cecFactory);
                continue;
            }
            if (flag.equals("equipment_port")) {
                this.loadEquipmentPort(line, inData);
                continue;
            }
            if (!flag.equals("link")) continue;
            this.loadLink(line, inData);
        }
    }

    protected void readSystemLaw(BufferedReader inData, String line) throws IOException {
        StringBuilder sbCode;
        String code = this.readText(inData, line, "</systemLaw>").trim();
        if (this._code != null) {
            sbCode = new StringBuilder(this._code.length() + code.length() + 16);
            if (!this._code.isEmpty()) {
                this.logMsg(Level.FINE, "Doublon de definition du code AltaRica");
                sbCode.append(this._code).append("\n");
            }
        } else {
            sbCode = new StringBuilder(code.length() + 16);
        }
        if (code.trim().length() > 0) {
            if (!code.trim().startsWith("assert")) {
                sbCode.append("assert\n");
            }
            sbCode.append(code);
        }
        this._code = sbCode.toString();
    }

    protected void loadComponent(String currentLine, BufferedReader inData, CECFactory cecFactory) throws IOException {
        AltaComponent component = null;
        String name = "";
        String modelName = "";
        int x = 0;
        int y = 0;
        int sheetLocation = 1;
        boolean locked = false;
        NamePosition textLocation = NamePosition.TOP;
        int position = currentLine.indexOf(" name=");
        if (position != -1) {
            name = CoreUtil.searchString(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" model=")) != -1) {
            modelName = CoreUtil.searchString(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" x=")) != -1) {
            x = CoreUtil.searchValue(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" y=")) != -1) {
            y = CoreUtil.searchValue(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" sheet=")) != -1) {
            sheetLocation = CoreUtil.searchValue(currentLine.substring(position));
        }
        locked = currentLine.indexOf("locked>") != -1;
        position = currentLine.indexOf(" idExternLaetitia=");
        if (position != -1) {
            CoreUtil.searchString(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" textLocation=")) != -1) {
            switch (CoreUtil.searchValue(currentLine.substring(position))) {
                default: {
                    textLocation = NamePosition.TOP;
                    break;
                }
                case 1: {
                    textLocation = NamePosition.BOTTOM;
                    break;
                }
                case 2: {
                    textLocation = NamePosition.LEFT;
                    break;
                }
                case 3: {
                    textLocation = NamePosition.RIGHT;
                    break;
                }
                case 4: {
                    textLocation = NamePosition.CENTER;
                }
            }
        }
        DBFolder dbFolder = null;
        position = currentLine.indexOf(" modelId=");
        if (position != -1) {
            int modelId = CoreUtil.searchValue(currentLine.substring(position));
            long id = cecFactory.createUtilityDAO().convertMigrationOldIDObjectToIDFolder(modelId);
            if (id == -1L) {
                this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", modelId));
            } else {
                dbFolder = (DBFolder)cecFactory.createFolderDAO().find(id);
                if (dbFolder == null) {
                    this.logMsg(Level.WARNING, "L'ID d'equivalence est invalide lors de la lecture d'un objet => utilisation du path en secours: " + id);
                }
            }
        }
        if (dbFolder == null && !modelName.isEmpty()) {
            dbFolder = cecFactory.createFolderDAO().findFolder("COMPONENT_FAMILIES", modelName);
        }
        if (dbFolder != null) {
            DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_COMPONENT_READ", dbFolder.getRefPath()));
            } else {
                component = (AltaComponent)dbWrap;
            }
        }
        if (component == null) {
            this._logManager.addLog(DBLogs.DBLevel.ERROR, ResMsgOcas.msgFormat("MSG_RAW_COMPONENT_UNKNOWN", modelName, name));
        } else if (!name.equals("")) {
            AltaSub sub = new AltaSub(component, name);
            AltaSub oldSub = this._mapSubs.put(name, sub);
            if (oldSub != null) {
                this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_COMPONENT_ALREADY", name));
            }
            AlgaNode grafNode = new AlgaNode().setLogical(sub);
            grafNode.setNamePosition(textLocation).setLocked(locked);
            this.getSheet(sheetLocation).add(grafNode, -1);
            this.loadGraphicSet(grafNode, inData, "/component", null);
            this.setCenterXY(grafNode, x, y, sub.getNode().getWidth(), sub.getNode().getHeight(), name);
        }
    }

    protected void setCenterXY(AlgaDraw graf, int x, int y, int w, int h, String name) {
        int cx = x + 3;
        int cy = y + 3;
        if (graf.getTransform().isRotate()) {
            cx += h / 2;
            cy += w / 2;
        } else {
            cx += w / 2;
            cy += h / 2;
        }
        graf.setCX(cx).setCY(cy);
    }

    protected void loadEquipment(String currentLine, BufferedReader inData, CECFactory cecFactory) throws IOException {
        AltaEquipment equipment = null;
        String name = "";
        String modelName = "";
        int x = 0;
        int y = 0;
        int sheetLocation = 1;
        boolean locked = false;
        NamePosition textLocation = NamePosition.TOP;
        int position = currentLine.indexOf(" name=");
        if (position != -1) {
            name = CoreUtil.searchString(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" model=")) != -1) {
            modelName = CoreUtil.searchString(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" x=")) != -1) {
            x = CoreUtil.searchValue(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" y=")) != -1) {
            y = CoreUtil.searchValue(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" sheet=")) != -1) {
            sheetLocation = CoreUtil.searchValue(currentLine.substring(position));
        }
        locked = currentLine.indexOf("locked>") != -1;
        position = currentLine.indexOf(" idExternLaetitia=");
        if (position != -1) {
            CoreUtil.searchString(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" textLocation=")) != -1) {
            switch (CoreUtil.searchValue(currentLine.substring(position))) {
                default: {
                    textLocation = NamePosition.TOP;
                    break;
                }
                case 1: {
                    textLocation = NamePosition.BOTTOM;
                    break;
                }
                case 2: {
                    textLocation = NamePosition.LEFT;
                    break;
                }
                case 3: {
                    textLocation = NamePosition.RIGHT;
                    break;
                }
                case 4: {
                    textLocation = NamePosition.CENTER;
                }
            }
        }
        DBFolder dbFolder = null;
        position = currentLine.indexOf(" modelId=");
        if (position != -1) {
            int modelId = CoreUtil.searchValue(currentLine.substring(position));
            long id = cecFactory.createUtilityDAO().convertMigrationOldIDObjectToIDFolder(modelId);
            if (id == -1L) {
                this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgObj.msgFormat("MSG_RAW_IDMIGRATION_UNKNOWN", modelId));
            } else {
                dbFolder = (DBFolder)cecFactory.createFolderDAO().find(id);
                if (dbFolder == null) {
                    this.logMsg(Level.WARNING, "L'ID d'equivalence est invalide lors de la lecture d'un objet => utilisation du path en secours: " + id);
                }
            }
        }
        if (dbFolder == null && !modelName.isEmpty()) {
            dbFolder = cecFactory.createFolderDAO().findFolder("EQUIPMENT_FAMILIES", modelName);
        }
        if (dbFolder != null) {
            DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_EQUIPMENT_READ", dbFolder.getRefPath()));
            } else {
                equipment = (AltaEquipment)dbWrap;
            }
        }
        if (equipment == null) {
            this._logManager.addLog(DBLogs.DBLevel.ERROR, ResMsgOcas.msgFormat("MSG_RAW_EQUIPMENT_UNKNOWN", modelName, name));
        } else if (!name.equals("")) {
            AltaSub sub = new AltaSub(equipment, name);
            AltaSub oldSub = this._mapSubs.put(name, sub);
            if (oldSub != null) {
                this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_COMPONENT_ALREADY", name));
            }
            AlgaNode grafNode = new AlgaNode().setLogical(sub);
            grafNode.setLocked(locked);
            grafNode.setNamePosition(textLocation);
            this.getSheet(sheetLocation).add(grafNode, -1);
            this.loadGraphicSet(grafNode, inData, "/equipment", null);
            this.setCenterXY(grafNode, x, y, sub.getNode().getWidth(), sub.getNode().getHeight(), name);
        }
    }

    protected void loadEquipmentPort(String currentLine, BufferedReader inData) throws IOException {
        String name = "";
        int x = 0;
        int y = 0;
        int sheetLocation = 1;
        boolean locked = false;
        NamePosition textLocation = NamePosition.TOP;
        int position = currentLine.indexOf(" name=");
        if (position != -1) {
            name = CoreUtil.searchString(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" x=")) != -1) {
            x = CoreUtil.searchValue(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" y=")) != -1) {
            y = CoreUtil.searchValue(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" sheet=")) != -1) {
            sheetLocation = CoreUtil.searchValue(currentLine.substring(position));
        }
        locked = currentLine.indexOf("locked>") != -1;
        position = currentLine.indexOf(" idExternLaetitia=");
        if (position != -1) {
            CoreUtil.searchString(currentLine.substring(position));
        }
        if ((position = currentLine.indexOf(" textLocation=")) != -1) {
            switch (CoreUtil.searchValue(currentLine.substring(position))) {
                default: {
                    textLocation = NamePosition.TOP;
                    break;
                }
                case 1: {
                    textLocation = NamePosition.BOTTOM;
                    break;
                }
                case 2: {
                    textLocation = NamePosition.LEFT;
                    break;
                }
                case 3: {
                    textLocation = NamePosition.RIGHT;
                    break;
                }
                case 4: {
                    textLocation = NamePosition.CENTER;
                }
            }
        }
        if (name.startsWith("#")) {
            name = name.substring(1);
        }
        AlgaPort port = null;
        AltaFlow flow = (AltaFlow)this._mapPorts.get(name);
        if (flow == null) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_EQUIPMENT_PORT_UNKNOWN", name));
        } else if (flow.getOrientation() == AltaFlow.Orientation.LOCAL) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_EQUIPMENT_PORT_LOCAL", name));
        } else {
            port = new AlgaPort().setFlow(flow).setAutomaticPosition(false);
        }
        this.loadGraphicSet(port, inData, "/equipment_port", null);
        if (port != null) {
            port.setLocked(locked);
            this.getSheet(sheetLocation).add(port, -1);
            port.setNamePosition(textLocation);
            this.setCenterXY(port, x, y, port.getW(), port.getH(), flow.getName());
        }
    }

    protected void loadLink(String currentLine, BufferedReader inData) throws IOException {
        PortReader from = new PortReader();
        PortReader to = new PortReader();
        int sheetLocation = 1;
        boolean locked = false;
        boolean arrow = false;
        boolean pipe = false;
        int position = currentLine.indexOf(" sheet=");
        if (position != -1) {
            sheetLocation = CoreUtil.searchValue(currentLine.substring(position));
        }
        from.read(currentLine, " fromId=", " from=");
        to.read(currentLine, " toId=", " to=");
        locked = currentLine.substring(currentLine.lastIndexOf("\"")).indexOf("locked") != -1;
        arrow = currentLine.substring(currentLine.lastIndexOf("\"")).indexOf("arrow") != -1;
        pipe = currentLine.substring(currentLine.lastIndexOf("\"")).indexOf("pipe") != -1;
        StringBuilder msgLink = new StringBuilder();
        from.appendCode(msgLink);
        msgLink.append(" <-> ");
        to.appendCode(msgLink);
        AltaLink logLink = new AltaLink();
        boolean validLink = true;
        boolean bl = validLink = from.validate(msgLink.toString()) && validLink;
        if (validLink) {
            logLink.setFrom(from._sub, from._flow, from._field);
        }
        boolean bl2 = validLink = to.validate(msgLink.toString()) && validLink;
        if (validLink) {
            logLink.setTo(to._sub, to._flow, to._field);
        }
        if (validLink && !(validLink = logLink.verify()) && logLink.getFromFlow().getType() instanceof DBRecord && logLink.getToFlow().getType() instanceof DBRecord && (logLink.getFromField() != null || logLink.getToField() != null) && (logLink.getFromField() == null || logLink.getToField() == null) && logLink.getToFlow().getType().equals(logLink.getFromFlow().getType())) {
            logLink.setFromField(null).setToField(null);
            validLink = logLink.verify();
            if (validLink) {
                this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_LINK_FIELD_CORRECTION", msgLink));
            }
        }
        if (!validLink) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_LINK_FIELD_UNCOMPATIBLE", msgLink));
        }
        AlgaLink link = null;
        if (validLink) {
            this._lstLink.add(logLink);
            link = new AlgaLink().setLogical(logLink);
            link.setLocked(locked);
            link.setDrawArrow(arrow);
            link.setPipeStyle(pipe);
            this.getSheet(sheetLocation).add(link, -1);
        }
        this.loadGraphicSet(link, inData, "/link", null);
        if (validLink && logLink.getFromFlow() != from._flow) {
            Collections.reverse(link.getPoints());
        }
    }

    protected void loadGraphicGroup(String currentLine, BufferedReader inData, AlgaContainer container, boolean addAtFirst, CECFactory cecFactory) throws IOException {
        String line;
        int sheetLocation = Integer.parseInt(CoreUtil.searchString(currentLine, "sheet="));
        boolean locked = currentLine.indexOf("locked") != -1;
        AlgaGroup graphicGroup = new AlgaGroup();
        graphicGroup.setLocked(locked);
        if (container == null) {
            container = this.getSheet(sheetLocation);
        }
        container.add(graphicGroup, addAtFirst ? -1 : Integer.MAX_VALUE);
        while ((line = inData.readLine()) != null && line.indexOf("</graphic_group>") == -1) {
            if (line.indexOf("<graphic_form") != -1) {
                this.loadGraphicForm(line, inData, graphicGroup, false, cecFactory);
                continue;
            }
            if (line.indexOf("<graphic_group") == -1) continue;
            this.loadGraphicGroup(line, inData, graphicGroup, false, cecFactory);
        }
    }

    protected void loadGraphicForm(String currentLine, BufferedReader inData, AlgaContainer container, boolean addAtFirst, CECFactory cecFactory) throws IOException {
        AlgaImage imag;
        int formType = Integer.parseInt(CoreUtil.searchString(currentLine, "type="));
        int x = Integer.parseInt(CoreUtil.searchString(currentLine, "x="));
        int y = Integer.parseInt(CoreUtil.searchString(currentLine, "y="));
        int w = Integer.parseInt(CoreUtil.searchString(currentLine, "w="));
        int h = Integer.parseInt(CoreUtil.searchString(currentLine, "h="));
        int fred = Integer.parseInt(CoreUtil.searchString(currentLine, "fred="));
        int fgreen = Integer.parseInt(CoreUtil.searchString(currentLine, "fgreen="));
        int fblue = Integer.parseInt(CoreUtil.searchString(currentLine, "fblue="));
        int bred = Integer.parseInt(CoreUtil.searchString(currentLine, "bred="));
        int bgreen = Integer.parseInt(CoreUtil.searchString(currentLine, "bgreen="));
        int bblue = Integer.parseInt(CoreUtil.searchString(currentLine, "bblue="));
        int sheetLocation = Integer.parseInt(CoreUtil.searchString(currentLine, "sheet="));
        boolean locked = currentLine.indexOf("locked") != -1;
        boolean opaque = currentLine.indexOf("opaque") != -1;
        AlgaGraph graphicForm = switch (formType) {
            case 1 -> new AlgaLine().setArrowBegin(currentLine.indexOf("startArrow") != -1).setArrowEnd(currentLine.indexOf("endArrow") != -1);
            case 2 -> new AlgaPolygone();
            case 3 -> new AlgaText();
            case 0 -> new AlgaImage();
            default -> {
                AlgaForm.Type type = AlgaForm.Type.RECTANGLE;
                switch (formType) {
                    case 4: {
                        type = AlgaForm.Type.OVALE;
                        break;
                    }
                    case 5: {
                        type = AlgaForm.Type.RECTANGLE;
                        break;
                    }
                    case 6: {
                        type = AlgaForm.Type.ROUND_RECTANGLE;
                        break;
                    }
                    case 9: {
                        type = AlgaForm.Type.ARROW_SIMPLE;
                        break;
                    }
                    case 13: {
                        type = AlgaForm.Type.ARROW_DOUBLE;
                        break;
                    }
                    case 15: {
                        type = AlgaForm.Type.ARROW_R_SIMPLE;
                        break;
                    }
                    case 19: {
                        type = AlgaForm.Type.ARROW_R_DOUBLE;
                        break;
                    }
                    case 23: {
                        type = AlgaForm.Type.ARROW_TRIPLE;
                    }
                }
                yield new AlgaForm(type);
            }
        };
        graphicForm.setLocked(locked);
        graphicForm.setForeground(new Color(fred, fgreen, fblue));
        graphicForm.setOpaque(opaque);
        graphicForm.setBackground(new Color(bred, bgreen, bblue));
        this.loadGraphicSet(graphicForm, inData, "/graphic_form", cecFactory);
        if (graphicForm instanceof AlgaForm) {
            AlgaForm form = (AlgaForm)graphicForm;
            form.setW(w -= 6).setH(h -= 6);
            this.setCenterXY(form, x, y, w, h, "[graphic]");
        }
        if (graphicForm instanceof AlgaImage && (imag = (AlgaImage)graphicForm).getDBIcon() == null) {
            this.logMsg(Level.INFO, "L'image graphique ne contient pas d'ic\u00ef\u00bf\u00bdne valide");
            graphicForm = null;
        }
        if (graphicForm != null) {
            if (container == null) {
                container = this.getSheet(sheetLocation);
            }
            container.add(graphicForm, addAtFirst ? -1 : Integer.MAX_VALUE);
        }
    }

    public void loadGraphicSet(AlgaGraph graphicSet, BufferedReader inData, String terminator, CECFactory cecFactory) throws IOException {
        String line;
        while ((line = inData.readLine()) != null) {
            int position = line.indexOf("<");
            if (position == -1) continue;
            if ((line = line.substring(position + 1)).indexOf(terminator) == 0) break;
            position = line.indexOf(" ");
            if (position == -1) continue;
            String flag = line.substring(0, position);
            if (flag.equals("break") && graphicSet instanceof AlgaPoints) {
                int x = 0;
                int y = 0;
                position = line.indexOf(" x=");
                if (position != -1) {
                    x = CoreUtil.searchValue(line.substring(position));
                }
                if ((position = line.indexOf(" y=")) != -1) {
                    y = CoreUtil.searchValue(line.substring(position));
                }
                Pt point = new Pt(x, y);
                position = line.indexOf(" point=true");
                if (position != -1) {
                    point.setStyle(Pt.Style.CIRCLE);
                }
                ((AlgaPoints)graphicSet).addPoint(point);
                continue;
            }
            if (flag.equals("image") && graphicSet instanceof AlgaImage && cecFactory != null) {
                DBIcon dbIcon = this.readImag(line, cecFactory);
                if (dbIcon == null) continue;
                ((AlgaImage)graphicSet).setDBIcon(dbIcon);
                continue;
            }
            if (flag.equals("text") && graphicSet instanceof AlgaText) {
                int fontSize = 12;
                if (line.indexOf("size=") != -1) {
                    fontSize = Integer.parseInt(CoreUtil.searchString(line, "size="));
                }
                AlgaText.HAlignement hAlign = AlgaText.HAlignement.LEFT;
                if (line.indexOf("horAlignment") != -1) {
                    switch (Integer.parseInt(CoreUtil.searchString(line, "horAlignment="))) {
                        default: {
                            hAlign = AlgaText.HAlignement.LEFT;
                            break;
                        }
                        case 1: {
                            hAlign = AlgaText.HAlignement.CENTER;
                            break;
                        }
                        case 2: {
                            hAlign = AlgaText.HAlignement.RIGHT;
                        }
                    }
                }
                AlgaText.VAlignement vAlign = AlgaText.VAlignement.TOP;
                if (line.indexOf("verAlignment") != -1) {
                    switch (Integer.parseInt(CoreUtil.searchString(line, "verAlignment="))) {
                        default: {
                            vAlign = AlgaText.VAlignement.TOP;
                            break;
                        }
                        case 4: {
                            vAlign = AlgaText.VAlignement.MIDDLE;
                            break;
                        }
                        case 5: {
                            vAlign = AlgaText.VAlignement.BOTTOM;
                        }
                    }
                }
                boolean bold = line.indexOf("bold") != -1;
                boolean italic = line.indexOf("italic") != -1;
                StringBuilder text = new StringBuilder();
                while ((line = inData.readLine()) != null && line.indexOf("</text>") == -1) {
                    if (text.length() > 0) {
                        text.append("\n");
                    }
                    text.append(line);
                }
                ((AlgaText)graphicSet).setHorizontalAlignement(hAlign).setVerticalAlignement(vAlign);
                ((AlgaText)graphicSet).setFont(fontSize, bold, italic).setText(text.toString());
                continue;
            }
            if (!flag.equals("transform") || !(graphicSet instanceof AlgaDraw) || (position = line.indexOf(" value=")) == -1) continue;
            switch (CoreUtil.searchValue(line.substring(position))) {
                case 1: {
                    ((AlgaDraw)graphicSet).addTransform(AlgaTransform.Type.MIRRORV);
                    break;
                }
                case 2: {
                    ((AlgaDraw)graphicSet).addTransform(AlgaTransform.Type.MIRRORH);
                    break;
                }
                case 3: {
                    ((AlgaDraw)graphicSet).addTransform(AlgaTransform.Type.ROTATE);
                }
            }
        }
    }

    class PortReader {
        String _codeNode = "";
        int _idPort = -1;
        String _codePort = "";
        String _codeField = "";
        AltaSub _sub = null;
        DBRecordField _field = null;
        AltaFlow _flow = null;

        PortReader() {
        }

        protected void read(String currentLine, String attrID, String attrName) {
            int position = currentLine.indexOf(attrID);
            if (position != -1) {
                this._codeNode = CoreUtil.searchString(currentLine.substring(position));
                position = this._codeNode.indexOf(".");
                if (position != -1) {
                    String str = this._codeNode.substring(position + 1);
                    this._codeNode = this._codeNode.substring(0, position);
                    position = str.indexOf(".");
                    if (position != -1) {
                        this._codeField = str.substring(position + 1);
                        str = str.substring(0, position);
                    }
                    this._idPort = Integer.valueOf(str);
                }
            }
            if ((position = currentLine.indexOf(attrName)) != -1) {
                this._codeNode = CoreUtil.searchString(currentLine.substring(position));
                position = this._codeNode.indexOf(".");
                if (position != -1) {
                    this._codePort = this._codeNode.substring(position + 1);
                    this._codeNode = this._codeNode.substring(0, position);
                    position = this._codePort.indexOf(".");
                    if (position != -1) {
                        this._codeField = this._codePort.substring(position + 1);
                        this._codePort = this._codePort.substring(0, position);
                    }
                }
            }
        }

        public boolean validate(String msgLink) {
            if (!this._codeNode.startsWith("#")) {
                this._sub = DBEquipmentReaderRaw.this._mapSubs.get(this._codeNode);
                if (this._sub == null) {
                    DBEquipmentReaderRaw.this.logMsg(Level.INFO, "Le sous-composant '" + this._codeNode + "' est inconnu: " + msgLink);
                    return false;
                }
            }
            if (this._idPort != -1 && this._sub != null) {
                this._flow = this._sub.getNode().getFlowWithID(this._idPort);
                if (this._flow == null) {
                    DBEquipmentReaderRaw.this.logMsg(Level.FINE, "Le flux d'id '" + this._idPort + "' est inconnu pour le composant '" + this._codeNode + "': " + msgLink);
                }
            }
            if (this._flow == null) {
                this._flow = this._sub == null ? (AltaFlow)DBEquipmentReaderRaw.this._mapPorts.get(this._codePort) : this._sub.getNode().getFlow(this._codePort);
            }
            if (this._flow == null) {
                DBEquipmentReaderRaw.this.logMsg(Level.INFO, "Le flux '" + this._codePort + "' est inconnu pour le composant '" + this._codeNode + "': " + msgLink);
                return false;
            }
            if (!this._codeField.isEmpty()) {
                if (!(this._flow.getType() instanceof DBRecord)) {
                    DBEquipmentReaderRaw.this.logMsg(Level.FINE, "Le flux '" + this._codePort + "' n'est pas un flux structure: " + msgLink);
                    DBEquipmentReaderRaw.this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_LINK_FIELD_UNKNOWN", this._codeField, msgLink));
                } else {
                    this._field = ((DBRecord)this._flow.getType()).getValue(this._codeField);
                    if (this._field == null) {
                        DBEquipmentReaderRaw.this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_LINK_FIELD_UNKNOWN", this._codeField, msgLink));
                    }
                }
            }
            return true;
        }

        public void appendCode(StringBuilder msgLink) {
            if (!this._codeNode.isEmpty()) {
                msgLink.append(this._codeNode).append(".");
            }
            msgLink.append(this._codePort);
            if (!this._codeField.isEmpty()) {
                msgLink.append("^").append(this._codeField);
            }
        }
    }
}

