/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpDBFolderHeader;
import com.dassault.cecilia.core.cecilia.export.ExpGeneral;
import com.dassault.cecilia.core.cecilia.export.ExpObjectInfo;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.export.ExpTableWithEntry;
import com.dassault.cecilia.core.cecilia.export.XPortConfig;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgNode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XPortCfgComponent
extends XPortCfgNode
implements XPortConfig<AltaComponent> {
    private static Logger _LOG = Logger.getLogger(XPortCfgComponent.class.getPackage().getName());

    @Override
    public void configBook(ExpBook expBook, AltaComponent item) {
        expBook.setInfo(new ExpObjectInfo(item.getDBFolder()));
        this.addInternal(expBook, item);
        this.addDependencies(expBook, item);
    }

    @Override
    public void addInto(ExpContainer expContainer, AltaComponent item) {
        ExpDBFolderHeader header = new ExpDBFolderHeader(item.getDBFolder(), ResMsgOcas.getString("EXPORT_DBK_MODEL_OF_COMPONENT"));
        this.addInternal(header, item);
        expContainer.add(header);
    }

    private void addInternal(ExpContainer header, AltaComponent item) {
        header.add(new ExpGeneral(item.getDBFolder()));
        this.addSectionGeneralInfo(header, item);
        this.addSectionFlows(header, item);
        this.addSectionStates(header, item);
        this.addSectionEvents(header, item, ResMsgVoc.getString("VOC_EVENTS"));
        this.addSectionIcons(header, item);
        this.addSectionCode(header, item);
        this.addSectionOperators(header, item);
    }

    protected void addSectionStates(ExpContainer expContainer, AltaComponent item) {
        if (!item.getStates().isEmpty()) {
            ExpSection sectionDef = new ExpSection(){

                @Override
                public String getTitle() {
                    return ResMsgVoc.getString("VOC_STATES");
                }
            };
            sectionDef.add(new ExpMBSAStates(item));
            expContainer.add(sectionDef);
        }
    }

    @Override
    protected String getAltaRicaCode(AltaNode node) {
        AltaComponent item = (AltaComponent)node;
        StringBuilder out = new StringBuilder(1024);
        try {
            out.append(item.getHeader(false));
            out.append(item.getCode().trim()).append("\n");
            out.append(item.getFooter()).append("\n");
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "Probleme de generation du code du composant : " + item.getDBFolder().getRefPath(), e);
        }
        return out.toString();
    }

    static class ExpMBSAStates
    extends ExpTableWithEntry<AltaState> {
        AltaComponent _node;

        public ExpMBSAStates(AltaComponent node) {
            this._node = node;
        }

        @Override
        protected int getColumnCount() {
            return 3;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_VALUE");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._node.getStates().size();
        }

        @Override
        protected AltaState getObject(int row) {
            return this._node.getStates().get(row);
        }

        @Override
        protected String getEntryAt(int col, AltaState item) {
            switch (col) {
                case 0: {
                    return item.getName();
                }
                case 1: {
                    AltaType type = item.getType();
                    if (type instanceof DBType && ((DBType)type).getDBFolder() != null) {
                        return ((DBType)type).getDBFolder().getRefPath();
                    }
                    return type.getValue();
                }
                case 2: {
                    return item.getDefaultValue();
                }
            }
            return "";
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }
    }
}

