/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpPara;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.export.ExpTableEvents;
import com.dassault.cecilia.core.cecilia.export.ExpTableWithEntry;
import com.dassault.cecilia.core.cecilia.export.XPortCfgDependencies;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.general.law.FctParamSelect;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamFMEA;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.DBIconRenderer;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.export.ExpListing;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.imageio.ImageIO;

public abstract class XPortCfgNode
extends XPortCfgDependencies {
    protected void addSectionGeneralInfo(ExpContainer expContainer, final AltaComponent item) {
        ExpSection sectionDef = new ExpSection(){

            @Override
            public String getTitle() {
                return ResMsgVoc.getString("VOC_GENERAL");
            }

            @Override
            protected void writeContentDocbook(DBKOutput output) throws IOException {
                this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_WIDTH"), Integer.toString(item.getWidth()));
                this.writeDBKSimpleParamKey(output, ResMsgVoc.getString("VOC_HEIGHT"), Integer.toString(item.getHeight()));
                this.writeDBKSimpleParamKey(output, ResMsgOcas.getString("MODEL_EDIT_FILE_ICON"), item.getIconRenderer().getDBIcon() != null ? item.getIconRenderer().getDBIcon().getRefPath() : "-");
                if (item.getIconRenderer().getColorDraw() != null) {
                    this.writeDBKSimpleParamKey(output, ResMsgOcas.getString("MODEL_EDIT_DRAW_BORDER"), XPortCfgNode.this.colorToString(item.getIconRenderer().getColorDraw()));
                } else {
                    this.writeDBKSimpleParamKey(output, ResMsgOcas.getString("MODEL_EDIT_DRAW_BORDER"), ResMsgVoc.getString("VOC_NO"));
                }
                if (item.getIconRenderer().getColorFill() != null) {
                    this.writeDBKSimpleParamKey(output, ResMsgOcas.getString("MODEL_EDIT_FILL_BORDER"), XPortCfgNode.this.colorToString(item.getIconRenderer().getColorFill()));
                } else {
                    this.writeDBKSimpleParamKey(output, ResMsgOcas.getString("MODEL_EDIT_FILL_BORDER"), ResMsgVoc.getString("VOC_NO"));
                }
            }

            @Override
            protected void writeContentScribe(SrbInputStream scribe) throws IOException {
                scribe.concat("<UL>\n");
                this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_WIDTH"), Integer.toString(item.getWidth()));
                this.writeSRBSimpleParamKey(scribe, ResMsgVoc.getString("VOC_HEIGHT"), Integer.toString(item.getHeight()));
                this.writeSRBSimpleParamKey(scribe, ResMsgOcas.getString("MODEL_EDIT_FILE_ICON"), item.getIconRenderer().getDBIcon() != null ? item.getIconRenderer().getDBIcon().getRefPath() : "-");
                if (item.getIconRenderer().getColorDraw() != null) {
                    this.writeSRBSimpleParamKey(scribe, ResMsgOcas.getString("MODEL_EDIT_DRAW_BORDER"), XPortCfgNode.this.colorToString(item.getIconRenderer().getColorDraw()));
                } else {
                    this.writeSRBSimpleParamKey(scribe, ResMsgOcas.getString("MODEL_EDIT_DRAW_BORDER"), ResMsgVoc.getString("VOC_NO"));
                }
                if (item.getIconRenderer().getColorFill() != null) {
                    this.writeSRBSimpleParamKey(scribe, ResMsgOcas.getString("MODEL_EDIT_FILL_BORDER"), XPortCfgNode.this.colorToString(item.getIconRenderer().getColorFill()));
                } else {
                    this.writeSRBSimpleParamKey(scribe, ResMsgOcas.getString("MODEL_EDIT_FILL_BORDER"), ResMsgVoc.getString("VOC_NO"));
                }
                scribe.concat("<EUL>\n");
                super.writeContentScribe(scribe);
            }
        };
        expContainer.add(sectionDef);
    }

    private String colorToString(Color color) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("RGB(").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append(")");
        return buffer.toString();
    }

    protected File colorToPNG(Color color, int w, int h, File path) {
        StringBuilder name = new StringBuilder(128);
        name.append("Color_").append(Integer.toHexString(color.getRed())).append(Integer.toHexString(color.getGreen())).append(Integer.toHexString(color.getBlue())).append("_");
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile(name.toString(), ".png", path);
            Graphics2D graph = null;
            BufferedImage image = new BufferedImage(w, h, 1);
            graph = image.createGraphics();
            graph.setColor(color);
            graph.fillRect(0, 0, w, h);
            ImageIO.write((RenderedImage)image, "png", tmpFile);
        }
        catch (Throwable th) {
            tmpFile = null;
        }
        return tmpFile;
    }

    protected void addSectionFlows(ExpContainer expContainer, AltaNode item) {
        if (!item.getFlows().isEmpty()) {
            ExpSection sectionDef = new ExpSection(){

                @Override
                public String getTitle() {
                    return ResMsgVoc.getString("VOC_FLOWS");
                }
            };
            sectionDef.add(new ExpMBSAFlows(item));
            expContainer.add(sectionDef);
        }
    }

    protected void addSectionEvents(ExpContainer expContainer, AltaComponent item, final String title) {
        if (!item.getEvents().isEmpty()) {
            ExpSection sectionDef = new ExpSection(){

                @Override
                public String getTitle() {
                    return title;
                }
            };
            sectionDef.add(new ExpMBSAEvents(item));
            expContainer.add(sectionDef);
        }
    }

    protected abstract String getAltaRicaCode(AltaNode var1);

    protected void addSectionCode(ExpContainer expContainer, AltaNode item) {
        expContainer.add(new ExpListing<AltaNode>(item){

            @Override
            protected String getCode(AltaNode node) {
                return XPortCfgNode.this.getAltaRicaCode(node);
            }

            @Override
            protected String getRole() {
                return "altarica";
            }
        });
    }

    protected void addSectionIcons(ExpContainer expContainer, AltaComponent item) {
        if (!item.getSimuls().isEmpty()) {
            ExpSection sectionDef = new ExpSection(){

                @Override
                public String getTitle() {
                    return ResMsgVoc.getString("VOC_ICONS");
                }
            };
            sectionDef.add(new ExpMBSAIcons(item));
            expContainer.add(sectionDef);
        }
    }

    protected void addSectionOperators(ExpContainer container, AltaNode node) {
        if (!node.getUsedOperator().isEmpty()) {
            ExpSection sectionDef = new ExpSection(){

                @Override
                public String getTitle() {
                    return ResMsgOcas.getString("EXPORT_DBK_LIST_OF_OPERATORS");
                }
            };
            sectionDef.add(new ExpOperators(node));
            container.add(sectionDef);
        }
    }

    protected void addSectionSyncs(ExpContainer expContainer, AltaEquipment item) {
        if (!item.getSynchros().isEmpty()) {
            ExpSection sectionDef = new ExpSection(){

                @Override
                public String getTitle() {
                    return ResMsgVoc.getString("VOC_SYNCS");
                }
            };
            sectionDef.add(new ExpMBSASyncs(item));
            expContainer.add(sectionDef);
        }
    }

    protected void addSectionSubs(ExpContainer expContainer, final AltaEquipment item) {
        if (!item.getSubs().isEmpty()) {
            ExpSection sectionDef = new ExpSection(){

                @Override
                public String getTitle() {
                    if (item instanceof AltaSystem) {
                        return ResMsgOcas.getString("EXPORT_DBK_CONTENT_OF_MODEL");
                    }
                    return ResMsgOcas.getString("EXPORT_DBK_CONTENT_OF_EQUIPMENT");
                }
            };
            sectionDef.add(new ExpMBSASubs(item));
            expContainer.add(sectionDef);
        }
    }

    static class ExpMBSAFlows
    extends ExpTableWithEntry<AltaFlow> {
        AltaNode _node;

        public ExpMBSAFlows(AltaNode node) {
            this._node = node;
        }

        @Override
        protected int getColumnCount() {
            return 5;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_SENS");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_X");
                }
                case 4: {
                    return ResMsgVoc.getString("VOC_Y");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._node.getFlows().size();
        }

        @Override
        protected AltaFlow getObject(int row) {
            return this._node.getFlows().get(row);
        }

        @Override
        protected String getEntryAt(int col, AltaFlow item) {
            switch (col) {
                case 0: {
                    return item.getName();
                }
                case 1: {
                    AltaType type = item.getType();
                    if (type instanceof DBType && ((DBType)type).getDBFolder() != null) {
                        return ((DBType)type).getDBFolder().getRefPath();
                    }
                    return type.getValue();
                }
                case 2: {
                    return item.getOrientation().getLabel();
                }
                case 3: {
                    return Integer.toString(item.getX());
                }
                case 4: {
                    return Integer.toString(item.getY());
                }
            }
            return "";
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }

        @Override
        protected int getColumnWidth(int col) {
            switch (col) {
                case 0: {
                    return 10;
                }
                case 1: {
                    return 15;
                }
                case 3: 
                case 4: {
                    return 3;
                }
            }
            return super.getColumnWidth(col);
        }
    }

    static class ExpMBSAEvents
    extends ExpTableEvents<AltaEvent> {
        AltaComponent _node;

        public ExpMBSAEvents(AltaComponent node) {
            this._node = node;
        }

        @Override
        protected int getColumnCount() {
            return 6;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_COMMENT");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_FRB");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_LAW");
                }
                case 4: {
                    return ResMsgVoc.getString("VOC_INSPECTED");
                }
                case 5: {
                    return ResMsgVoc.getString("VOC_INFLIGHT_TESTED");
                }
                case 6: {
                    return ResMsgVoc.getString("VOC_ATTRIBUTES");
                }
                case 7: {
                    return ResMsgVoc.getString("VOC_FMEA");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._node.getEvents().size();
        }

        @Override
        protected AltaEvent getObject(int row) {
            return this._node.getEvents().get(row);
        }

        @Override
        protected String getEntryAt(int col, AltaEvent item) {
            switch (col) {
                case 0: {
                    return item.getName();
                }
                case 1: {
                    return item.getLabel();
                }
                case 2: {
                    return item.getModelLaw() == null ? "-" : item.getModelLaw().getRefPath();
                }
                case 3: {
                    return item.getLaw() == null ? "-" : this.ltos(item.getLaw());
                }
                case 4: {
                    return item.getInspected() == null ? "-" : this.ptos(item.getInspected());
                }
                case 5: {
                    return item.getInflightTested() == null ? "-" : this.ptos(item.getInflightTested());
                }
                case 6: {
                    return item.getAttributesAsDisplayedString();
                }
                case 7: {
                    Set<Param> params = item.recupParams(new LinkedHashSet<Param>(), new FctParamSelect.FctParamFMEA());
                    return ParamFMEA.transcodeCollections(params);
                }
            }
            return "";
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }
    }

    class ExpMBSAIcons
    extends ExpTable {
        AltaComponent _node;

        public ExpMBSAIcons(AltaComponent node) {
            this._node = node;
        }

        @Override
        protected int getColumnCount() {
            return 3;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NUMBER");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_ICON");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_PATH");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._node.getSimuls().size();
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            switch (col) {
                case 0: {
                    return ExpTable.ExpAlign.RIGHT;
                }
                case 1: {
                    return ExpTable.ExpAlign.CENTER;
                }
                case 2: {
                    return ExpTable.ExpAlign.LEFT;
                }
            }
            return ExpTable.ExpAlign.LEFT;
        }

        @Override
        protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
            if (col == 0) {
                output.write(Integer.toString(row + 1), true);
            } else if (col == 2) {
                DBIconRenderer item = this._node.getSimuls().get(row);
                if (item.getDBIcon() != null) {
                    output.write(item.getDBIcon().getRefPath(), true);
                } else {
                    output.write("-", true);
                }
            } else {
                DBIconRenderer item = this._node.getSimuls().get(row);
                item.setDefaultRenderer(this._node.getIconRenderer());
                File refPath = this.getBook().getImagPath(output.getXmlOutputFile());
                File resultFile = item.savePNG(refPath, this._node.getWidth(), this._node.getHeight(), 2.0);
                if (resultFile != null) {
                    output.write("<mediaobject><imageobject>\n", false);
                    output.addIndent(1);
                    output.write("<imagedata fileref=\"./" + resultFile.getName() + "\"  format=\"PNG\" scale=\"30\"/>\n", false);
                    output.addIndent(-1);
                    output.write("</imageobject></mediaobject>\n", false);
                }
            }
        }

        @Override
        protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idx) {
            if (col == 0) {
                buffer.append(Integer.toString(row + 1));
            } else if (col == 2) {
                DBIconRenderer item = this._node.getSimuls().get(row);
                if (item.getDBIcon() != null) {
                    buffer.append(item.getDBIcon().getRefPath());
                } else {
                    buffer.append("-");
                }
            } else {
                DBIconRenderer item = this._node.getSimuls().get(row);
                item.setDefaultRenderer(this._node.getIconRenderer());
                File resultFile = item.savePNG(null, this._node.getWidth(), this._node.getHeight(), 0.5);
                resultFile.deleteOnExit();
                buffer.append("<IMG>").append(resultFile.getAbsolutePath()).append("<EIMG>\n");
            }
        }

        @Override
        protected int getColumnWidth(int col) {
            switch (col) {
                case 0: {
                    return 5;
                }
                case 1: {
                    return 20;
                }
                case 2: {
                    return 30;
                }
            }
            return super.getColumnWidth(col);
        }
    }

    static class ExpOperators
    extends ExpTableWithEntry<AltaOperatorRef> {
        AltaNode _node;

        public ExpOperators(AltaNode node) {
            this._node = node;
        }

        @Override
        protected int getColumnCount() {
            return 3;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_PATH");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_VERSION");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._node.getUsedOperator().size();
        }

        @Override
        protected AltaOperatorRef getObject(int row) {
            return this._node.getUsedOperator().get(row);
        }

        @Override
        protected String getEntryAt(int col, AltaOperatorRef item) {
            switch (col) {
                case 0: {
                    return item.getName();
                }
                case 1: {
                    return item.getDBFolder().getParent().getParent().getPathUntilSystem(new StringBuilder()).toString();
                }
                case 2: {
                    return item.getDBFolder().getName();
                }
            }
            return "";
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }

        @Override
        protected int getColumnWidth(int col) {
            switch (col) {
                case 0: 
                case 1: {
                    return 15;
                }
            }
            return super.getColumnWidth(col);
        }
    }

    static class ExpMBSASyncs
    extends ExpTableEvents<AltaSynchro> {
        AltaEquipment _node;

        public ExpMBSASyncs(AltaEquipment node) {
            this._node = node;
        }

        @Override
        protected int getColumnCount() {
            return 10;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_EVENTS");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_COMMENT");
                }
                case 4: {
                    return ResMsgVoc.getString("VOC_FRB");
                }
                case 5: {
                    return ResMsgVoc.getString("VOC_LAW");
                }
                case 6: {
                    return ResMsgVoc.getString("VOC_INSPECTED");
                }
                case 7: {
                    return ResMsgVoc.getString("VOC_INFLIGHT_TESTED");
                }
                case 8: {
                    return ResMsgVoc.getString("VOC_ATTRIBUTES");
                }
                case 9: {
                    return ResMsgVoc.getString("VOC_FMEA");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._node.getSynchros().size();
        }

        @Override
        protected AltaSynchro getObject(int row) {
            return this._node.getSynchros().get(row);
        }

        @Override
        protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
            if (col == 2) {
                ExpPara.writeDocbookListSimple(output, this.getObject(row).getEvents());
            } else {
                super.writeDocbookEntryAt(output, col, row);
            }
        }

        @Override
        protected String getEntryAt(int col, AltaSynchro item) {
            switch (col) {
                case 0: {
                    return item.getName();
                }
                case 1: {
                    return item.getType().getLabel();
                }
                case 2: {
                    break;
                }
                case 3: {
                    return item.getLabel();
                }
                case 4: {
                    return item.getModelLaw() == null ? "-" : item.getModelLaw().getRefPath();
                }
                case 5: {
                    return item.getLaw() == null ? "-" : this.ltos(item.getLaw());
                }
                case 6: {
                    return item.getInspected() == null ? "-" : this.ptos(item.getInspected());
                }
                case 7: {
                    return item.getInflightTested() == null ? "-" : this.ptos(item.getInflightTested());
                }
                case 8: {
                    return item.getAttributesAsDisplayedString();
                }
                case 9: {
                    return "-";
                }
            }
            return "";
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }

        @Override
        protected int getColumnWidth(int col) {
            switch (col) {
                case 0: 
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    return 8;
                }
                case 6: {
                    return 6;
                }
            }
            return super.getColumnWidth(col);
        }
    }

    static class ExpMBSASubs
    extends ExpTableWithEntry<AltaSub> {
        AltaEquipment _node;
        ArrayList<AltaSub> _subs;

        public ExpMBSASubs(AltaEquipment node) {
            this._node = node;
            this._subs = new ArrayList<AltaSub>(this._node.getSubs());
            Collections.sort(this._subs);
        }

        @Override
        protected int getColumnCount() {
            return 3;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_PATH");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_EQUIPMENT");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._subs.size();
        }

        @Override
        protected AltaSub getObject(int row) {
            return this._subs.get(row);
        }

        @Override
        protected String getEntryAt(int col, AltaSub item) {
            switch (col) {
                case 0: {
                    return item.getName();
                }
                case 1: {
                    return item.getNode().getRefPath();
                }
                case 2: {
                    if (item.getNode() instanceof AltaEquipment) {
                        return ResMsgVoc.getString("VOC_YES");
                    }
                    return ResMsgVoc.getString("VOC_NO");
                }
            }
            return "";
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }

        @Override
        protected int getColumnWidth(int col) {
            switch (col) {
                case 0: 
                case 2: {
                    return 10;
                }
                case 1: {
                    return 20;
                }
            }
            return super.getColumnWidth(col);
        }
    }
}

