/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpDBFolderHeader;
import com.dassault.cecilia.core.cecilia.export.ExpGeneral;
import com.dassault.cecilia.core.cecilia.export.ExpObjectInfo;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.export.XPortConfig;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import java.io.IOException;

public class XPortCfgTypeEnum
implements XPortConfig<DBEnum> {
    @Override
    public void configBook(ExpBook expBook, DBEnum item) {
        expBook.setInfo(new ExpObjectInfo(item.getDBFolder()));
        this.addInternal(expBook, item);
    }

    @Override
    public void addInto(ExpContainer expContainer, DBEnum item) {
        ExpDBFolderHeader header = new ExpDBFolderHeader(item.getDBFolder(), ResMsgOcas.getString("EXPORT_DBK_MODEL_OF_TYPE"));
        this.addInternal(header, item);
        expContainer.add(header);
    }

    private void addInternal(ExpContainer header, DBEnum item) {
        header.add(new ExpGeneral(item.getDBFolder()));
        ExpSection sectionDef = new ExpSection(){

            @Override
            public String getTitle() {
                return ResMsgVoc.getString("VOC_DEFINITION");
            }
        };
        sectionDef.add(new ExpTypeEnumFields(item));
        header.add(sectionDef);
    }

    static class ExpTypeEnumFields
    extends ExpTable {
        DBEnum _type;

        public ExpTypeEnumFields(DBEnum type) {
            this._type = type;
        }

        @Override
        protected String getColumnName(int col) {
            return ResMsgVoc.getString("VOC_FIELD");
        }

        @Override
        protected int getColumnCount() {
            return 1;
        }

        @Override
        protected int getRowCount() {
            return this._type.getValueCount();
        }

        @Override
        protected void writeDocbookEntryAt(DBKOutput output, int col, int row) throws IOException {
            output.write(this._type.getValueAt(row), true);
        }

        @Override
        protected void exportToScribeEntryAt(StringBuilder buffer, int col, int row, int idx) {
            buffer.append(this._type.getValueAt(row));
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }

        @Override
        protected int getColumnWidth(int col) {
            return 10;
        }
    }
}

