/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpDBFolderHeader;
import com.dassault.cecilia.core.cecilia.export.ExpGeneral;
import com.dassault.cecilia.core.cecilia.export.ExpObjectInfo;
import com.dassault.cecilia.core.cecilia.export.ExpSection;
import com.dassault.cecilia.core.cecilia.export.ExpTable;
import com.dassault.cecilia.core.cecilia.export.ExpTableWithEntry;
import com.dassault.cecilia.core.cecilia.export.XPortCfgDependencies;
import com.dassault.cecilia.core.cecilia.export.XPortConfig;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;

public class XPortCfgTypeRecord
extends XPortCfgDependencies
implements XPortConfig<DBRecord> {
    @Override
    public void configBook(ExpBook expBook, DBRecord item) {
        expBook.setInfo(new ExpObjectInfo(item.getDBFolder()));
        this.addInternal(expBook, item);
        this.addDependencies(expBook, item);
    }

    @Override
    public void addInto(ExpContainer expContainer, DBRecord item) {
        ExpDBFolderHeader header = new ExpDBFolderHeader(item.getDBFolder(), ResMsgOcas.getString("EXPORT_DBK_MODEL_OF_TYPE"));
        this.addInternal(header, item);
        expContainer.add(header);
    }

    private void addInternal(ExpContainer header, DBRecord item) {
        header.add(new ExpGeneral(item.getDBFolder()));
        ExpSection sectionDef = new ExpSection(){

            @Override
            public String getTitle() {
                return ResMsgVoc.getString("VOC_DEFINITION");
            }
        };
        sectionDef.add(new ExpTypeRecordFields(item));
        header.add(sectionDef);
    }

    static class ExpTypeRecordFields
    extends ExpTableWithEntry<DBRecordField> {
        DBRecord _type;

        public ExpTypeRecordFields(DBRecord type) {
            this._type = type;
        }

        @Override
        protected int getColumnCount() {
            return 4;
        }

        @Override
        protected String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return ResMsgVoc.getString("VOC_FIELD");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_SENS");
                }
                case 3: {
                    return ResMsgVoc.getString("VOC_CROSS");
                }
            }
            return "<Error>";
        }

        @Override
        protected int getRowCount() {
            return this._type.getValueCount();
        }

        @Override
        protected DBRecordField getObject(int row) {
            return this._type.getFieldAt(row);
        }

        @Override
        protected String getEntryAt(int col, DBRecordField field) {
            switch (col) {
                case 0: {
                    return field.getName();
                }
                case 1: {
                    AltaType type = field.getType();
                    if (type instanceof DBType && ((DBType)type).getDBFolder() != null) {
                        return ((DBType)type).getDBFolder().getRefPath();
                    }
                    return type.getValue();
                }
                case 2: {
                    return field.getDirection().getLabel();
                }
                case 3: {
                    return field.getCrossField();
                }
            }
            return "";
        }

        @Override
        protected ExpTable.ExpAlign getColumnAlign(int col) {
            return ExpTable.ExpAlign.LEFT;
        }

        @Override
        protected int getColumnWidth(int col) {
            switch (col) {
                case 0: {
                    return 10;
                }
                case 1: {
                    return 15;
                }
                case 2: 
                case 3: {
                    return 8;
                }
            }
            return super.getColumnWidth(col);
        }
    }
}

