/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.node.AltaObjWithName;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareUtils;

public class AltaVar
extends AltaObjWithName {
    long _id = -1L;
    AltaType _type;

    public AltaVar(String name, AltaType type) {
        super(name);
        this._type = type;
    }

    protected void copy(AltaVar src) {
        this.setID(src.getID());
    }

    @Override
    public AltaVar getCopy() {
        AltaVar dest = new AltaVar(this._name, this._type.getCopy());
        dest.copy(this);
        return dest;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AltaVar)) {
            return false;
        }
        AltaVar other = (AltaVar)obj;
        return this.getType().equals(other.getType());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 3 + this._type.hashCode();
        return hash;
    }

    public AltaType getType() {
        return this._type;
    }

    public long getID() {
        return this._id;
    }

    public AltaVar setType(AltaType type) {
        this._type = type;
        return this;
    }

    public AltaVar setID(long id) {
        this._id = id;
        return this;
    }

    public boolean isCompatibleValue(String value) {
        if (this._type instanceof DBRecord) {
            return false;
        }
        return this._type.valueExist(value);
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        if (this._type instanceof DBType) {
            DBType dbType = (DBType)this._type;
            DBWrap dbWrap = DBWrap.createOrFind(daoFactory, dbType.getDBFolder(), logMng, DBType.class);
            if (dbWrap == null) {
                this._type = AltaTypeBool.getInstance();
                return false;
            }
            this._type = (DBType)dbWrap;
        }
        return true;
    }

    @Override
    public String getAbstract() {
        StringBuilder sb = new StringBuilder();
        sb.append(CompareUtils.getTextForCompare(ResMsgVoc.getString("VOC_TYPE"), this._type.toLabel()));
        return sb.toString();
    }
}

