/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.action.CThread;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.ExpBookUtility;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.cecilia.folder.DBFolderResources;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldsCategory;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.cecilia.pref.PrintPreviewPrefsDlg;
import com.dassault.cecilia.core.cecilia.print.ListProcessorJavaInteractive;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableModel;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaEditor;
import com.dassault.cecilia.dbobj.mbsa.node.gui.EditorHelper;
import com.dassault.cecilia.dbobj.mbsa.node.gui.EditorInterface;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.operator.gui.AltaOperatorIdPanel;
import com.dassault.cecilia.dbobj.wrap.PageableThread;
import com.dassault.cecilia.lib.mbsa.translator.parser.OcasLexer;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AltaCodeFrame
extends DBInternalFrame
implements PlugableModel,
Preferencies.PreferenciesListener,
EditorInterface {
    private static Logger _LOG = Logger.getLogger(AltaCodeFrame.class.getPackage().getName());
    private File _tempAltaOcasFile = null;
    CeciliaAppl _application;
    AltaNode _altaNode;
    protected JTabbedPane _tabPane = new JTabbedPane();
    protected JTabbedPane _editorTabPane;
    protected AltaEditor _codeEditor;
    protected EditorHelper _editorHelper;
    protected AltaOperatorIdPanel _operatorPanel;
    private Object _lockAltaOcasFile = new Object();
    JButton _syntaxeButton = new JButton(ResMsgVoc.getString("VOC_SYNTAX"));
    JButton _coherenceButton = new JButton(ResMsgVoc.getString("VOC_CONSISTENCY"));
    int _fontSize = -1;

    public AltaCodeFrame(AltaNode node, CeciliaAppl application) {
        super(node.getDBFolder());
        this._application = application;
        this.setAltaNode(node);
        this.setFrameIcon(DBFolderResources.getFrameIcon(node.getDBFolder()));
    }

    @Override
    protected CeciliaAppl getApplication() {
        return this._application;
    }

    private void setAltaNode(AltaNode node) {
        this._altaNode = node;
        if (this._logsUtility != null) {
            this._logsUtility.refreshRelations(null);
        }
    }

    protected AltaNode getAltaNode() {
        return this._altaNode;
    }

    @Override
    public AltaNode getDBWrap() {
        return this._altaNode;
    }

    @Override
    public AltaCodeFrame getMasterFrame() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getAltaOcasFile() {
        if (this._tempAltaOcasFile == null) {
            Object object = this._lockAltaOcasFile;
            synchronized (object) {
                File localFile = null;
                if (this._tempAltaOcasFile == null) {
                    try {
                        localFile = File.createTempFile("AltaExt", ".alt");
                        localFile.deleteOnExit();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this._tempAltaOcasFile == null) {
                    this._tempAltaOcasFile = localFile;
                }
            }
        }
        return this._tempAltaOcasFile;
    }

    protected Component createCodeAndClosePanel() {
        this.createSaveAndClosePanel();
        AbstractAction syntaxeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlThread thread = new ControlThread(AltaCodeFrame.this._syntaxeButton, "PluginActionSyntax", ResMsgOcas.getString("PLUGIN_NO_AVAILABLE_SYNTAX"));
                thread.realiseDo();
            }
        };
        this._syntaxeButton.addActionListener(syntaxeAction);
        this.getActionMap().put("SYNTAXE", syntaxeAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl shift S"), "SYNTAXE");
        AbstractAction coherenceAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlThread thread = new ControlThread(AltaCodeFrame.this._coherenceButton, "PluginActionControl", ResMsgOcas.getString("PLUGIN_NO_AVAILABLE_PROPERTY"));
                thread.realiseDo();
            }
        };
        this._coherenceButton.addActionListener(coherenceAction);
        this.getActionMap().put("COHERENCE", coherenceAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl shift C"), "COHERENCE");
        this._ctrlSave.setActionCommand("true");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int posX = 0;
        if (!this._application.isReader()) {
            panel.add((Component)this._ctrlSave, new GridBagConstraints(posX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        }
        panel.add((Component)this._syntaxeButton, new GridBagConstraints(posX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this._coherenceButton, new GridBagConstraints(posX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlClose, new GridBagConstraints(posX++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    @Override
    public String getInfo(String key) {
        return this.getApplication().getPlugable().getInfo(key);
    }

    @Override
    public IModel getModel(String key) {
        GenerateAltaricaCode code;
        if (key.equals("altarica.file") && (code = this.generateCode()) != null && code.getFile() != null) {
            return new IModel.DefaultModel(key, code.getFile(), this._altaNode.getAltaRicaName(), code.getStrConfig(), this.getDBFolder().getID());
        }
        return null;
    }

    @Override
    public InfoDatum getDatum(String key) {
        return null;
    }

    @Override
    public void setDatum(InfoDatum istepper, Plugable srcPlugable) {
    }

    protected GenerateAltaricaCode generateCode() {
        AltaNode node = this.getAltaNode();
        GenerateAltaricaCode generator = node.generateCode(this.getAltaOcasFile(), this.getApplication().getDAOFactory(), new GenerateAltaricaCode.GenerateAltaRicaCodeUtility.Default());
        if (generator.getFile() == null) {
            this.displayErrors(generator.getErrors(), JOptionCecilia.getTopTitleOf(this));
            return null;
        }
        return generator;
    }

    protected PluginMAction getControlPlugin(String subtype) {
        String defKey = this._application.getPlugable().getOption(PLUG_KEY + "#" + subtype);
        PluginMAction defPlugin = null;
        if (defKey != null && !defKey.isEmpty()) {
            defPlugin = (PluginMAction)this._application.getPlugable().getPlugin(defKey);
        }
        if (defPlugin == null) {
            List plugins = this._application.getPlugable().getPlugins("PluginAction", subtype);
            if (plugins.size() > 0) {
                for (int i = 0; defPlugin == null && i < plugins.size(); ++i) {
                    defKey = (String)plugins.get(i);
                    PluginMAction plugin = (PluginMAction)this._application.getPlugable().getPlugin(defKey);
                    String isDefaultPlugin = plugin.getInfo("plugin.default");
                    if (isDefaultPlugin == null || !isDefaultPlugin.equals("true")) continue;
                    defPlugin = plugin;
                }
                if (defPlugin == null) {
                    defKey = (String)plugins.get(0);
                    defPlugin = (PluginMAction)this._application.getPlugable().getPlugin(defKey);
                }
            }
            if (defPlugin != null) {
                this._application.getPlugable().setOption(PLUG_KEY + ".#" + subtype, defKey);
            }
        }
        return defPlugin;
    }

    protected JComponent createAltaEditor() {
        this._editorTabPane = new JTabbedPane();
        this._codeEditor = new AltaEditor(this, this.getApplication().getDAOFactory().getOperatorDictionary(), this.getCurrentFontSize());
        this._codeEditor.setEditable(!this.getApplication().isReader());
        this._editorTabPane.addTab(ResMsgVoc.getString("VOC_CODE"), this._codeEditor);
        this._operatorPanel = new AltaOperatorIdPanel(this.getApplication());
        this._editorTabPane.addTab(ResMsgVoc.getString("VOC_OPERATORS"), this._operatorPanel);
        this._editorHelper = new EditorHelper(this._codeEditor.getEditorComponent(), this);
        this._editorTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AltaCodeFrame.this._editorTabPane.getSelectedIndex() == 1) {
                    AltaCodeFrame.this.updateSelectedOperator();
                }
            }
        });
        return this._editorTabPane;
    }

    public JTabbedPane getEditorPanel() {
        return this._editorTabPane;
    }

    public JTabbedPane getMainTabbedPanel() {
        return this._tabPane;
    }

    protected void updateSelectedOperator() {
        this._operatorPanel.update(this._codeEditor.getText(), null);
    }

    protected void editNode(AltaNode node) {
        this._codeEditor.setText(node.getCode());
        this._codeEditor.initSelectionPosition();
        this._operatorPanel.setUsedOperator(node.getUsedOperator());
    }

    public void updateLangage() {
        this._codeEditor.updateLangage();
        this._operatorPanel.updateLangage();
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this._operatorPanel.isModified()) {
            return true;
        }
        if (this._codeEditor.isModified()) {
            return true;
        }
        return this.getAltaNode().isModified();
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        this._operatorPanel.setModified(modified);
        this._codeEditor.setModified(modified);
        this.getAltaNode().setModified(modified);
    }

    protected int getCurrentFontSize() {
        if (this._fontSize == -1) {
            this._fontSize = this.recupFontSize(this.getApplication().getPreferencies());
        }
        if (this._fontSize <= 0) {
            this._fontSize = 8;
        }
        return this._fontSize;
    }

    private int recupFontSize(Preferencies prefs) {
        PluginWithOptions opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            return ((GeneralTextPreferencies)opts).getFontSize();
        }
        return -1;
    }

    @Override
    public void toDoWhenBeOpened() {
        super.toDoWhenBeOpened();
        this._application.getPreferencies().addPreferenciesListener(this);
        this._codeEditor.setHideFooter();
    }

    @Override
    protected void toDoWhenActivated() {
        super.toDoWhenActivated();
        this.getApplication().getTopWindow().setEnabledAction("PRINT", true);
        this.getApplication().getTopWindow().setEnabledAction("PRINT_PREVIEW", true);
        this._codeEditor.requestFocus();
        this._codeEditor.toDoWhenActivated();
    }

    @Override
    protected void toDoWhenDeActivated() {
        super.toDoWhenDeActivated();
        this.getApplication().getTopWindow().setEnabledAction("PRINT", false);
        this.getApplication().getTopWindow().setEnabledAction("PRINT_PREVIEW", false);
        this._codeEditor.toDoWhenDeActivated();
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        int fontSizePref = this.recupFontSize(prefs);
        if (this._fontSize != fontSizePref) {
            this._fontSize = fontSizePref;
            if (this._fontSize <= 0) {
                this._fontSize = 8;
            }
            this._codeEditor.refreshFont(this._fontSize);
        }
    }

    @Override
    public void toDoWhenBeClosed() {
        this._application.getPreferencies().removePreferenciesListener(this);
        if (this._tempAltaOcasFile != null) {
            this._tempAltaOcasFile.delete();
        }
        super.toDoWhenBeClosed();
        this._codeEditor.close();
    }

    protected abstract int getTabIndex(CodeTabType var1);

    @Override
    public boolean verifyData() {
        String comment = this.getDescription();
        if (!DBFactory.verifyDescription(comment)) {
            this._tabPane.setSelectedIndex(this.getTabIndex(CodeTabType.GENERAL));
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._tabPane), ResMsgObj.msgFormat("MSG_ERR_DESCRIPTION_FRM", (short)1023), ResMsgVoc.getString("VOC_ERROR"), 0);
            return false;
        }
        if (this.findUnclosedComment(this._codeEditor.getText())) {
            this._tabPane.setSelectedIndex(this.getTabIndex(CodeTabType.CODE));
            this._editorTabPane.setSelectedIndex(0);
            this._codeEditor.requestFocus();
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._tabPane), ResMsgObj.getString("ERR_CODE_UNCLOSED_COMMENT"), JOptionCecilia.getTopTitleOf(this._codeEditor), 0);
            return false;
        }
        this.updateSelectedOperator();
        for (AltaOperatorRef operRef : this.getDBWrap().getUsedOperator()) {
            if (operRef.getName().equals(operRef.getDBFolder().getParent().getName())) continue;
            this._tabPane.setSelectedIndex(this.getTabIndex(CodeTabType.CODE));
            this._editorTabPane.setSelectedIndex(1);
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._tabPane), ResMsgObj.msgFormat("ERR_OPERATOR_NAME_UNCONSISTENCY_FRM", operRef.getName(), operRef.getDBFolder().getParent().getName()), JOptionCecilia.getTopTitleOf(this._operatorPanel), 0);
            return false;
        }
        return super.verifyData();
    }

    public boolean findUnclosedComment(String text) {
        StringReader reader = new StringReader(text);
        OcasLexer lexer = new OcasLexer((Reader)reader, true, false);
        try {
            int curToken = lexer.yylex();
            while (curToken > 0) {
                curToken = lexer.yylex();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lexer.yystate() == 1;
    }

    protected IModel getModel(String key, String defaultType) {
        if (!key.equals("docbook.file") && !key.equals("word.file")) {
            return null;
        }
        JChooserFileUtility.Type type = ExpBookUtility.convertModelKey(key);
        if (type == null) {
            return null;
        }
        StringBuilder defaultName = new StringBuilder();
        defaultName.append(defaultType).append(this.getDBFolder().getParent().getName()).append("_").append(this.getDBFolder().getName());
        File file = ExpBookUtility.selectFile(type, this.getApplication().getPlugable(), this, this.getDBFolder(), defaultName.toString());
        if (file == null) {
            return null;
        }
        ExpBook book = this.prepareBook();
        if (ExpBookUtility.realiseExport(book, file, this)) {
            return new IModel.DefaultModel(key, file);
        }
        return null;
    }

    protected abstract void configBook(ExpBook var1);

    protected ExpBook prepareBook() {
        ExpBook book = new ExpBook(this.getApplication().getDAOFactory());
        book.setPageFormat(this.getApplication().getPageFormat());
        book.setPreferencies(this.getApplication().getPreferencies());
        this.configBook(book);
        return book;
    }

    @Override
    protected boolean withUpdateEdit() {
        return true;
    }

    @Override
    protected void updateEdit() {
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), this.getAltaNode().getLogs());
        if (!this.getAltaNode().update(this.getApplication().getDAOFactory(), logMng)) {
            // empty if block
        }
        this.getAltaNode().prepareDependTimeUpdt(this.getApplication().getDAOFactory(), this.getAltaNode().getUseRelations());
        this.updateLogs(this.getAltaNode().getUseRelations(), oldLevel, oldNbr);
    }

    protected ListProcessorJavaInteractive createPageable(final PageFormat format, Preferencies pref) {
        PageableThread thread = new PageableThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Pageable doCreatePageable() {
                ExpBook book = AltaCodeFrame.this.prepareBook();
                try (SrbInputStream scribe = new SrbInputStream("");){
                    book.writeScribe(scribe);
                }
                ListProcessorJavaInteractive printable = new ListProcessorJavaInteractive(scribe);
                printable.processScribeFile();
                printable.computePageCount(format);
                return printable;
            }
        };
        thread.realiseDo();
        return (ListProcessorJavaInteractive)thread.getPageable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean preview() {
        ListProcessorJavaInteractive fgPageable = this.createPageable(this.getApplication().getPageFormat(), this.getApplication().getPreferencies());
        if (fgPageable == null) {
            return false;
        }
        try {
            PrintPreviewPrefsDlg dlg = new PrintPreviewPrefsDlg(JOptionCecilia.getWindowOf(this), fgPageable, this.getApplication(), new PrefFieldsCategory[0]){

                @Override
                public void updatePreferencies() {
                    this.setBook(AltaCodeFrame.this.createPageable(this.getFormat(), this.getPreferencies()));
                }
            };
            dlg.setLocationRelativeTo(JOptionCecilia.getWindowOf(this));
            dlg.setVisible(true);
            boolean bl = true;
            return bl;
        }
        finally {
            fgPageable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean print() {
        ListProcessorJavaInteractive fgPageable = this.createPageable(this.getApplication().getPageFormat(), this.getApplication().getPreferencies());
        if (fgPageable == null) {
            return false;
        }
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPageable(fgPageable);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    e.printStackTrace();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            fgPageable.clear();
        }
    }

    public static enum CodeTabType {
        GENERAL,
        FLOW,
        STATE,
        EVENT,
        CODE,
        CONTENT,
        SYNC,
        INIT,
        ICON,
        COLOR;

    }

    class ControlThread
    extends CThread {
        String _ctrlType;
        String _msgError;

        public ControlThread(Component c, String ctrlType, String msgError) {
            super(c);
            this._ctrlType = ctrlType;
            this._msgError = msgError;
        }

        @Override
        protected void firstDo() {
            PluginMAction defPlugin = AltaCodeFrame.this.getControlPlugin(this._ctrlType);
            if (defPlugin == null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), this._msgError);
                return;
            }
            try {
                defPlugin.createSession(AltaCodeFrame.this._application.getPlugable(), null);
            }
            catch (Exception e) {
                _LOG.log(Level.INFO, "Unexpected error occurred during plugin execution", e);
            }
        }
    }
}

