/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaCodeFrame;
import com.dassault.cecilia.dbobj.mbsa.node.gui.FctOperatorFinder;
import com.dassault.cecilia.dbobj.mbsa.node.gui.FindDialog;
import com.dassault.cecilia.dbobj.mbsa.node.gui.OcasStyledDocument;
import com.dassault.cecilia.main.cecilia.gui.AltaDesktopPane;
import com.dassault.cecilia.main.cecilia.gui.CDesktopPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;

public class AltaEditor
extends JPanel
implements UndoableEditListener {
    private JMenuBar menubar;
    private JToolBar toolbar;
    JTextPane _header;
    EditorPane _editor;
    private UndoManager undoManager = new UndoManager();
    private String courant;
    JPanel _subEditor = new JPanel();
    JScrollPane _scrollEditor = new JScrollPane(this._subEditor);
    JTextPane _bottom;
    JButton _editorCopyButton;
    JButton _editorCutButton;
    JButton _editorPasteButton;
    JButton _editorFindButton;
    JButton _editorUndoButton;
    JButton _editorRedoButton;
    JMenuItem _menuEditorItemCopy;
    JMenuItem _menuEditorItemCut;
    JMenuItem _menuEditorItemPaste;
    JMenuItem _menuEditorItemUndo;
    JMenuItem _menuEditorItemRedo;
    JMenuItem _menuEditorItemFind;
    OcasStyledDocument _headerDoc;
    OcasStyledDocument _mainDoc;
    OcasStyledDocument _bottomDoc;
    private JButton _zoomIn;
    private JButton _zoomOut;
    private JSplitPane _split1;
    private JSplitPane _split2;
    private JScrollPane _scrollBottom;
    private AltaCodeFrame _frame;
    private int _fontSizePref;
    private int _fontSizeCurr;
    private static final int FONT_SIZE_MIN = 4;
    private static final int FONT_SIZE_MAX = 40;
    private boolean _modified = false;
    private static FindDialog _findDlg;
    private boolean _editing = false;

    public boolean isModified() {
        return this._modified;
    }

    public void setModified(boolean modified) {
        this._modified = modified;
    }

    private static FindDialog getFindDlg(Window owner) {
        if (_findDlg == null) {
            _findDlg = new FindDialog(owner);
        }
        return _findDlg;
    }

    private static void destroyDlg() {
        if (_findDlg != null) {
            if (_findDlg.isVisible()) {
                _findDlg.setVisible(false);
            }
            _findDlg.dispose();
        }
        _findDlg = null;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (e.getEdit().isSignificant() && this.undoManager.isInProgress()) {
            this.undoManager.addEdit(e.getEdit());
            this.updateUndoButtons();
        }
    }

    public void undo() throws BadLocationException {
        while (this.undoManager.canUndo() && this._mainDoc.getText(0, this._mainDoc.getLength()).equals(this.courant)) {
            this.undoManager.undo();
        }
        this.updateUndoButtons();
        this.updateCourant();
    }

    public void updateUndoButtons() {
        if (this._editorUndoButton != null) {
            this._editorUndoButton.setEnabled(this.undoManager.canUndo() && this.isEditable());
            this._editorRedoButton.setEnabled(this.undoManager.canRedo() && this.isEditable());
            this._menuEditorItemUndo.setEnabled(this.undoManager.canUndo() && this.isEditable());
            this._menuEditorItemRedo.setEnabled(this.undoManager.canRedo() && this.isEditable());
        }
    }

    public void redo() throws BadLocationException {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
        int i = 0;
        while (this.undoManager.canRedo() && i < 2) {
            this.undoManager.redo();
            if (this._mainDoc.getText(0, this._mainDoc.getLength()).equals(this.courant)) continue;
            this.updateCourant();
            ++i;
        }
        if (i >= 2) {
            this.undoManager.undo();
        }
        this.updateUndoButtons();
        this.updateCourant();
    }

    public void updateCourant() throws BadLocationException {
        this.courant = this._mainDoc.getText(0, this._mainDoc.getLength());
    }

    public AltaEditor(AltaCodeFrame frame, final FctOperatorFinder fctOperator, int fontSize) {
        super(true);
        this._frame = frame;
        this._fontSizePref = this._fontSizeCurr = fontSize;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this._headerDoc = new OcasStyledDocument(new StyleContext());
        this._headerDoc.setDefaultFontSize(fontSize);
        this._header = new JTextPane(this._headerDoc);
        this.initTextPane(this._header);
        this._header.setFont(new Font("courier", 0, fontSize));
        this._header.setEditable(false);
        this._header.setBackground(new Color(232, 255, 245));
        this._mainDoc = new OcasStyledDocument(new StyleContext()){

            @Override
            protected boolean isFunction(String string) {
                return fctOperator.isKnowOperator(string);
            }
        };
        this._mainDoc.addUndoableEditListener(this);
        this._mainDoc.setDefaultFontSize(fontSize);
        this._editor = new EditorPane(this._mainDoc);
        this.initTextPane(this._editor);
        this._editor.setFont(new Font("courier", 0, fontSize));
        this._bottomDoc = new OcasStyledDocument(new StyleContext());
        this._bottomDoc.setDefaultFontSize(fontSize);
        this._bottom = new JTextPane(this._bottomDoc);
        this.initTextPane(this._bottom);
        this._bottom.setFont(new Font("courier", 0, fontSize));
        this._bottom.setEditable(false);
        this._bottom.setBackground(new Color(232, 255, 245));
        JPanel panelEditor = new JPanel();
        panelEditor.setLayout(new GridBagLayout());
        this._subEditor.setLayout(new GridBagLayout());
        this._subEditor.add((Component)this._editor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setText("\n");
        this.setText("");
        this._scrollBottom = new JScrollPane(this._bottom);
        this._split1 = new JSplitPane(0, new JScrollPane(this._header), this._scrollEditor);
        this._split1.setOneTouchExpandable(true);
        this._split2 = new JSplitPane(0, this._split1, this._scrollBottom);
        this._split2.setOneTouchExpandable(true);
        panelEditor.add((Component)this._split2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.8, 17, 1, new Insets(1, 10, 1, 10), 0, 0));
        this._split1.setDividerLocation(75);
        this._split1.setResizeWeight(0.0);
        this._split2.setResizeWeight(1.0);
        this.createActions();
        this.add("North", this.menubar);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.toolbar);
        panel.add("Center", panelEditor);
        this.add("Center", panel);
        this._zoomIn.addActionListener(e -> {
            if (this._fontSizeCurr > 4) {
                --this._fontSizeCurr;
            }
            this.setFontSize(this._fontSizeCurr);
        });
        this._zoomOut.addActionListener(e -> {
            if (this._fontSizeCurr < 40) {
                ++this._fontSizeCurr;
            }
            this.setFontSize(this._fontSizeCurr);
        });
        this._editor.addFocusListener(this.getFocusAdapter(this._editor));
        this._header.addFocusListener(this.getFocusAdapter(this._header));
        this._bottom.addFocusListener(this.getFocusAdapter(this._bottom));
        this._editor.addMouseListener(new EditorListener(this._editor));
        this._header.addMouseListener(new EditorListener(this._header));
        this._bottom.addMouseListener(new EditorListener(this._bottom));
    }

    private FocusAdapter getFocusAdapter(final JTextPane pane) {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CDesktopPane desktop = AltaEditor.this._frame.getApplication().getTopWindow().getDesktop();
                AltaDesktopPane altaDesktop = desktop.getDesktop();
                if (_findDlg != null && altaDesktop.getSelectedFrame() == AltaEditor.this._frame) {
                    _findDlg.setTextPane(pane);
                }
            }
        };
    }

    public void setEditorVisible(boolean visible) {
        this._scrollEditor.setVisible(visible);
    }

    public void setHideFooter() {
        this._split2.getBottomComponent().setMinimumSize(new Dimension());
        this._split2.setDividerLocation(1.0);
    }

    public void setFontSize(int fontSize) {
        this._headerDoc.setDefaultFontSize(fontSize);
        this._mainDoc.setDefaultFontSize(fontSize);
        this._bottomDoc.setDefaultFontSize(fontSize);
        this._header.repaint();
        this._editor.repaint();
        this._bottom.repaint();
        this._zoomIn.setEnabled(fontSize > 4);
        this._zoomOut.setEnabled(fontSize < 40);
    }

    public void setHeader(String text) {
        this.setTextInComponent(this._header, text);
    }

    public void setBottom(String text) {
        this.setTextInComponent(this._bottom, text);
    }

    public JTextPane getEditorComponent() {
        return this._editor;
    }

    public String getText() {
        return this._editor.getText();
    }

    public void setEditable(boolean state) {
        this._editor.setEditable(state);
        this._editorCutButton.setEnabled(state);
        this._editorPasteButton.setEnabled(state);
        this._editorRedoButton.setEnabled(state);
        this._editorUndoButton.setEnabled(state);
        this._menuEditorItemCut.setEnabled(state);
        this._menuEditorItemPaste.setEnabled(state);
        this._menuEditorItemRedo.setEnabled(state);
        this._menuEditorItemUndo.setEnabled(state);
        if (_findDlg != null) {
            _findDlg.setEditable(state);
        }
    }

    public boolean isEditable() {
        return this._editor.isEditable();
    }

    public void setCanBeEdited(boolean canBeEdited) {
        this._editing = canBeEdited;
    }

    public void setText(String text) {
        this.setCanBeEdited(false);
        boolean setText = this.setTextInComponent(this._editor, text);
        this.setCanBeEdited(true);
        if (!setText) {
            return;
        }
        try {
            this._mainDoc.update(0, text.length());
            this.updateCourant();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void initSelectionPosition() {
        this.setCanBeEdited(false);
        this.getEditorComponent().setCaretPosition(0);
        this.setCanBeEdited(true);
    }

    protected boolean setTextInComponent(final JTextComponent ctrl, String text) {
        String oldText = ctrl.getText();
        if (text.equals(oldText)) {
            return false;
        }
        Rectangle rect = ctrl.getVisibleRect();
        ctrl.setText(text);
        rect.y = (int)((double)rect.y / (double)oldText.length() * (double)text.length());
        final Rectangle runRect = new Rectangle(rect);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ctrl.scrollRectToVisible(runRect);
            }
        });
        return true;
    }

    private void createActions() {
        ActionListener actUndo = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AltaEditor.this.undo();
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        };
        this._editorUndoButton = new JButton(ResIcoCore.getImageIcon("BUT_UNDO"));
        this._editorUndoButton.setToolTipText(ResMsgVoc.getString("VOC_UNDO"));
        this._editorUndoButton.setRequestFocusEnabled(false);
        this._editorUndoButton.setMargin(new Insets(1, 1, 1, 1));
        this._editorUndoButton.addActionListener(actUndo);
        this._editorUndoButton.setEnabled(false);
        this._menuEditorItemUndo = new JMenuItem(ResMsgVoc.getString("VOC_UNDO"), ResIcoCore.getImageIcon("BUT_UNDO"));
        this._menuEditorItemUndo.addActionListener(actUndo);
        this._menuEditorItemUndo.setEnabled(false);
        this._menuEditorItemUndo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        ActionListener actRedo = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AltaEditor.this.redo();
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        };
        this._editorRedoButton = new JButton(ResIcoCore.getImageIcon("BUT_REDO"));
        this._editorRedoButton.setToolTipText(ResMsgVoc.getString("VOC_REDO"));
        this._editorRedoButton.setRequestFocusEnabled(false);
        this._editorRedoButton.setMargin(new Insets(1, 1, 1, 1));
        this._editorRedoButton.addActionListener(actRedo);
        this._editorRedoButton.setEnabled(false);
        this._menuEditorItemRedo = new JMenuItem(ResMsgVoc.getString("VOC_REDO"), ResIcoCore.getImageIcon("BUT_REDO"));
        this._menuEditorItemRedo.addActionListener(actRedo);
        this._menuEditorItemRedo.setEnabled(false);
        this._menuEditorItemRedo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        ActionListener actCopy = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaEditor.this._editor.copy();
                AltaEditor.this._editor.getText();
            }
        };
        this._editorCopyButton = new JButton(ResIcoCore.getImageIcon("BUT_COPY"));
        this._editorCopyButton.setRequestFocusEnabled(false);
        this._editorCopyButton.setMargin(new Insets(1, 1, 1, 1));
        this._editorCopyButton.setToolTipText(ResMsgVoc.getString("VOC_COPY"));
        this._editorCopyButton.addActionListener(actCopy);
        this._menuEditorItemCopy = new JMenuItem(ResMsgVoc.getString("VOC_COPY"));
        this._menuEditorItemCopy.setHorizontalTextPosition(4);
        this._menuEditorItemCopy.setIcon(ResIcoCore.getImageIcon("BUT_COPY"));
        this._menuEditorItemCopy.addActionListener(actCopy);
        ActionListener actCut = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaEditor.this._editor.cut();
                AltaEditor.this._editor.getText();
            }
        };
        this._editorCutButton = new JButton(ResIcoCore.getImageIcon("BUT_CUT"));
        this._editorCutButton.setRequestFocusEnabled(false);
        this._editorCutButton.setMargin(new Insets(1, 1, 1, 1));
        this._editorCutButton.setToolTipText(ResMsgVoc.getString("VOC_CUT"));
        this._editorCutButton.addActionListener(actCut);
        this._menuEditorItemCut = new JMenuItem(ResMsgVoc.getString("VOC_CUT"));
        this._menuEditorItemCut.setHorizontalTextPosition(4);
        this._menuEditorItemCut.setIcon(ResIcoCore.getImageIcon("BUT_CUT"));
        this._menuEditorItemCut.addActionListener(actCut);
        ActionListener actPaste = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaEditor.this._editor.paste();
                AltaEditor.this._editor.getText();
            }
        };
        this._editorPasteButton = new JButton(ResIcoCore.getImageIcon("BUT_PASTE"));
        this._editorPasteButton.setRequestFocusEnabled(false);
        this._editorPasteButton.setMargin(new Insets(1, 1, 1, 1));
        this._editorPasteButton.setToolTipText(ResMsgVoc.getString("VOC_PASTE"));
        this._editorPasteButton.addActionListener(actPaste);
        this._menuEditorItemPaste = new JMenuItem(ResMsgVoc.getString("VOC_PASTE"));
        this._menuEditorItemPaste.setHorizontalTextPosition(4);
        this._menuEditorItemPaste.setIcon(ResIcoCore.getImageIcon("BUT_PASTE"));
        this._menuEditorItemPaste.addActionListener(actPaste);
        AbstractAction actFind = new AbstractAction(ResMsgOcas.getString("CODE_FIND_EDIT_TITLE"), ResIcoCore.getImageIcon("BUT_SEARCH")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextPane textPane = AltaEditor.this.getFocusedTextPane();
                if (textPane == null) {
                    return;
                }
                if (_findDlg == null) {
                    Window owner = SwingUtilities.getWindowAncestor(AltaEditor.this);
                    FindDialog findDlg = AltaEditor.getFindDlg(owner);
                    findDlg.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(AltaEditor.this));
                    Point pt = findDlg.getLocation();
                    pt.x += 300;
                    Dimension size = findDlg.getSize();
                    int xLimit = owner.getX() + owner.getWidth();
                    int yLimit = owner.getY() + owner.getHeight();
                    if (pt.x + size.width > xLimit) {
                        pt.x -= pt.x + size.width - xLimit;
                    }
                    if (pt.y + size.height > yLimit) {
                        pt.y -= pt.y + size.height - yLimit;
                    }
                    findDlg.setLocation(pt);
                    findDlg.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                            AltaEditor.destroyDlg();
                        }
                    });
                    findDlg.setVisible(true);
                }
                _findDlg.setEditable(AltaEditor.this.isEditable());
                _findDlg.setTextPane(textPane);
                _findDlg.setSearchedString(textPane.getSelectedText());
            }
        };
        this._editorFindButton = new JButton(actFind);
        this._editorFindButton.setToolTipText(ResMsgOcas.getString("CODE_FIND_EDIT_TITLE"));
        this._editorFindButton.setText("");
        this._editorFindButton.setRequestFocusEnabled(false);
        this._editorFindButton.setMargin(new Insets(1, 1, 1, 1));
        this._menuEditorItemFind = new JMenuItem(actFind);
        this._menuEditorItemFind.setHorizontalTextPosition(4);
        this.getActionMap().put("find-replace", actFind);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl F"), "find-replace");
        this._zoomIn = new JButton(ResIcoCore.getImageIcon("BUT_ZOOM_MINUS"));
        this._zoomIn.setRequestFocusEnabled(false);
        this._zoomIn.setMargin(new Insets(1, 1, 1, 1));
        this._zoomIn.setEnabled(this._fontSizeCurr > 4);
        this._zoomIn.setToolTipText(ResMsgOcas.getString("VIEW_ZOOM_OUT"));
        this._zoomOut = new JButton(ResIcoCore.getImageIcon("BUT_ZOOM_PLUS"));
        this._zoomOut.setRequestFocusEnabled(false);
        this._zoomOut.setMargin(new Insets(1, 1, 1, 1));
        this._zoomOut.setEnabled(this._fontSizeCurr < 40);
        this._zoomOut.setToolTipText(ResMsgOcas.getString("VIEW_ZOOM_IN"));
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.add(this._editorCopyButton);
        this.toolbar.add(this._editorCutButton);
        this.toolbar.add(this._editorPasteButton);
        this.toolbar.add(this._editorUndoButton);
        this.toolbar.add(this._editorRedoButton);
        this.toolbar.add(this._editorFindButton);
        this.toolbar.add(this._zoomIn);
        this.toolbar.add(this._zoomOut);
        this.menubar = new JMenuBar();
        JMenu menuEdit = new JMenu(ResMsgOcas.getString("MENU_EDIT"));
        this.menubar.add(menuEdit);
        menuEdit.add(this._menuEditorItemCopy);
        menuEdit.add(this._menuEditorItemCut);
        menuEdit.add(this._menuEditorItemPaste);
        menuEdit.addSeparator();
        menuEdit.add(this._menuEditorItemUndo);
        menuEdit.add(this._menuEditorItemRedo);
        menuEdit.addSeparator();
        menuEdit.add(this._menuEditorItemFind);
    }

    public void refreshFont(int prefSize) {
        this._fontSizeCurr = prefSize + (this._fontSizeCurr - this._fontSizePref);
        if (this._fontSizeCurr < 4) {
            this._fontSizeCurr = 4;
        }
        if (this._fontSizeCurr > 40) {
            this._fontSizeCurr = 40;
        }
        this._fontSizePref = prefSize;
        this.setFontSize(this._fontSizeCurr);
    }

    public void updateLangage() {
        this._zoomIn.setToolTipText(ResMsgOcas.getString("VIEW_ZOOM_OUT"));
        this._zoomOut.setToolTipText(ResMsgOcas.getString("VIEW_ZOOM_IN"));
        this._editorCopyButton.setToolTipText(ResMsgVoc.getString("VOC_COPY"));
        this._editorCutButton.setToolTipText(ResMsgVoc.getString("VOC_CUT"));
        this._editorPasteButton.setToolTipText(ResMsgVoc.getString("VOC_PASTE"));
        this._editorFindButton.setToolTipText(ResMsgOcas.getString("CODE_FIND_EDIT_TITLE"));
        this._menuEditorItemCopy.setText(ResMsgVoc.getString("VOC_COPY"));
        this._menuEditorItemCut.setText(ResMsgVoc.getString("VOC_CUT"));
        this._menuEditorItemPaste.setText(ResMsgVoc.getString("VOC_PASTE"));
        this._menuEditorItemFind.setText(ResMsgOcas.getString("CODE_FIND_EDIT_TITLE"));
    }

    public void close() {
        this.getInputMap(2).remove(KeyStroke.getKeyStroke("ctrl F"));
        AltaEditor.destroyDlg();
    }

    public boolean isFocusedTab() {
        JTabbedPane mainPane = this._frame.getMainTabbedPanel();
        return mainPane.getSelectedComponent() == this._frame.getEditorPanel();
    }

    public void setFocusOnCodeTab() {
        JTabbedPane mainPane = this._frame.getMainTabbedPanel();
        if (Arrays.asList(mainPane.getComponents()).contains(this._frame.getEditorPanel())) {
            mainPane.setSelectedComponent(this._frame.getEditorPanel());
        }
    }

    public void toDoWhenActivated() {
        if (_findDlg != null) {
            _findDlg.setTextPane(this.getFocusedTextPane());
        }
    }

    public void toDoWhenDeActivated() {
        if (_findDlg != null) {
            _findDlg.setTextPane(null);
        }
    }

    private JTextPane getFocusedTextPane() {
        JTextPane textPane = null;
        textPane = this._editor.hasFocus() ? this._editor : (this._header.hasFocus() ? this._header : (this._bottom.hasFocus() ? this._bottom : this._editor));
        textPane.requestFocus();
        return textPane;
    }

    public void initTextPane(JTextPane pane) {
        pane.addCaretListener(e -> {
            if (!this._editing) {
                return;
            }
            if (!this.isFocusedTab()) {
                this.setFocusOnCodeTab();
            }
            if (!pane.hasFocus()) {
                pane.requestFocusInWindow();
            }
        });
    }

    public class EditorPane
    extends JTextPane {
        public EditorPane(StyledDocument styledDoc) {
            super(styledDoc);
            this.init();
        }

        public void init() {
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    AltaEditor.this._modified |= AltaEditor.this._editing;
                }
            });
            this.setCaretPosition(0);
        }

        public int getTextWidth() {
            int width = 0;
            StringTokenizer stoken = new StringTokenizer(super.getText(), "\n");
            FontMetrics fmetrics = this.getFontMetrics(super.getFont());
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextToken();
                int carCount = 10;
                int carTabCount = 0;
                for (int i = 0; i < token.length(); ++i) {
                    if (token.toCharArray()[i] == '\t') {
                        carCount += 12 - carTabCount;
                        carTabCount = 0;
                        continue;
                    }
                    ++carCount;
                    if (++carTabCount <= 12) continue;
                    carTabCount = 0;
                }
                width = Math.max(width, carCount * fmetrics.stringWidth(" "));
            }
            return width;
        }

        @Override
        public Dimension getSize() {
            return new Dimension(this.getTextWidth(), super.getSize().height);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.getTextWidth(), super.getPreferredSize().height);
        }
    }

    class EditorListener
    extends MouseAdapter {
        private JTextComponent _comp;
        boolean pressed;

        public EditorListener(JTextComponent comp) {
            this._comp = comp;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.pressed) {
                return;
            }
            this.update();
        }

        private void update() {
            if (_findDlg == null) {
                return;
            }
            _findDlg.setBegin(this._comp.getSelectionStart());
            _findDlg.setFound(false);
        }
    }
}

