/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;

public class FindDialog
extends JDialogCecilia {
    private JLabel _lFind;
    private JLabel _lReplace;
    private JTextField _tfFind;
    private JTextField _tfReplace;
    private JRadioButton _rbUp;
    private JRadioButton _rbDown;
    private JCheckBox _cbCaseSensitive;
    private JCheckBox _cbWholeWord;
    private JButton _bFind;
    private JButton _bReplace;
    private JButton _bReplaceAll;
    private JButton _bClose;
    private JTextPane _textPane;
    int _idxBegin = 0;
    int _idxBeginAfterReplace = 0;
    boolean _isFound = false;

    FindDialog(Window owner) {
        super(owner, ResMsgOcas.getString("CODE_FIND_EDIT_TITLE"));
        this.doCreate();
        this.addActions();
    }

    private void addActions() {
        this._bFind.addActionListener(e -> this.findStringAction());
        this._bFind.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && FindDialog.this._bFind.hasFocus()) {
                    FindDialog.this.findStringAction();
                }
            }
        });
        this._bReplace.addActionListener(e -> this.replaceAction());
        this._bReplace.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && FindDialog.this._bReplace.hasFocus()) {
                    FindDialog.this.replaceAction();
                }
            }
        });
        this._bReplaceAll.addActionListener(e -> {
            if (!this._textPane.isEditable()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this._tfFind.getText().length() == 0) {
                return;
            }
            String textToFind = this._tfFind.getText();
            String textToReplace = this._tfReplace.getText();
            String selectedText = this._textPane.getSelectedText();
            if (selectedText != null && !selectedText.isEmpty() && !this._textPane.getSelectedText().equals(textToFind)) {
                int res = JOptionPane.showConfirmDialog(this.getParent(), ResMsgOcas.getString("CODE_FIND_ASK_USER_FOR_REPLACE"));
                if (res == 2) {
                    return;
                }
                if (res == 0) {
                    String newText = selectedText.replace(textToFind, textToReplace);
                    this._textPane.replaceSelection(newText);
                    return;
                }
            }
            this._textPane.setText(this._textPane.getText().replace(textToFind, textToReplace));
        });
        this._bClose.addActionListener(e -> this.dispose());
        this._tfFind.addCaretListener(e -> this.setFound(false));
    }

    private void doCreate() {
        this._lFind = new JLabel(ResMsgOcas.getString("CODE_FIND_EDIT_FIND"));
        this._lReplace = new JLabel(ResMsgOcas.getString("CODE_FIND_EDIT_REPLACE"));
        this._tfFind = new JTextField();
        this._tfReplace = new JTextField();
        this._rbUp = new JRadioButton(ResMsgOcas.getString("CODE_FIND_EDIT_UP"));
        this._rbDown = new JRadioButton(ResMsgOcas.getString("CODE_FIND_EDIT_DOWN"));
        this._cbCaseSensitive = new JCheckBox(ResMsgOcas.getString("CODE_FIND_EDIT_CASE"));
        this._cbWholeWord = new JCheckBox(ResMsgOcas.getString("CODE_FIND_EDIT_WHOLE_WORD"));
        this._bFind = new JButton(ResMsgVoc.getString("VOC_SEARCH"));
        this._bReplace = new JButton(ResMsgOcas.getString("MENU_REPLACE"));
        this._bReplaceAll = new JButton(ResMsgOcas.getString("CODE_FIND_EDIT_REPLACE_ALL"));
        this._bClose = new JButton(ResMsgVoc.getString("VOC_CLOSE"));
        JPanel pDirection = new JPanel(new GridBagLayout());
        pDirection.setBorder(new TitledBorder(ResMsgOcas.getString("CODE_FIND_EDIT_DIRECTION")));
        pDirection.add((Component)this._rbUp, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        pDirection.add((Component)this._rbDown, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this._rbUp);
        bGroup.add(this._rbDown);
        this._rbDown.setSelected(true);
        JPanel pOption = new JPanel(new GridBagLayout());
        pOption.setBorder(new TitledBorder(ResMsgVoc.getString("VOC_OPTIONS")));
        pOption.add((Component)this._cbCaseSensitive, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        pOption.add((Component)this._cbWholeWord, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel p0 = new JPanel(new GridBagLayout());
        p0.add((Component)this._lFind, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        p0.add((Component)this._tfFind, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        p0.add((Component)this._lReplace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        p0.add((Component)this._tfReplace, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.add((Component)pDirection, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        p1.add((Component)pOption, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel p2 = new JPanel(new GridLayout(2, 3, 5, 5));
        p2.add(this._bFind);
        p2.add(this._bReplace);
        p2.add(this._bReplaceAll);
        p2.add(new JLabel(""));
        p2.add(this._bClose);
        p2.add(new JLabel(""));
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.add((Component)p0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        pnl.add((Component)p1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        pnl.add((Component)p2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        super.init();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add(pnl);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
    }

    public void findStringAction() {
        String text = this._textPane.getText();
        this._isFound = this.findString(text, this._tfFind.getText(), this._tfReplace.getText(), false);
        if (!this._isFound) {
            Toolkit.getDefaultToolkit().beep();
            boolean goUp = this._rbUp.isSelected();
            this._idxBegin = goUp ? this._textPane.getText().length() : 0;
            this._isFound = this.findString(text, this._tfFind.getText(), this._tfReplace.getText(), false);
        }
    }

    public void replaceAction() {
        if (this._isFound) {
            this._textPane.replaceSelection(this._tfReplace.getText());
            this._idxBegin = this._idxBeginAfterReplace;
        }
        this.findStringAction();
    }

    public void setEditable(boolean state) {
        this._lReplace.setEnabled(state);
        this._tfReplace.setEnabled(state);
        this._bReplace.setEnabled(state);
        this._bReplaceAll.setEnabled(state);
    }

    public void setSearchedString(String str) {
        if (str != null && str.length() != 0) {
            this._tfFind.setText(str);
            this._tfFind.selectAll();
        }
        this.setBegin(this._textPane.getSelectionStart());
        this._tfFind.requestFocusInWindow();
    }

    public JButton getCloseButton() {
        return this._bClose;
    }

    public JTextField getTfFind() {
        return this._tfFind;
    }

    public int getBegin() {
        return this._idxBegin;
    }

    public void setBegin(int begin) {
        this._idxBegin = begin;
    }

    public boolean isFound() {
        return this._isFound;
    }

    public void setFound(boolean found) {
        this._isFound = found;
    }

    boolean findString(String strOriginal, String strToFind, String strToReplace, boolean display) {
        boolean ww = this._cbWholeWord.isSelected();
        boolean cs = this._cbCaseSensitive.isSelected();
        boolean up = this._rbUp.isSelected();
        String toFind = strToFind;
        if (!cs) {
            strOriginal = strOriginal.toUpperCase();
            toFind = toFind.toUpperCase();
        }
        StringBuilder buf = new StringBuilder(strOriginal);
        int[] idx = new int[1];
        boolean found = false;
        if (up) {
            buf.reverse();
            toFind = new StringBuffer(toFind).reverse().toString();
            idx[0] = strOriginal.length() - this._idxBegin;
            found = this.findString(buf, toFind, idx);
            this._idxBegin = strOriginal.length() - idx[0];
            if (found) {
                this._idxBeginAfterReplace = this._idxBegin - strToReplace.length();
                this._idxBegin -= toFind.length();
                this.select(this._idxBegin, toFind.length());
            }
        } else {
            idx[0] = this._idxBegin;
            found = this.findString(buf, toFind, idx);
            this._idxBegin = idx[0];
            boolean bl = found = found && (!ww || this.wholeWord(toFind, this._idxBegin));
            if (found) {
                this.select(this._idxBegin, toFind.length());
                this._idxBeginAfterReplace = this._idxBegin + strToReplace.length();
                this._idxBegin += toFind.length();
            }
        }
        if (display && !found) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("CODE_FIND_ERROR"), ResMsgOcas.getString("CODE_FIND_EDIT_TITLE"), 1);
        }
        return found;
    }

    boolean wholeWord(String toFind, int begin) {
        try {
            boolean start = false;
            start = begin == 0 ? true : Character.isWhitespace(this._textPane.getDocument().getText(begin - 1, 1).charAt(0));
            boolean end = false;
            end = begin + toFind.length() == this._textPane.getText().length() ? true : Character.isWhitespace(this._textPane.getDocument().getText(begin + toFind.length(), 1).charAt(0));
            return start && end;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    boolean findString(StringBuilder buf, String str, int[] pos) {
        int idx = buf.indexOf(str, pos[0]);
        if (idx == -1) {
            return false;
        }
        pos[0] = idx;
        return true;
    }

    void select(int ind, int length) {
        int end = ind + length;
        int m = this._textPane.getText().length();
        if (end <= m) {
            this._textPane.select(ind, ind + length);
        } else {
            this._textPane.setCaretPosition(ind);
        }
    }

    public void setTextPane(JTextPane textPane) {
        this._textPane = textPane;
    }
}

