/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.gui;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.parser.OcasLexer;
import com.dassault.cecilia.lib.mbsa.translator.parser.OcasReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class OcasStyledDocument
extends DefaultStyledDocument {
    public static final String SDEFAULT = "alta-default";
    public static final String SFUNCTION = "alta-function";
    public static final String SNUMBER = "alta-number";
    public static final String SCOMMENT = "alta-comment";
    public static final String SICONE = "alta-icone";
    public static final String SWORD = "alta-reserved-word";
    public static final String SPONCT = "alta-punctuation";
    public static final String SEXTERN = "alta-extern";
    protected static final HashSet<String> __wordsExtern = new HashSet();

    public OcasStyledDocument(StyleContext sc) {
        super(sc);
        this.init(sc);
    }

    public void setDefaultFontSize(int fontSize) {
        Style sDefault = this.getStyle(SDEFAULT);
        StyleConstants.setFontSize(sDefault, fontSize);
        Style cDefault = this.getStyle("default");
        StyleConstants.setFontSize(cDefault, fontSize);
        int len = this.getLength();
        if (len > 0) {
            try {
                this.update(0, len - 1);
            }
            catch (BadLocationException e) {
                MsgTrans.LOG.log(Level.SEVERE, "Tuuuttt erreur ::setDefaultFontSize", e);
            }
        }
    }

    private void init(StyleContext sc) {
        Style cDefault = sc.getStyle("default");
        Style sDefault = sc.addStyle(SDEFAULT, cDefault);
        StyleConstants.setFontFamily(sDefault, "Courier");
        StyleConstants.setFontSize(sDefault, 12);
        StyleConstants.setForeground(sDefault, Color.black);
        Style s = sc.addStyle(SFUNCTION, sDefault);
        StyleConstants.setItalic(s, true);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, new Color(0, 128, 0));
        s = sc.addStyle(SNUMBER, sDefault);
        StyleConstants.setItalic(s, true);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, Color.magenta);
        s = sc.addStyle(SCOMMENT, sDefault);
        StyleConstants.setBold(s, true);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, new Color(178, 43, 0));
        s = sc.addStyle(SICONE, sDefault);
        StyleConstants.setBold(s, true);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, Color.red);
        s = sc.addStyle(SWORD, sDefault);
        StyleConstants.setBold(s, true);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, Color.blue);
        s = sc.addStyle(SPONCT, sDefault);
        StyleConstants.setBold(s, true);
        StyleConstants.setItalic(s, false);
        StyleConstants.setForeground(s, Color.black);
        s = sc.addStyle(SEXTERN, sDefault);
        StyleConstants.setBold(s, true);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, new Color(0, 128, 0));
    }

    public Element getRootElement() {
        return this.getDefaultRootElement();
    }

    public int getNumLine(int offset) {
        int numLigne;
        Element eltR = this.getRootElement();
        Element elt = eltR.getElement(numLigne = eltR.getElementIndex(offset));
        if (offset != elt.getEndOffset()) {
            return numLigne;
        }
        if (numLigne != 0) {
            return numLigne + 1;
        }
        return 0;
    }

    public int getNumColumn(int offset) {
        Element eltR = this.getRootElement();
        Element elt = eltR.getElement(eltR.getElementIndex(offset));
        int numColonne = offset - elt.getStartOffset();
        return numColonne;
    }

    public int getStartOffsetLine(int offset) {
        Element eltR = this.getRootElement();
        Element elt = eltR.getElement(eltR.getElementIndex(offset));
        return elt.getStartOffset();
    }

    public int getEndOffsetLine(int offset) {
        Element eltR = this.getRootElement();
        Element elt = eltR.getElement(eltR.getElementIndex(offset));
        return elt.getEndOffset();
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) {
        try {
            super.insertString(offs, str, a);
            this.update(offs, offs + str.length());
        }
        catch (BadLocationException ex) {
            MsgTrans.LOG.log(Level.SEVERE, "Tuuuttt erreur ::insertString", ex);
        }
    }

    @Override
    public void remove(int offs, int len) {
        try {
            super.remove(offs, len);
            this.update(offs, offs);
        }
        catch (BadLocationException ex) {
            MsgTrans.LOG.log(Level.SEVERE, "Tuuuttt erreur ::remove", ex);
        }
    }

    public void update(int start, int end) throws BadLocationException {
        boolean comment = false;
        Element cur = this.getCharacterElement(start);
        Object style = cur.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (SCOMMENT.equals(style)) {
            comment = true;
        }
        start = this.getStartOffsetLine(start);
        end = this.getEndOffsetLine(end);
        while (start > 0 && SCOMMENT.equals(style = (cur = this.getCharacterElement(start)).getAttributes().getAttribute(StyleConstants.NameAttribute))) {
            start = this.getStartOffsetLine(start - 1);
        }
        if (comment) {
            Element cur2;
            Object style2;
            int len = this.getLength();
            while (end < len && SCOMMENT.equals(style2 = (cur2 = this.getCharacterElement(end)).getAttributes().getAttribute(StyleConstants.NameAttribute))) {
                end = this.getEndOffsetLine(end + 1);
            }
        }
        this.realUpdate(start, end, false);
    }

    protected void realUpdate(int start, int end, boolean comment) throws BadLocationException {
        String text = this.getText(start, end - start);
        StringReader reader = new StringReader(text);
        OcasLexer lexer = new OcasLexer((Reader)reader, true, comment);
        int token = -1;
        try {
            token = lexer.yylex();
            while (token > 0) {
                String tokYYText = lexer.yytext();
                int tokNbChar = lexer.nbchar();
                int tokYYLen = lexer.yylength();
                int nextToken = lexer.yylex();
                Style current = this.findStyle(token, nextToken, tokYYText);
                if (current != null) {
                    this.setCharacterAttributes(start + tokNbChar, tokYYLen, current, true);
                }
                token = nextToken;
            }
            if (token == -1 && end < this.getLength()) {
                this.realUpdate(end, this.getEndOffsetLine(end + 1), true);
            }
        }
        catch (IOException e) {
            MsgTrans.LOG.log(Level.SEVERE, "Lexer error", e);
        }
    }

    private Style findStyle(int token, int nextToken, String word) {
        switch (token) {
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1022: 
            case 1023: 
            case 1024: 
            case 1025: 
            case 1035: 
            case 1036: 
            case 1037: 
            case 1038: 
            case 1039: 
            case 1040: 
            case 1041: 
            case 1042: 
            case 1043: 
            case 1044: 
            case 1046: 
            case 1047: {
                return this.getStyle(SWORD);
            }
            case 1016: 
            case 1017: 
            case 1018: 
            case 1021: {
                if (word.length() <= 0 || !Character.isLetter(word.charAt(0))) break;
                return this.getStyle(SWORD);
            }
            case 1019: 
            case 1020: 
            case 1026: 
            case 1027: {
                return this.getStyle(SNUMBER);
            }
            case 1028: {
                if (word.equals("icone")) {
                    return this.getStyle(SICONE);
                }
                if (nextToken == 40 && this.isFunction(word)) {
                    return this.getStyle(SFUNCTION);
                }
                if (!this.isExtern(word)) break;
                return this.getStyle(SEXTERN);
            }
            case 1029: 
            case 1030: 
            case 1031: 
            case 1032: 
            case 1033: 
            case 1034: {
                break;
            }
            case 1045: {
                return this.getStyle(SNUMBER);
            }
            case 2000: {
                return this.getStyle(SCOMMENT);
            }
        }
        return this.getStyle(SDEFAULT);
    }

    public static HashSet<String> getWordsExtern() {
        return __wordsExtern;
    }

    protected boolean isExtern(String word) {
        return __wordsExtern.contains(word);
    }

    protected boolean isFunction(String string) {
        return false;
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame("Help");
        final OcasStyledDocument doc = new OcasStyledDocument(new StyleContext());
        final JTextPane txt = new JTextPane();
        final JLabel monLabel = new JLabel("Auncune ligne saisie...");
        JButton monBouton = new JButton("Verifier syntaxe");
        txt.setDocument(doc);
        txt.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int debut = Math.min(e.getDot(), e.getMark());
                int fin = Math.max(e.getDot(), e.getMark());
                monLabel.setText("Ligne numero : " + doc.getNumLine(e.getDot() + 1) + " Colonne : " + doc.getNumColumn(e.getDot() + 1) + " (debut : " + debut + ", fin : " + fin + ")");
            }
        });
        frm.getContentPane().setLayout(new BorderLayout());
        frm.setBounds(150, 150, 600, 550);
        frm.setDefaultCloseOperation(3);
        monBouton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentTxt = txt.getText();
                OcasReader reader = new OcasReader((Reader)new StringReader(currentTxt));
                reader.run();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(monLabel);
        panel.add(monBouton);
        frm.getContentPane().add((Component)panel, "South");
        frm.getContentPane().add((Component)new JScrollPane(txt), "Center");
        frm.setVisible(true);
    }

    static {
        __wordsExtern.add("attribute");
        __wordsExtern.add("priority");
        __wordsExtern.add("remark");
        __wordsExtern.add("bucket");
        __wordsExtern.add("observer");
        __wordsExtern.add("law");
        __wordsExtern.add("parameter");
    }
}

