/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.node.io;

import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObjProperty;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.io.ocas51.CoreUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class AltaFileHeader {
    private String _creationDate = "";
    private String _creationOwner = "";
    private String _modificationDate = "";
    private String _modificationOwner = "";
    private String _comment = "";
    private String _version = "1";
    private String _externalField = "";
    private String _idExternLaetitia = "";
    static DateFormat _DATE_FORMAT = null;
    static DateFormat _DATE_FORMAT_FR = null;
    public static final String PROP_MIGRATION_USERS_OLD = "cecilia.migration.db51to60.HideLogOldUsers";
    static Set<String> _USERS_EXCEPTION = null;

    public void setVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    public void setCreationDate(String date) {
        this._creationDate = date;
    }

    public void setCreationOwner(String owner) {
        this._creationOwner = owner;
    }

    public void setModificationDate(String date) {
        this._modificationDate = date;
    }

    public void setModificationOwner(String owner) {
        this._modificationOwner = owner;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public void setIdExternLaetitia(String id) {
        this._idExternLaetitia = id;
    }

    public String getCreationDate() {
        return this._creationDate;
    }

    public String getCreationOwner() {
        return this._creationOwner;
    }

    public String getModificationDate() {
        return this._modificationDate;
    }

    public String getModificationOwner() {
        return this._modificationOwner;
    }

    public String getComment() {
        return this._comment;
    }

    public String getIdExternLaetitia() {
        return this._idExternLaetitia;
    }

    public String getExternalField() {
        return this._externalField;
    }

    public void setExternalField(String field) {
        this._externalField = field;
    }

    public AltaFileHeader getCopy() {
        AltaFileHeader copy = new AltaFileHeader();
        copy.setCreationDate(this._creationDate);
        copy.setCreationOwner(this._creationOwner);
        copy.setModificationDate(this._modificationDate);
        copy.setModificationOwner(this._modificationOwner);
        copy.setComment(this._comment);
        copy.setVersion(this._version);
        copy.setExternalField(this._externalField);
        copy.setIdExternLaetitia(this._idExternLaetitia);
        return copy;
    }

    public static AltaFileHeader loadFromFile(BufferedReader inData) throws IOException {
        String line;
        AltaFileHeader fileHeader = new AltaFileHeader();
        while ((line = inData.readLine()) != null) {
            if (line.indexOf("<creationDate") != -1) {
                fileHeader.setCreationDate(CoreUtil.searchString(line, "value="));
            }
            if (line.indexOf("<creationOwner") != -1) {
                fileHeader.setCreationOwner(CoreUtil.searchString(line, "value="));
            }
            if (line.indexOf("<modificationDate") != -1) {
                fileHeader.setModificationDate(CoreUtil.searchString(line, "value="));
            }
            if (line.indexOf("<modificationOwner") != -1) {
                fileHeader.setModificationOwner(CoreUtil.searchString(line, "value="));
            }
            if (line.indexOf("<version") != -1) {
                fileHeader.setVersion(CoreUtil.searchString(line, "value="));
            }
            if (line.indexOf("<comment>") != -1) {
                String comment = "";
                while ((line = inData.readLine()) != null) {
                    if (line.indexOf("</comment>") != -1) {
                        fileHeader.setComment(comment);
                        break;
                    }
                    if (!comment.equals("")) {
                        comment = comment.concat("\n");
                    }
                    comment = comment.concat(line);
                }
            }
            if (line.indexOf("<external>") != -1) {
                String externalField = "";
                while ((line = inData.readLine()) != null) {
                    if (line.indexOf("</external>") != -1) {
                        fileHeader.setExternalField(externalField);
                        break;
                    }
                    if (!externalField.equals("")) {
                        externalField = externalField.concat("\n");
                    }
                    externalField = externalField.concat(line);
                }
            }
            if (line.indexOf("<idExternLaetitia") != -1) {
                fileHeader.setIdExternLaetitia(CoreUtil.searchString(line, "value="));
            }
            if (line.indexOf("</header>") == -1) continue;
            break;
        }
        return fileHeader;
    }

    static synchronized DateFormat createDateProperties() {
        if (_DATE_FORMAT == null) {
            _DATE_FORMAT = new SimpleDateFormat("M/d/yy h:mm a");
            _DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
            _DATE_FORMAT_FR = new SimpleDateFormat("dd/MM/yy HH:mm");
            _DATE_FORMAT_FR.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        }
        return _DATE_FORMAT;
    }

    private Date parseDate(String strDate) {
        if (_DATE_FORMAT == null) {
            _DATE_FORMAT = AltaFileHeader.createDateProperties();
        }
        try {
            return _DATE_FORMAT.parse(strDate);
        }
        catch (ParseException en) {
            try {
                return _DATE_FORMAT_FR.parse(strDate);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    static synchronized Set<String> createUsersException() {
        if (_USERS_EXCEPTION == null) {
            _USERS_EXCEPTION = new HashSet<String>();
            String props = System.getProperty(PROP_MIGRATION_USERS_OLD);
            if (props != null) {
                StringTokenizer st = new StringTokenizer(props, ";");
                while (st.hasMoreTokens()) {
                    String user = st.nextToken().trim();
                    if (user.isEmpty()) continue;
                    _USERS_EXCEPTION.add(user.toLowerCase());
                }
            }
        }
        return _USERS_EXCEPTION;
    }

    public void convertToDBFolder(DBFolder dbFolder, DAOFactory daoFactory, DBLogs.DBLogsManager logMng) {
        DBObject dbObj;
        if (dbFolder == null) {
            throw new NullPointerException();
        }
        Date createDate = null;
        if (!this.getCreationDate().isEmpty() && (createDate = this.parseDate(this.getCreationDate())) == null) {
            logMng.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_HEADER_DATE_CREATE", this.getCreationDate()));
        }
        String createOwner = this.getCreationOwner().toLowerCase();
        DBUser createUser = null;
        if (!createOwner.isEmpty()) {
            createUser = daoFactory.createUserDAO().findByLogin(createOwner);
            if (createUser == null && !AltaFileHeader.createUsersException().contains(createOwner)) {
                logMng.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_HEADER_USER_CREATE", this.getCreationOwner()));
            }
        } else {
            createOwner = null;
        }
        Date modifyDate = null;
        if (!this.getModificationDate().isEmpty() && (modifyDate = this.parseDate(this.getModificationDate())) == null) {
            logMng.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_HEADER_DATE_MODIFY", this.getModificationDate()));
        }
        DBUser modifyUser = null;
        if (!this.getModificationOwner().isEmpty()) {
            String modifOwner = this.getModificationOwner().toLowerCase();
            modifyUser = daoFactory.createUserDAO().findByLogin(modifOwner);
            if (modifyUser == null && !AltaFileHeader.createUsersException().contains(modifOwner)) {
                logMng.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_HEADER_USER_MODIFY", this.getModificationOwner()));
            }
        }
        if (modifyDate == null && createDate != null) {
            modifyDate = createDate;
        }
        if (modifyUser == null && createUser != null) {
            modifyUser = createUser;
        }
        if (createDate != null) {
            dbFolder.setDateCreate(createDate);
        }
        if (createOwner != null && (dbObj = dbFolder.getObject()) != null) {
            DBObjProperty prop = dbObj.getProperty("object.creator");
            if (prop == null) {
                prop = new DBObjProperty().setName("object.creator").setType("String").setValue(createOwner);
                dbObj.addProperty(prop);
            } else {
                prop.setType("String").setValue(createOwner);
            }
        }
        if (modifyDate != null) {
            dbFolder.setDateModify(modifyDate);
        }
        if (modifyUser != null) {
            dbFolder.setUserModify(modifyUser);
        }
        if (!this.getComment().isEmpty()) {
            String comment = this.getComment();
            if (!DBFactory.verifyDescription(comment)) {
                logMng.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.getString("MSG_RAW_HEADER_TOO_LONG_DESCRIPTION"));
                logMng.addLog(DBLogs.DBLevel.INFO, comment);
                comment = comment.substring(0, 1023);
            }
            dbFolder.setDescription(comment);
        }
    }
}

