/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.operator.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.operator.OperatorDictionary;
import com.dassault.cecilia.dbobj.mbsa.operator.gui.OperatorDlgChooser;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class AltaOperatorIdPanel
extends JPanel {
    private static Logger _LOG = Logger.getLogger(AltaOperatorIdPanel.class.getPackage().getName());
    private static OperatorDlgChooser _dlgOperator = null;
    private static Object _LockerDlgOperator = new Object();
    private JTable _operatorIdTable;
    private List<AltaOperatorRef> _operatorIdData = new ArrayList<AltaOperatorRef>();
    private boolean _modified = false;
    CeciliaAppl _appl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OperatorDlgChooser getDlgChooser(Window win, CeciliaAppl appl) {
        if (_dlgOperator == null) {
            OperatorDlgChooser dlg = null;
            Object object = _LockerDlgOperator;
            synchronized (object) {
                if (_dlgOperator == null) {
                    dlg = new OperatorDlgChooser(win, appl);
                }
                if (_dlgOperator == null) {
                    _dlgOperator = dlg;
                }
            }
        }
        return _dlgOperator;
    }

    public AltaOperatorIdPanel(CeciliaAppl appl) {
        this.setLayout(new BorderLayout());
        this._appl = appl;
        this._operatorIdTable = new JTable(new OperatorIdTableModel());
        this._operatorIdTable.doLayout();
        this._operatorIdTable.setSelectionMode(0);
        this._operatorIdTable.setRowHeight(20);
        this._operatorIdTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() <= 1) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int row = AltaOperatorIdPanel.this._operatorIdTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                AltaOperatorRef operatorId = AltaOperatorIdPanel.this._operatorIdData.get(row);
                if (operatorId == null) {
                    return;
                }
                int col = AltaOperatorIdPanel.this._operatorIdTable.columnAtPoint(e.getPoint());
                if (col == 0) {
                    if (operatorId.getDBFolder() == null) {
                        return;
                    }
                    DBFolderTreeActivable tree = AltaOperatorIdPanel.this._appl.getTopWindow().getFolders().getTree(DBFolder.Family.OPERATOR);
                    if (tree != null) {
                        tree.edit(operatorId.getDBFolder(), false);
                    }
                } else if (col == 1 && !AltaOperatorIdPanel.this._appl.isReader()) {
                    Window win = SwingUtilities.getWindowAncestor(AltaOperatorIdPanel.this._operatorIdTable);
                    OperatorDlgChooser dlg = AltaOperatorIdPanel.getDlgChooser(win, AltaOperatorIdPanel.this._appl);
                    dlg.setFilterName(operatorId.getName());
                    dlg.setSelectFolder(operatorId.getDBFolder());
                    dlg.setVisible(true);
                    if (dlg.getResult()) {
                        DBFolder dbFolder = dlg.getSelectFolder();
                        if (dbFolder == null) {
                            _LOG.info("Le dossier selectionne est null.");
                        } else if (!dbFolder.equals(operatorId.getDBFolder())) {
                            if (!dbFolder.isVersion()) {
                                _LOG.info("Le dossier selectionne n'est pas une version.");
                            } else if (dbFolder.getFamily() != DBFolder.Family.OPERATOR) {
                                _LOG.info("Le dossier selectionne n'est pas un operateur.");
                            } else if (!dbFolder.getParent().getName().equals(operatorId.getName())) {
                                _LOG.info("Le dossier selectionne n'a pas le bon nom : " + operatorId.getName());
                            } else {
                                operatorId.setDBFolder(dbFolder);
                                ((OperatorIdTableModel)AltaOperatorIdPanel.this._operatorIdTable.getModel()).fireTableRowsUpdated(row, row);
                            }
                        }
                    }
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this._operatorIdTable);
        scroll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)scroll, "Center");
    }

    public void update(String code, String nameOperator) {
        OperatorDictionary opDic = this._appl.getDAOFactory().getOperatorDictionary();
        Set<String> names = opDic.findOperators(code);
        if (nameOperator != null) {
            names.remove(nameOperator);
        }
        if (this._operatorIdData.size() != 0) {
            for (int i = this._operatorIdData.size() - 1; i >= 0; --i) {
                AltaOperatorRef operatorId = this._operatorIdData.get(i);
                if (names.remove(operatorId.getName())) continue;
                this._operatorIdData.remove(operatorId);
            }
        }
        if (names.size() != 0) {
            for (String name : names) {
                DBFolder model;
                Set<DBFolder> folders = opDic.getOperatorsWithName(name);
                DBFolder select = null;
                if (folders.size() >= 1 && (model = folders.iterator().next()).isModel()) {
                    List<DBFolder> children = model.getChildren();
                    if (children == null) {
                        children = this._appl.getDAOFactory().createFolderDAO().findChildren(model);
                    }
                    select = children.get(children.size() - 1);
                }
                AltaOperatorRef operatorId = new AltaOperatorRef(name, select);
                this._operatorIdData.add(operatorId);
            }
        }
        this.refresh(false);
        this._operatorIdTable.repaint();
    }

    public void setUsedOperator(List<AltaOperatorRef> list) {
        this._operatorIdData = list;
    }

    public void setModified(boolean modified) {
        this._modified = modified;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void updateLangage() {
        this.refresh(false);
    }

    public void refresh(boolean columnChanged) {
        int c;
        int nbColumn = 0;
        Vector<String> tabColumnWidth = new Vector<String>();
        int selectedRow = this._operatorIdTable.getSelectedRow();
        OperatorIdTableModel model = (OperatorIdTableModel)this._operatorIdTable.getModel();
        if (!columnChanged) {
            nbColumn = model.getColumnCount();
            for (c = 0; c < nbColumn; ++c) {
                tabColumnWidth.addElement(new String("" + this._operatorIdTable.getTableHeader().getColumnModel().getColumn(c).getWidth()));
            }
        }
        model.fireTableChanged(null);
        if (columnChanged) {
            int tableWidth = this._operatorIdTable.getSize().width;
            nbColumn = model.getColumnCount() - 1;
            int columnWidth = tableWidth / nbColumn;
            for (int c2 = 1; c2 < nbColumn; ++c2) {
                this._operatorIdTable.getTableHeader().getColumnModel().getColumn(c2).setWidth(columnWidth);
            }
            columnWidth = tableWidth - columnWidth * (nbColumn - 1) - (nbColumn + 1);
            this._operatorIdTable.getTableHeader().getColumnModel().getColumn(nbColumn).setWidth(columnWidth);
        } else {
            for (c = 0; c < nbColumn; ++c) {
                this._operatorIdTable.getTableHeader().getColumnModel().getColumn(c).setWidth(Integer.parseInt((String)tabColumnWidth.elementAt(c)));
            }
        }
        this._operatorIdTable.setRowHeight(20);
        if (selectedRow != -1 && selectedRow < this._operatorIdTable.getRowCount()) {
            this._operatorIdTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    public class OperatorIdTableModel
    extends AbstractTableModel {
        OperatorIdTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AltaOperatorIdPanel.this._operatorIdData.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            AltaOperatorRef operatorId = AltaOperatorIdPanel.this._operatorIdData.get(row);
            switch (col) {
                case 0: {
                    return operatorId.getName();
                }
                case 1: {
                    DBFolder dbFolder = operatorId.getDBFolder();
                    if (dbFolder == null) {
                        return "???";
                    }
                    return dbFolder.getRefPath();
                }
            }
            return "Error";
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_NAME");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_OPERATOR");
                }
            }
            return "Error";
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
        }
    }
}

