/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.operator.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBOperHandlerXml
extends DBAltaNodeHandlerXml
implements DBNodeHandlerXml {
    public static final String ELT_CEC_OPERATOR = "cec.operator";
    AltaType _type;
    Map<String, AltaFlow> _mapFlows;
    Map<String, AltaOperatorRef> _mapOperators;
    String _code;

    public DBOperHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory cecFactory) {
        super(manager, locator, cecFactory);
        if (locator != null) {
            this.setLocator(locator);
        }
        this._mapFlows = new LinkedHashMap<String, AltaFlow>();
        this._mapOperators = new LinkedHashMap<String, AltaOperatorRef>();
    }

    public AltaType getType() {
        return this._type;
    }

    @Override
    public Collection<AltaFlow> getFlows() {
        return this._mapFlows.values();
    }

    @Override
    public Collection<AltaOperatorRef> getOperators() {
        return this._mapOperators.values();
    }

    @Override
    public String getCode() {
        return this._code;
    }

    @Override
    public SAXExtendedHandler getSAXHandler() {
        return this;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            if (!ELT_CEC_OPERATOR.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", ELT_CEC_OPERATOR), this.getLocator()));
            }
            this._type = this.readType(key, attrs);
        } else if ("alta.flow".equals(key)) {
            AltaFlow operande = this.readFlow(key, attrs);
            if (operande != null) {
                String name = operande.getName();
                if (this._mapFlows.containsKey(name)) {
                    this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_FLOW_ALREADY", name), this.getLocator()));
                }
                this._mapFlows.put(name, operande);
            }
        } else if ("alta.operator.ref".equals(key)) {
            AltaOperatorRef operator = this.readOperatorRef(key, attrs);
            if (operator != null) {
                String name = operator.getName();
                if (this._mapOperators.containsKey(name)) {
                    this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_OPERATOR_ALREADY", name), this.getLocator()));
                }
                this._mapOperators.put(name, operator);
            }
        } else if (!"alta.code".equals(key)) {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXParseException {
        if ("alta.code".equals(key)) {
            this._code = txt;
        }
        return ELT_CEC_OPERATOR.equals(key);
    }
}

