/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.operator.io;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.io.AltaFileHeader;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBNodeReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.io.ocas51.CoreUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DBOperReaderRaw
extends DBNodeReaderRaw {
    AltaFileHeader _properties;
    String _name;
    AltaType _type;
    Map<String, AltaFlow> _mapOperandes = new LinkedHashMap<String, AltaFlow>();

    public DBOperReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        super(dbFolder, logMng);
    }

    public String getName() {
        return this._name;
    }

    public AltaType getType() {
        return this._type;
    }

    @Override
    public AltaFileHeader getProperties() {
        return this._properties;
    }

    @Override
    public Collection<AltaFlow> getFlows() {
        return this._mapOperandes.values();
    }

    @Override
    public boolean readRaw(String data, CECFactory cecFactory) throws IOException {
        String line;
        BufferedReader inData = new BufferedReader(new StringReader(data));
        boolean bReadOperatorBalise = false;
        while ((line = inData.readLine()) != null) {
            int position = line.indexOf("<");
            if (position == -1) continue;
            if (line.indexOf("<header") != -1) {
                this._properties = AltaFileHeader.loadFromFile(inData);
                continue;
            }
            if (line.indexOf("<law>") == 0) {
                this.readLaw(inData, line);
                continue;
            }
            if ((position = (line = line.substring(position + 1)).indexOf(" ")) != -1) {
                String field = line.substring(0, position);
                if (!bReadOperatorBalise) {
                    if (!field.equals("operator")) continue;
                    bReadOperatorBalise = this.readOperator(line, position);
                    continue;
                }
                if (field.equals("operatorId")) {
                    this.readOperatorId(line, cecFactory);
                    continue;
                }
                if (!field.equals("operande")) continue;
                this.readOperande(line, cecFactory);
                continue;
            }
            if (line.indexOf("/operator") != 0) continue;
        }
        if (this._properties == null) {
            this._properties = new AltaFileHeader();
        }
        if (this._name == null) {
            return false;
        }
        if (this._type == null) {
            return false;
        }
        return this._code != null;
    }

    private boolean readOperator(String line, int position) {
        String name = "";
        if ((position = (line = line.substring(position)).indexOf("name=")) != -1) {
            String field = line.substring(position);
            name = CoreUtil.searchString(field);
        }
        if (!name.isEmpty()) {
            this._name = name;
            return true;
        }
        return false;
    }

    private void readOperande(String line, CECFactory cecFactory) {
        String field;
        String name = "";
        String type = "";
        int position = line.indexOf("name=");
        if (position != -1) {
            field = line.substring(position);
            name = CoreUtil.searchString(field);
        }
        if ((position = line.indexOf("type=")) != -1) {
            field = line.substring(position);
            type = CoreUtil.searchString(field);
        }
        if (!name.isEmpty() && !type.isEmpty()) {
            AltaType defaultType = AltaTypeParser.getType(type, cecFactory);
            if (this._name.equals(name)) {
                this._type = defaultType;
                if (this._type == null) {
                    this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_TYPE_VARIABLE", name, type));
                    this._type = AltaTypeBool.getInstance();
                }
            } else {
                if (defaultType == null) {
                    this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_TYPE_VARIABLE", name, type));
                    defaultType = AltaTypeBool.getInstance();
                }
                this._mapOperandes.put(name, new AltaFlow(name, defaultType));
            }
        }
    }
}

