/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.dbobj.mbsa.component.DBIconRenderer;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgaSimulContext
extends AlgaContext {
    SimStepper _stepper;
    AltaSystem _dbSystem;
    String _instance;
    Map<String, String> _mapRecordToField;
    Map<IDField, Color> _mapIDFieldToColor;

    public AlgaSimulContext(AltaSystem dbSystem, SimStepper sim) {
        this._dbSystem = dbSystem;
        this._stepper = sim;
        this._instance = "";
        this._mapRecordToField = new HashMap<String, String>();
        this._mapIDFieldToColor = new HashMap<IDField, Color>();
        this.initDBEnumColors();
    }

    public AlgaSimulContext setInstance(String instance) {
        this._instance = instance;
        return this;
    }

    public String getInstance() {
        return this._instance;
    }

    public ViewVariable getVariable(String path) {
        if (this._instance.isEmpty()) {
            return this._stepper.getVariable(path);
        }
        return this._stepper.getVariable(this._instance + path);
    }

    private void initDBEnumColors() {
        HashSet<AltaType> typesTreated = new HashSet<AltaType>();
        HashSet<AltaEquipment> eqpsTreated = new HashSet<AltaEquipment>();
        this.initDBEnumColors_rec(this._dbSystem, typesTreated, eqpsTreated);
    }

    private void initDBEnumColors_rec(AltaEquipment current, Set<AltaType> typesTreated, Set<AltaEquipment> eqpsTreated) {
        if (eqpsTreated.contains(current)) {
            return;
        }
        for (AltaLink link : current.getLinks()) {
            AltaType type = link.getFromFlow().getType();
            if (!(type instanceof DBType) || typesTreated.contains(type)) continue;
            if (type instanceof DBEnum) {
                DBEnum dbEnum = (DBEnum)type;
                if (this._dbSystem.getColors().getColorMap(dbEnum) != null) continue;
                this.addDBEnumToMap(dbEnum);
                typesTreated.add(dbEnum);
            } else if (type instanceof DBRecord) {
                DBRecord record = (DBRecord)type;
                for (int i = 0; i < record.getValueCount(); ++i) {
                    DBRecordField field = record.getFieldAt(i);
                    AltaType typeField = field.getType();
                    if (typesTreated.contains(typeField) || !(typeField instanceof DBEnum)) continue;
                    DBEnum dbEnum = (DBEnum)typeField;
                    if (this._dbSystem.getColors().getColorMap(dbEnum) != null) continue;
                    this.addDBEnumToMap(dbEnum);
                    typesTreated.add(dbEnum);
                }
            }
            typesTreated.add(type);
        }
        for (AltaSub sub : current.getSubs()) {
            if (!(sub.getNode() instanceof AltaEquipment)) continue;
            this.initDBEnumColors_rec((AltaEquipment)sub.getNode(), typesTreated, eqpsTreated);
        }
        eqpsTreated.add(current);
    }

    private final void addDBEnumToMap(DBEnum enumerate) {
        for (int i = 0; i < enumerate.getValueCount(); ++i) {
            String enumVal = enumerate.getValueAt(i);
            Color colVal = enumerate.getColorEnumerate(enumVal);
            this._mapIDFieldToColor.put(new IDField(enumerate, enumVal), colVal);
        }
    }

    public final Color getColorFromIDField(IDField field) {
        return this._mapIDFieldToColor.get(field);
    }

    public void setColorField(AltaLink link, String field) {
        if (link.isRecord()) {
            String path = null;
            try {
                path = link.appendTo(new StringBuilder().append(this._instance)).toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._mapRecordToField.put(path, field);
        }
    }

    public String getColorField(AltaLink link) {
        if (link.isRecord()) {
            StringBuilder path = new StringBuilder().append(this._instance);
            try {
                link.appendTo(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String fieldName = this._mapRecordToField.get(path.toString());
            if (fieldName != null) {
                return fieldName;
            }
            if (link.getToFlow().getType().getValueCount() > 0) {
                return link.getToFlow().getType().getValueAt(0);
            }
        }
        return null;
    }

    @Override
    public Color getColorLink(AltaLink link, boolean selected, boolean locked) {
        Object field;
        StringBuilder path = new StringBuilder().append(this._instance);
        try {
            link.appendTo(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ViewVariable var = null;
        AltaType type = null;
        if (link.isRecord()) {
            type = link.getToFlow().getType();
            if (type.getValueCount() > 0) {
                String fieldName = this._mapRecordToField.get(path.toString());
                if (fieldName == null) {
                    DBRecord record = (DBRecord)type;
                    for (int i = 0; i < record.getValueCount() && fieldName == null; ++i) {
                        DBRecordField field2 = record.getFieldAt(i);
                        if (!field2.isLinkToDisplay()) continue;
                        fieldName = field2.getName();
                    }
                    if (fieldName == null) {
                        fieldName = type.getValueAt(0);
                    }
                    this._mapRecordToField.put(path.toString(), fieldName);
                }
                path.append("^").append(fieldName);
                var = this._stepper.getVariable(path.toString());
                field = ((DBRecord)type).getValue(fieldName);
                type = field == null ? null : ((DBRecordField)field).getType();
            }
        } else {
            var = this._stepper.getVariable(path.toString());
            type = link.getToField() == null ? link.getToFlow().getType() : link.getToField().getType();
        }
        if (var != null && type != null) {
            Color color;
            AltaColor.ColorMap colorMap = this._dbSystem.getColors().getColorMap(type);
            if (colorMap != null) {
                return colorMap.getColor(var.getSValue());
            }
            if (type instanceof DBEnum && (color = this._mapIDFieldToColor.get(field = new IDField((DBEnum)type, var.getSValue()))) != null) {
                return color;
            }
        }
        return super.getColorLink(link, selected, locked);
    }

    @Override
    public Color getColorFlow(AltaFlow flow, boolean selected, boolean locked) {
        AltaColor.ColorMap colorMap;
        AltaType type;
        ViewVariable var = this.getVariable(flow.getName());
        if (var != null && (type = flow.getType()) != null && (colorMap = this._dbSystem.getColors().getColorMap(type)) != null) {
            return colorMap.getColor(var.getSValue());
        }
        return super.getColorFlow(flow, selected, locked);
    }

    @Override
    public DBIconRenderer getIconSub(AltaSub sub) {
        List<DBIconRenderer> icons;
        int value;
        ViewVariable var = this._stepper.getVariable(this._instance + sub.getName() + ".icone");
        if (var != null && (value = (int)var.getDValue()) >= 1 && (icons = sub.getNode().getSimuls()) != null && value <= icons.size()) {
            DBIconRenderer result = icons.get(value - 1);
            result.setDefaultRenderer(sub.getNode().getIconRenderer());
            return result;
        }
        return super.getIconSub(sub);
    }

    public static class IDField {
        private final DBEnum _type;
        private final String _fieldName;

        public IDField(DBEnum type, String fieldName) {
            this._type = type;
            this._fieldName = fieldName;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public DBEnum getType() {
            return this._type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IDField)) {
                return false;
            }
            IDField field = (IDField)obj;
            return field.getFieldName().equals(this.getFieldName()) && field.getType().equals(this.getType());
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = hashCode * 2 + this.getFieldName().hashCode();
            hashCode = hashCode * 3 + this.getType().hashCode();
            return hashCode;
        }

        public String toString() {
            return this.getType().toString() + "." + this.getFieldName();
        }
    }
}

