/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContent;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaContext;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaGraph;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaLink;
import com.dassault.cecilia.dbobj.mbsa.equipment.graph.AlgaNode;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentView;
import com.dassault.cecilia.dbobj.mbsa.simul.AlgaSimulContext;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimulFrame;
import com.dassault.cecilia.dbobj.mbsa.simul.AltaSimulView;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.lib.util.CopyUtility;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.OpenFolder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class AltaSimulPanel
extends AltaContentPanel {
    private static Logger _LOG = Logger.getLogger(AltaSimulPanel.class.getPackage().getName());
    AlgaSimulContext _context;
    AltaSystem _dbSystem;
    JPopupMenu _popupMenu;
    Map<AltaEquipment, AlgaContent> _contents = new IdentityHashMap<AltaEquipment, AlgaContent>();
    ArrayList<AltaSub> _fifoEquipments = new ArrayList();
    AbstractAction _actionBrowseUp = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AltaSimulPanel.this._fifoEquipments.size() == 0) {
                return;
            }
            AltaSimulPanel.this.popBrowse();
            AltaSimulPanel.this.refreshScroll(true);
            AltaSimulPanel.this.updateEnableCmds();
        }
    };
    AbstractAction _actionBrowseDown = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AlgaGraph graph = AltaSimulPanel.this.getView().getContent().getSelectedGraph();
            if (graph == null) {
                return;
            }
            if (!(graph instanceof AlgaNode)) {
                return;
            }
            AltaSub sub = ((AlgaNode)graph).getLogical();
            if (!(sub.getNode() instanceof AltaEquipment)) {
                return;
            }
            AltaSimulPanel.this.pushBrowse(sub);
            AltaSimulPanel.this.refreshScroll(true);
            AltaSimulPanel.this.updateEnableCmds();
        }
    };
    AbstractAction _actionBrowseDownOther = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AlgaGraph graph = AltaSimulPanel.this.getView().getContent().getSelectedGraph();
            if (graph == null) {
                return;
            }
            if (!(graph instanceof AlgaNode)) {
                return;
            }
            AltaSub sub = ((AlgaNode)graph).getLogical();
            if (!(sub.getNode() instanceof AltaEquipment)) {
                return;
            }
            AltaSimulFrame otherFrame = new AltaSimulFrame(AltaSimulPanel.this.getAppl(), AltaSimulPanel.this._dbSystem, AltaSimulPanel.this._dbSystem.getStepper());
            for (AltaSub altaSub : AltaSimulPanel.this._fifoEquipments) {
                otherFrame.getSimulPanel().pushBrowse(altaSub);
            }
            otherFrame.getSimulPanel().pushBrowse(sub);
            otherFrame.getSimulPanel().refreshContent();
            OpenFolder openFolder = AltaSimulPanel.this.getAppl().getOpenFolders().getOpenFolder(AltaSimulPanel.this._dbSystem.getDBFolder());
            openFolder.addFrame(otherFrame);
            otherFrame.showView(AltaSimulPanel.this.getAppl().getTopWindow().getDesktop());
        }
    };
    public static final int PROP_DEF_MBSA_SIMUL_RECORD_FIELD_LIMIT = 12;
    public static final String PROP_MBSA_SIMUL_RECORD_FIELD_LIMIT = "cecilia.mbsa.simul.MaxFieldForPopup";
    Map<Color, ColorLinkIcon> _mapIconColors = new HashMap<Color, ColorLinkIcon>();

    public AltaSimulPanel(CeciliaAppl appl, AltaSystem dbSystem, SimStepper stepper) {
        super(appl);
        this._dbSystem = dbSystem;
        this._context = new AlgaSimulContext(dbSystem, stepper);
    }

    @Override
    protected boolean isReadOnly() {
        return true;
    }

    @Override
    public void make() {
        super.make();
        this._contentView.addAltaChangeSelectListener(new AltaContentView.AltaChangeSelectListener(){

            @Override
            public void changeSelect() {
                AltaSimulPanel.this.getAppl().getTopWindow().getCentralizedStepper().setSelectObject(AltaSimulPanel.this._dbSystem);
                AltaSimulPanel.this.updateEnableCmds();
            }
        });
        this._popupMenu = new JPopupMenu();
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("SIMUL_GO_EVENT").createMenuItem());
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("SIMUL_GO_STATE").createMenuItem());
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("SIMUL_GO_DEBUG").createMenuItem());
        this._popupMenu.addSeparator();
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_UP").createMenuItem());
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_DOWN").createMenuItem());
        this._popupMenu.add(this.getAppl().getTopWindow().getAction("OCAS_DOWN_OTHER").createMenuItem());
        this._popupMenu.addSeparator();
        this._popupMenu.add(this._actionEdit.createMenuItem());
        this._contentView.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                AlgaGraph graph = AltaSimulPanel.this.getContent().getSelectedGraph();
                if (graph == null) {
                    return;
                }
                AltaSimulPanel.this._actionBrowseDown.actionPerformed(null);
            }
        });
    }

    public void displayPopup(MouseEvent e) {
        AltaLink link;
        int x = (int)((double)e.getX() / this.getView().getZoom());
        int y = (int)((double)e.getY() / this.getView().getZoom());
        AlgaGraph graph = this.getContent().getGraphAtPoint(x, y, this._context.getLinkDisplay());
        if (graph != null && graph instanceof AlgaLink && (link = ((AlgaLink)graph).getLogical()).isRecord()) {
            this.manageRecordPopup(link, e);
            e.consume();
            return;
        }
        this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
        e.consume();
    }

    protected void updateEnableCmds() {
        AlgaGraph graph = this.getContent().getSelectedGraph();
        boolean isNode = graph != null && graph instanceof AlgaNode;
        this._actionEdit.setEnabled(isNode);
        boolean isEquipment = isNode && ((AlgaNode)graph).getLogical().getNode() instanceof AltaEquipment;
        this._gui.getDelegateAction("OCAS_DOWN").setEnabled(this._actionBrowseDown, isEquipment);
        this._gui.getDelegateAction("OCAS_DOWN_OTHER").setEnabled(this._actionBrowseDownOther, isEquipment);
    }

    @Override
    protected AlgaContext createContext() {
        AlgaSimulContext context = this._context;
        context.setPaintingPort(true);
        context.setPrinting(false);
        context.setPolicyLabel(AlgaContext.PolicyLabel.NODE);
        return context;
    }

    @Override
    protected AltaContentView createContentView() {
        return new AltaSimulView(this.createContext(), this);
    }

    @Override
    protected AlgaContent getContent() {
        AltaEquipment current = this.getCurrentEquipment();
        AlgaContent content = this._contents.get(current);
        if (content == null) {
            content = current.getContent().getCopy(false, (CopyUtility)new CopyUtility.ByPass());
            this._contents.put(current, content);
        }
        return content;
    }

    @Override
    public void refreshContent() {
        this.getView().getContext().setInstance(this.constructCurrentInstance());
        super.refreshContent();
    }

    @Override
    public void toDoWhenActivated() {
        super.toDoWhenActivated();
        this._gui.getDelegateAction("OCAS_UP").addDelegate(this._actionBrowseUp).setEnabled(this._fifoEquipments.size() > 0);
        this._gui.getDelegateAction("OCAS_DOWN").addDelegate(this._actionBrowseDown);
        this._gui.getDelegateAction("OCAS_DOWN_OTHER").addDelegate(this._actionBrowseDownOther);
        this.updateEnableCmds();
    }

    @Override
    public void toDoWhenDeActivated() {
        this._gui.getDelegateAction("OCAS_UP").delDelegate(this._actionBrowseUp).setEnabled(false);
        this._gui.getDelegateAction("OCAS_DOWN").delDelegate(this._actionBrowseDown).setEnabled(false);
        this._gui.getDelegateAction("OCAS_DOWN_OTHER").delDelegate(this._actionBrowseDownOther).setEnabled(false);
        super.toDoWhenDeActivated();
    }

    @Override
    public AltaSimulView getView() {
        return (AltaSimulView)super.getView();
    }

    @Override
    protected boolean editOnlyReadOnly() {
        return true;
    }

    void pushBrowse(AltaSub sub) {
        if (sub.getNode() instanceof AltaEquipment) {
            this._fifoEquipments.add(sub);
            Container parent = SwingUtilities.getAncestorOfClass(AltaSimulFrame.class, this);
            if (parent != null && parent instanceof AltaSimulFrame) {
                ((AltaSimulFrame)parent).refreshPath();
            }
            this._gui.getDelegateAction("OCAS_UP").setEnabled(true);
        } else {
            _LOG.severe("Tentative d'ajouter un composant dans la pile de navigation d'un simulateur : " + this._dbSystem.getDBFolder().getRefPath());
        }
    }

    AltaSub popBrowse() {
        AltaSub sub = this._fifoEquipments.remove(this._fifoEquipments.size() - 1);
        Container parent = SwingUtilities.getAncestorOfClass(AltaSimulFrame.class, this);
        if (parent != null && parent instanceof AltaSimulFrame) {
            ((AltaSimulFrame)parent).refreshPath();
        }
        this._gui.getDelegateAction("OCAS_UP").setEnabled(this._fifoEquipments.size() > 0);
        return sub;
    }

    AltaEquipment getCurrentEquipment() {
        if (this._fifoEquipments.size() == 0) {
            return this._dbSystem;
        }
        AltaSub sub = this._fifoEquipments.get(this._fifoEquipments.size() - 1);
        return (AltaEquipment)sub.getNode();
    }

    String constructCurrentInstance() {
        if (this._fifoEquipments.size() == 0) {
            return "";
        }
        StringBuilder instance = new StringBuilder();
        for (int i = 0; i < this._fifoEquipments.size(); ++i) {
            instance.append(this._fifoEquipments.get(i).getName()).append(".");
        }
        return instance.toString();
    }

    protected void manageRecordPopup(AltaLink link, MouseEvent e) {
        DBRecord type = (DBRecord)link.getToFlow().getType();
        if (type.getValueCount() > Integer.getInteger(PROP_MBSA_SIMUL_RECORD_FIELD_LIMIT, 12)) {
            SimulField select;
            SimulFieldDlg dlg = this.createRecordDlg(link);
            if (dlg == null) {
                return;
            }
            Point pt = new Point(e.getX(), e.getY());
            SwingUtilities.convertPointToScreen(pt, this._contentView);
            dlg.setLocation(pt);
            JOptionCecilia.ensureDialogIsIntoScreen(dlg);
            dlg.setVisible(true);
            if (dlg.getResult() && (select = dlg.getSelectField()) != null) {
                this.getView().getContext().setColorField(link, select.getName());
                this.getView().repaint();
            }
        } else {
            JPopupMenu popup = this.createRecordPopup(link);
            if (popup != null) {
                popup.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
        }
    }

    ColorLinkIcon createColorLinkIcon(Color color) {
        ColorLinkIcon icon = this._mapIconColors.get(color);
        if (icon == null) {
            icon = new ColorLinkIcon(color);
            this._mapIconColors.put(color, icon);
        }
        return icon;
    }

    protected JPopupMenu createRecordPopup(AltaLink link) {
        JPopupMenu popup = new JPopupMenu();
        StringBuilder path = new StringBuilder();
        try {
            link.appendTo(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String select = this.getView().getContext().getColorField(link);
        DBRecord dbRecord = (DBRecord)link.getToFlow().getType();
        for (int i = 0; i < dbRecord.getValueCount(); ++i) {
            Color colorFromDBEnum;
            DBRecordField field = dbRecord.getFieldAt(i);
            AltaColor.ColorMap colorMap = this._dbSystem.getColors().getColorMap(field.getType());
            Color color = Color.black;
            ViewVariable var = this.getView().getContext().getVariable(path + "^" + field.getName());
            if (colorMap != null && var != null) {
                color = colorMap.getColor(var.getSValue());
            } else if (field.getType() instanceof DBEnum && (colorFromDBEnum = this.getView().getContext().getColorFromIDField(new AlgaSimulContext.IDField((DBEnum)field.getType(), var.getSValue()))) != null) {
                color = colorFromDBEnum;
            }
            String title = field.getName();
            if (title.equals(select)) {
                title = new StringBuilder(title.length() + 32).append("<html><b><u>").append(title).append("</u></b></html>").toString();
            }
            popup.add(new ColorSimulAction(link, title, field.getName(), this.createColorLinkIcon(color)));
        }
        return popup;
    }

    protected SimulFieldDlg createRecordDlg(AltaLink link) {
        ArrayList<SimulField> simuls = new ArrayList<SimulField>();
        SimulField selectFields = null;
        StringBuilder path = new StringBuilder();
        try {
            link.appendTo(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String select = this.getView().getContext().getColorField(link);
        DBRecord dbRecord = (DBRecord)link.getToFlow().getType();
        for (int i = 0; i < dbRecord.getValueCount(); ++i) {
            ViewVariable var;
            DBRecordField field = dbRecord.getFieldAt(i);
            AltaColor.ColorMap colorMap = this._dbSystem.getColors().getColorMap(field.getType());
            Color color = Color.black;
            if (colorMap != null && (var = this.getView().getContext().getVariable(path + "^" + field.getName())) != null) {
                color = colorMap.getColor(var.getSValue());
            }
            SimulField simul = new SimulField(field.getName(), color, this.createColorLinkIcon(color));
            if (selectFields == null && simul.getName().equals(select)) {
                selectFields = simul;
            }
            simuls.add(simul);
        }
        SimulFieldDlg dlg = new SimulFieldDlg(SwingUtilities.getWindowAncestor(this));
        dlg.prepare(simuls.toArray(), selectFields);
        return dlg;
    }

    static class SimulFieldDlg
    extends JDialogCecilia {
        JList _ctrlItems = new JList();

        public SimulFieldDlg(Window win) {
            super(win, ResMsgOcas.getString("TITLE_ALTA_SIMUL_FIELD"));
            this._ctrlItems.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof SimulField) {
                        SimulField field = (SimulField)value;
                        this.setIcon(field.getIcon());
                        this.setText(field.getName());
                    }
                    return this;
                }
            });
            this._ctrlItems.setVisibleRowCount(10);
            this._ctrlItems.getSelectionModel().setSelectionMode(0);
            this._ctrlItems.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    this.validDialog();
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JLabel(ResMsgOcas.getString("MSG_QST_RECORD_SIMUL_SELECT")), "North");
            this.getContentPane().add((Component)new JScrollPane(this._ctrlItems), "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.init();
            this.pack();
            this.setModal(true);
        }

        @Override
        protected boolean verifyParameters() {
            return true;
        }

        public void prepare(Object[] items, SimulField select) {
            this._ctrlItems.setListData(items);
            this._ctrlItems.setSelectedValue(select, true);
        }

        public SimulField getSelectField() {
            return (SimulField)this._ctrlItems.getSelectedValue();
        }
    }

    static class SimulField {
        String _name;
        Color _color;
        Icon _icon;

        SimulField(String name, Color color, Icon icon) {
            this._name = name;
            this._color = color;
            this._icon = icon;
        }

        public String getName() {
            return this._name;
        }

        public Color getColor() {
            return this._color;
        }

        public Icon getIcon() {
            return this._icon;
        }
    }

    static class ColorLinkIcon
    implements Icon {
        Color _color;

        ColorLinkIcon(Color color) {
            this._color = color;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.setColor(this._color);
            g.fillRect(x, y + 6, 16, 4);
            g.setColor(oldColor);
        }
    }

    class ColorSimulAction
    extends AbstractAction {
        AltaLink _link;
        String _name;

        ColorSimulAction(AltaLink link, String title, String name, Icon icon) {
            super(title, icon);
            this._link = link;
            this._name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AltaSimulPanel.this.getView().getContext().setColorField(this._link, this._name);
            AltaSimulPanel.this.getView().repaint();
        }
    }
}

