/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul;

import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.simul.CentralizedStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.SimulationAction;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.AltaSaveStateConfiguration;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class SimulationActionSaveInitStates
extends SimulationAction {
    CentralizedStepper _centralized;
    AltaSaveStateConfiguration _dlg;
    boolean _readOnly;

    SimulationActionSaveInitStates(CentralizedStepper owner, boolean readOnly) {
        super(ResMsgSimul.getString("PAN_STEP_SAVE"));
        this._centralized = owner;
        this._readOnly = readOnly;
        this.setIcon(ResIcoSimul.getImageIcon("GO_SAVE"));
        this.setDesc(ResMsgSimul.getString("PAN_STEP_SAVE_TTP"));
    }

    @Override
    public void altaModelChanged(ViewStepper acastep) {
        if (this._centralized.getModel() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this._centralized.getSimStepper() != null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String configName;
        AltaSystem model = this._centralized.getModel();
        if (model == null) {
            return;
        }
        List<AltaConfig> configs = model.getConfigs();
        if (configs == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(configs.size());
        for (int i = 0; i < configs.size(); ++i) {
            names.add(configs.get(i).getName());
        }
        if (this._dlg == null) {
            this._dlg = new AltaSaveStateConfiguration((Window)this._centralized.getUI(), this._centralized.getPlugable(), this._readOnly);
        }
        String defaultConfig = null;
        if (!model.getDBFolder().isFreeze() && !this._readOnly) {
            defaultConfig = "Config" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        }
        if (!this._dlg.display(names, defaultConfig)) {
            return;
        }
        Map<String, String> currentStates = model.getStepper().getCurrentStates();
        if (currentStates == null) {
            return;
        }
        if (this._dlg.isOnlychange()) {
            int confirm;
            AltaConfig config = model.getInitialConfiguration();
            HashMap<String, String> changeStates = new HashMap<String, String>(config.getStates());
            Map<String, String> initStates = model.getStepper().getInitStates();
            boolean flag = false;
            for (Map.Entry<String, String> current : currentStates.entrySet()) {
                String initValue = initStates.get(current.getKey());
                if (current.getValue().equals(initValue)) continue;
                flag = true;
                changeStates.put(current.getKey(), current.getValue());
            }
            if (!flag && (confirm = JOptionPane.showConfirmDialog(JOptionCecilia.getTopContainerOf(this._centralized.getUI()), ResMsgSimul.getString("SIMUL_SAVE_CONFIG_ALREADY_EXIST"), ResMsgOcas.getString("OCAS_INIT_STATES"), 0)) == 1) {
                return;
            }
            currentStates = changeStates;
        }
        if ((configName = this._dlg.getSelectedConfiguration()) != null) {
            this.saveInitialConfigToDataBase(model, configName, currentStates);
        } else {
            configName = this._dlg.getLoadedConfiguration();
            if (configName != null) {
                this.saveInitialConfigToFile(configName, currentStates, new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()));
            }
        }
    }

    private void saveInitialConfigToDataBase(AltaSystem model, String configName, Map<String, String> inits) {
        AltaConfig config = model.getConfig(configName);
        if (config == null) {
            config = new AltaConfig();
            config.setName(configName);
            config.setStates(inits);
            model.addConfig(config);
        } else {
            config.setStates(inits);
        }
        model.setModified(true);
    }

    private void saveInitialConfigToFile(String filename, Map<String, String> config, String date) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            writer.write("/* Config at ");
            writer.write(date);
            writer.write("*/");
            writer.newLine();
            for (Map.Entry<String, String> init : config.entrySet()) {
                writer.write(init.getKey());
                writer.write(" = ");
                writer.write(init.getValue());
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._centralized.getUI()), ResMsgSimul.getString("ERROR_SAVE_INFO") + "\n" + ex.getMessage(), ResMsgOcas.getString("OCAS_INIT_STATES"), 0);
        }
    }
}

