/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.SortFilterModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class AltaEventSelect
extends JDialogCecilia {
    TableModelFilterTransition _tableModel;
    JTable _tableCtrl;
    JLabel _lblCurrentNode;
    ViewTransition _selectTr;
    AbstractAction _actionOK;

    public AltaEventSelect(Window owner) {
        super(owner);
        this.make(owner);
    }

    private void make(Window owner) {
        this.init();
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(ResMsgSimul.getString("DLG_EVT_TITLE"));
        JPanel root = new JPanel(new BorderLayout());
        root.add((Component)new JLabel(ResMsgSimul.getString("DLG_EVT_LIST")), "North");
        this._tableModel = new TableModelFilterTransition();
        SortFilterModel sortModel = new SortFilterModel(this._tableModel);
        this._tableCtrl = new JTable(sortModel);
        sortModel.connectTable(this._tableCtrl);
        this._tableCtrl.setSelectionMode(0);
        this._tableCtrl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int idx = AltaEventSelect.this._tableCtrl.getSelectedRow();
                AltaEventSelect.this._selectTr = idx >= 0 ? (ViewTransition)AltaEventSelect.this._tableCtrl.getModel().getValueAt(idx, -1) : null;
                AltaEventSelect.this._actionOK.setEnabled(AltaEventSelect.this._selectTr != null);
            }
        });
        this._tableCtrl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                AltaEventSelect.this._actionOK.actionPerformed(null);
            }
        });
        JScrollPane scroll = new JScrollPane(this._tableCtrl);
        scroll.setPreferredSize(new Dimension(300, 200));
        root.add((Component)scroll, "Center");
        root.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)root, "Center");
        Box box = Box.createHorizontalBox();
        this._lblCurrentNode = new JLabel();
        this._lblCurrentNode.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        box.add(this._lblCurrentNode);
        this.getContentPane().add((Component)box, "North");
        JPanel panel = new JPanel();
        this._actionOK = new AbstractAction(ResMsgVoc.getString("VOC_OK")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AltaEventSelect.this._selectTr == null) {
                    return;
                }
                AltaEventSelect.this.setVisible(false);
            }
        };
        panel.add(new JButton(this._actionOK));
        this.putAction("CECILIA_ENTER", this._actionOK);
        AbstractAction actionESC = new AbstractAction(ResMsgVoc.getString("VOC_CANCEL")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AltaEventSelect.this._selectTr = null;
                AltaEventSelect.this.setVisible(false);
            }
        };
        panel.add(new JButton(actionESC));
        this.putAction("CECILIA_CANCEL", actionESC);
        this.getContentPane().add((Component)panel, "South");
        this._tableCtrl.getColumnModel().getColumn(0).setPreferredWidth(320);
        this._tableCtrl.getColumnModel().getColumn(1).setPreferredWidth(4000);
        this._tableCtrl.getColumnModel().getColumn(2).setPreferredWidth(5500);
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
    }

    public void display(SimStepper stepper, String baseFilter) {
        this._selectTr = null;
        this._actionOK.setEnabled(false);
        this._tableModel.defineModel(stepper, baseFilter);
        this._lblCurrentNode.setText(ResMsgSimul.getString("DLG_SELECT_NAME") + " " + baseFilter);
        if (this._tableModel.getRowCount() > 0) {
            this.setVisible(true);
        }
    }

    public ViewTransition getSelectTransition() {
        return this._selectTr;
    }

    class TableModelFilterTransition
    extends AbstractTableModel {
        private List<ViewTransition> _transs = new ArrayList<ViewTransition>();
        private String _baseFilter = "";

        public void defineModel(SimStepper stepper, String baseFilter) {
            this._transs.clear();
            this._baseFilter = baseFilter;
            if (this._baseFilter.length() > 0) {
                this._baseFilter = this._baseFilter + ".";
            }
            for (ViewTransition tr : stepper.getViewTranss()) {
                if (!tr.isValid() || this._baseFilter.length() > 0 && !tr.getFinalName().startsWith(this._baseFilter)) continue;
                this._transs.add(tr);
            }
            Collections.sort(this._transs, new Comparator<ViewTransition>(){

                @Override
                public int compare(ViewTransition o1, ViewTransition o2) {
                    int result = o1.getPath().compareTo(o2.getPath());
                    if (result == 0) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return result;
                }
            });
            this.fireTableDataChanged();
        }

        public void clear() {
            this._transs.clear();
            this._baseFilter = "";
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ViewTransition tr = this._transs.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return tr.getValid();
                }
                case 1: {
                    return tr.getFinalName().substring(this._baseFilter.length());
                }
                case 2: {
                    return tr.getDesc();
                }
            }
            return tr;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgSimul.getString("PAN_STEP_TR_TIME");
                }
                case 1: {
                    return ResMsgSimul.getString("PAN_STEP_NAME");
                }
                case 2: {
                    return ResMsgSimul.getString("PAN_STEP_TR_DESC");
                }
            }
            return "<Error>";
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Double.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this._transs.size();
        }
    }
}

