/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewDomain;
import com.dassault.cecilia.core.cecilia.stepper.ViewRoot;
import com.dassault.cecilia.core.cecilia.stepper.ViewVariable;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TableRendererVarValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class AltaStateValueEditor
extends TableRendererVarValue
implements TableCellEditor {
    ValueDialog _dlg = null;
    private EventListenerList _listeners = new EventListenerList();
    private ChangeEvent _evt = new ChangeEvent(this);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setFont(isSelected && hasFocus ? this._italicFont : this._plainFont);
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this._dlg == null) {
            Window win = SwingUtilities.getWindowAncestor(table);
            this._dlg = new ValueDialog(win);
        }
        ViewVariable var = (ViewVariable)table.getValueAt(row, -1);
        SimStepper stepper = (SimStepper)table.getValueAt(row, -2);
        ViewRoot root = stepper.getRoot();
        root.setWithDomain(true);
        ViewDomain domain = var.getDomain(root);
        this._dlg._editor.refresh(domain, var.getSValue());
        root.setWithDomain(false);
        this._dlg._variable.setText(var.getFinalName());
        this._dlg.pack();
        Dimension tSize = table.getSize();
        Dimension dSize = this._dlg.getSize();
        Rectangle rect = table.getCellRect(row, column, false);
        Point pt = new Point((tSize.width - dSize.width) / 2, rect.y + rect.height);
        SwingUtilities.convertPointToScreen(pt, table);
        Dimension size = this._dlg.getSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (pt.x + size.width > screen.width) {
            pt.x -= pt.x + size.width - screen.width;
        }
        if (pt.y + size.height > screen.height) {
            pt.y -= pt.y + size.height - screen.height;
        }
        this._dlg.setLocation(pt);
        return this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
    }

    @Override
    public void cancelCellEditing() {
        this._dlg.setVisible(false);
    }

    @Override
    public boolean stopCellEditing() {
        this._dlg.setVisible(false);
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        if (this._dlg == null) {
            return null;
        }
        return this._dlg._editor.verify();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return !(anEvent instanceof MouseEvent) || ((MouseEvent)anEvent).getClickCount() >= 2;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        this._dlg.setVisible(true);
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this._listeners.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this._listeners.remove(CellEditorListener.class, l);
    }

    protected void fireEditionStopped() {
        Object[] lists = this._listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)lists[i + 1]).editingStopped(this._evt);
        }
    }

    protected void fireEditionCanceled() {
        Object[] lists = this._listeners.getListenerList();
        for (int i = lists.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)lists[i + 1]).editingCanceled(this._evt);
        }
    }

    class ValueDialog
    extends JDialogCecilia {
        ValueEditor _editor;
        JLabel _variable;

        ValueDialog(Window win) {
            super(win);
            this.init();
        }

        @Override
        protected void init() {
            super.init();
            this.setTitle(ResMsgSimul.getString("DLG_STATE_CHANGE"));
            this.getContentPane().setLayout(new BorderLayout());
            this._variable = new JLabel("Variable");
            this._variable.setAlignmentX(0.5f);
            this._variable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)this._variable, "North");
            this._editor = new ValueEditor();
            this.getContentPane().add((Component)this._editor, "Center");
            JPanel panel = new JPanel();
            AbstractAction _actionOK = new AbstractAction(ResMsgVoc.getString("VOC_OK")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String value = ValueDialog.this._editor.verify();
                    if (value != null) {
                        ValueDialog.this.setVisible(false);
                        AltaStateValueEditor.this.fireEditionStopped();
                    }
                }
            };
            panel.add(new JButton(_actionOK));
            this.putAction("CECILIA_ENTER", _actionOK);
            AbstractAction actionESC = new AbstractAction(ResMsgVoc.getString("VOC_CANCEL")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ValueDialog.this.setVisible(false);
                    AltaStateValueEditor.this.fireEditionCanceled();
                }
            };
            panel.add(new JButton(actionESC));
            this.putAction("CECILIA_CANCEL", actionESC);
            this.getContentPane().add((Component)panel, "South");
            this.pack();
            this.setModal(true);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    AltaStateValueEditor.this.fireEditionCanceled();
                }
            });
        }
    }

    class ValueEditor
    extends JPanel {
        JComboBox _enumValue = new JComboBox();
        JTextField _infinityValue;
        boolean _enumSelect;
        ViewDomain _domain;
        String _currentValue;

        ValueEditor() {
            this._enumValue.setEditable(false);
            this._infinityValue = new JTextField(10);
            this._enumSelect = false;
            this.add(this._infinityValue);
        }

        private void switchEditor() {
            if (this._enumSelect) {
                this.remove(this._enumValue);
                this.add(this._infinityValue);
            } else {
                this.remove(this._infinityValue);
                this.add(this._enumValue);
            }
            this._enumSelect = !this._enumSelect;
        }

        public void refresh(ViewDomain domain, String value) {
            this._domain = domain;
            this._currentValue = value;
            if (this._domain.isEnum()) {
                this._enumValue.removeAllItems();
                for (int i = 0; i < this._domain.getChildCount(); ++i) {
                    this._enumValue.addItem(this._domain.getChildAt(i).toString());
                }
                this._enumValue.setSelectedItem(value);
                if (!this._enumSelect) {
                    this.switchEditor();
                }
            } else {
                this._infinityValue.setText(this._currentValue);
                if (this._enumSelect) {
                    this.switchEditor();
                }
            }
        }

        public String verify() {
            if (this._domain.isEnum()) {
                Object select = this._enumValue.getSelectedItem();
                if (this._currentValue.equals(select)) {
                    return null;
                }
                String strValue = select.toString();
                if (this._domain.verifyValue(strValue) == null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgSimul.msgFormat("ERR_STATE_DOMAIN", strValue, this._domain.toString()));
                    return null;
                }
                return strValue;
            }
            String strValue = this._infinityValue.getText();
            if (this._domain.verifyValue(strValue = strValue.trim()) == null) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgSimul.msgFormat("ERR_STATE_DOMAIN", strValue, this._domain.toString()));
                return null;
            }
            return strValue;
        }
    }
}

