/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.Row;
import com.dassault.cecilia.lib.util.collection.TreeRank;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class SortFilterModel
extends AbstractTableModel
implements TableModelListener {
    static Comparator<? super Row> _naturalCmp = new Comparator<Row>(){

        @Override
        public int compare(Row r1, Row r2) {
            return r1._index - r2._index;
        }
    };
    InverseCmp _inverseCmp = new InverseCmp();
    FakeSortSet _fakeNaturalSet = new FakeSortSet();
    TreeRank _naturalRows;
    TableModel _model;
    TreeRank _rows;
    Map<Integer, Integer> _mapInverse;
    int _columnSort;
    Order _orderSort;
    Comparator _columnSortCmp;
    Comparator _currentSort;
    ArrayList<Comparator<Row>> _compars = new ArrayList();

    public void setComparator(final int column, final Comparator cmp) {
        this.ensureCapacity(this._compars, column);
        Comparator<Row> cmpRow = new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                Object o2;
                Object o1 = SortFilterModel.this._model.getValueAt(r1._index, column);
                int result = cmp.compare(o1, o2 = SortFilterModel.this._model.getValueAt(r2._index, column));
                if (result == 0) {
                    return r1._index - r2._index;
                }
                return result;
            }
        };
        this._compars.set(column, cmpRow);
    }

    protected Comparator<Row> getComparator(int column) {
        this.ensureCapacity(this._compars, column);
        Comparator<Row> cmp = this._compars.get(column);
        if (cmp == null) {
            Class<?> cl = this._model.getColumnClass(column);
            if (Arrays.asList(cl.getInterfaces()).contains(Comparable.class)) {
                final int col = column;
                cmp = new Comparator<Row>(){

                    @Override
                    public int compare(Row r1, Row r2) {
                        Object o2;
                        Object o1 = SortFilterModel.this._model.getValueAt(r1._index, col);
                        int result = ((Comparable)o1).compareTo(o2 = SortFilterModel.this._model.getValueAt(r2._index, col));
                        if (result == 0) {
                            return r1._index - r2._index;
                        }
                        return result;
                    }
                };
            }
            this._compars.set(column, cmp);
        }
        return cmp;
    }

    public void sort(int column) {
        if (column != this._columnSort) {
            this._columnSort = column;
            this._columnSortCmp = this.getComparator(column);
            if (this._columnSortCmp == null) {
                this._orderSort = Order.NOSORT;
                this._currentSort = null;
            } else {
                this._orderSort = Order.ASCENDANT;
                this._currentSort = this._columnSortCmp;
            }
        } else if (this._currentSort != null) {
            switch (this._orderSort) {
                case ASCENDANT: {
                    this._orderSort = Order.DESCENDANT;
                    this._currentSort = this._inverseCmp.setComparator(this._columnSortCmp);
                    break;
                }
                case DESCENDANT: {
                    this._orderSort = Order.NOSORT;
                    break;
                }
                case NOSORT: {
                    this._orderSort = Order.ASCENDANT;
                    this._currentSort = this._columnSortCmp;
                }
            }
        } else {
            return;
        }
        this.sort();
        this.fireTableDataChanged();
    }

    protected void createNaturalRows() {
        this._naturalRows = new TreeRank(_naturalCmp);
        this._naturalRows.addAll(this._fakeNaturalSet.setSize(this._model.getRowCount()));
    }

    protected void sort() {
        if (this._orderSort == Order.NOSORT) {
            this._rows = this._naturalRows;
        } else {
            TreeRank rows = new TreeRank(this._currentSort);
            rows.addAll((Collection)this._rows);
            assert (rows.size() == this._rows.size());
            this._rows = rows;
            this._mapInverse = new HashMap<Integer, Integer>();
            Iterator iterow = this._rows.iterator();
            Iterator iterN = this._naturalRows.iterator();
            while (iterow.hasNext()) {
                this._mapInverse.put(((Row)iterow.next())._index, ((Row)iterN.next())._index);
            }
        }
    }

    public int modelRow(int indexView) {
        return ((Row)this._rows.get((int)indexView))._index;
    }

    public int viewRow(int indexModel) {
        if (this._orderSort == Order.NOSORT) {
            return indexModel;
        }
        return this._mapInverse.get(indexModel);
    }

    public SortFilterModel(TableModel model) {
        this._model = model;
        this._model.addTableModelListener(this);
        this._orderSort = Order.NOSORT;
        this._columnSort = -1;
        this.changeOwner();
    }

    protected void changeOwner() {
        this.createNaturalRows();
        this._rows = this._naturalRows;
        this.sort();
    }

    @Override
    public int getColumnCount() {
        return this._model.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this._model.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this._model.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this._model.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this._model.getValueAt(this.modelRow(rowIndex), columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this._model.isCellEditable(this.modelRow(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this._model.setValueAt(aValue, this.modelRow(rowIndex), columnIndex);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int first = e.getFirstRow();
        int last = e.getLastRow();
        int col = e.getColumn();
        int type = e.getType();
        TableModel src = (TableModel)e.getSource();
        if (first == -1) {
            this.changeOwner();
            this.fireTableStructureChanged();
        } else if (first == 0 && last >= this.getRowCount()) {
            this.changeOwner();
            this.fireTableDataChanged();
        } else {
            for (int i = first; i <= last; ++i) {
                int idx = this.viewRow(i);
                this.fireTableChanged(new TableModelEvent(src, idx, idx, col, type));
            }
        }
    }

    public void connectTable(final JTable table) {
        JTableHeader header = table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int tableColumn = table.columnAtPoint(e.getPoint());
                int modelColumn = table.convertColumnIndexToModel(tableColumn);
                SortFilterModel.this.sort(modelColumn);
            }
        });
        header.setDefaultRenderer(new SortHeaderCellRenderer());
    }

    private void ensureCapacity(List lst, int idx) {
        while (idx >= lst.size()) {
            lst.add(null);
        }
    }

    private static enum Order {
        NOSORT,
        ASCENDANT,
        DESCENDANT;

    }

    private class InverseCmp
    implements Comparator<Row> {
        Comparator<Row> _cmp;

        private InverseCmp() {
        }

        public Comparator<Row> setComparator(Comparator<Row> cmp) {
            this._cmp = cmp;
            return this;
        }

        @Override
        public int compare(Row r1, Row r2) {
            if (this._cmp == null) {
                return 0;
            }
            return this._cmp.compare(r2, r1);
        }
    }

    private class FakeSortSet
    extends AbstractSet<Row>
    implements SortedSet<Row> {
        int _size;

        private FakeSortSet() {
        }

        @Override
        public Iterator<Row> iterator() {
            return new Iterator<Row>(){
                int _idx = 0;

                @Override
                public boolean hasNext() {
                    return this._idx < FakeSortSet.this._size;
                }

                @Override
                public Row next() {
                    return new Row(this._idx++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this._size;
        }

        public Set<Row> setSize(int size) {
            this._size = size;
            return this;
        }

        @Override
        public Comparator<? super Row> comparator() {
            return _naturalCmp;
        }

        @Override
        public Row first() {
            return new Row(0);
        }

        @Override
        public Row last() {
            return new Row(this._size - 1);
        }

        @Override
        public SortedSet<Row> headSet(Row toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<Row> subSet(Row fromElement, Row toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<Row> tailSet(Row fromElement) {
            throw new UnsupportedOperationException();
        }
    }

    private class SortHeaderCellRenderer
    extends DefaultTableCellRenderer {
        Icon _ascendant;
        Icon _descendant;

        public SortHeaderCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String base;
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            String string = base = value == null ? "" : value.toString();
            if (SortFilterModel.this._columnSort == column) {
                switch (SortFilterModel.this._orderSort) {
                    case ASCENDANT: {
                        if (this._ascendant == null) {
                            this._ascendant = ResIcoSimul.getImageIcon("SORT_ASCENDANT");
                        }
                        this.setIcon(this._ascendant);
                        break;
                    }
                    case DESCENDANT: {
                        if (this._descendant == null) {
                            this._descendant = ResIcoSimul.getImageIcon("SORT_DESCENDANT");
                        }
                        this.setIcon(this._descendant);
                        break;
                    }
                    case NOSORT: {
                        this.setIcon(null);
                    }
                }
            } else {
                this.setIcon(null);
            }
            this.setText(base);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

