/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.dbobj.mbsa.simul.gui.AltaTabDebugPanel;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabInfo;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabInfoAccessor;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabbedDragDropInfo;
import com.dassault.cecilia.dbobj.mbsa.simul.gui.TabbedDragDropTransferable;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;

public class TabbedDragDropListener
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private AltaTabDebugPanel _tabbed;
    private Component _source;
    public static DataFlavor javaTabbedFlavor = new DataFlavor(TabbedDragDropInfo.class, "AltaRica Drag'n Drop");

    public TabbedDragDropListener(AltaTabDebugPanel tgt) {
        this._tabbed = tgt;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (!this.isDropAcceptable(event)) {
            event.rejectDrop();
            return;
        }
        event.acceptDrop(2);
        Transferable transferable = event.getTransferable();
        try {
            TabbedDragDropInfo info = (TabbedDragDropInfo)transferable.getTransferData(javaTabbedFlavor);
            this._tabbed.addTab(info._info, info._pane);
            this._tabbed._tab.setSelectedComponent(info._pane);
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        event.dropComplete(true);
    }

    public boolean isDragAcceptable(DropTargetDragEvent event) {
        if (!event.isDataFlavorSupported(javaTabbedFlavor)) {
            return false;
        }
        return (event.getDropAction() & 2) != 0;
    }

    public boolean isDropAcceptable(DropTargetDropEvent event) {
        DropTarget dt;
        if (!event.isDataFlavorSupported(javaTabbedFlavor)) {
            return false;
        }
        if ((event.getDropAction() & 2) == 0) {
            return false;
        }
        return !(event.getSource() instanceof DropTarget) || (dt = (DropTarget)event.getSource()).getComponent() != this._tabbed;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        this._source = this._tabbed._tab.getSelectedComponent();
        if (!(this._source instanceof TabInfoAccessor)) {
            return;
        }
        if (event.getComponent().getComponentAt(event.getDragOrigin()).getBounds().equals(this._source.getBounds())) {
            return;
        }
        TabInfo tinf = ((TabInfoAccessor)((Object)this._source)).getTabInfo();
        TabbedDragDropTransferable transferable = new TabbedDragDropTransferable(new TabbedDragDropInfo(this._source, tinf));
        event.startDrag(null, transferable, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess() && event.getDropAction() == 2) {
            this._tabbed.removeTab(this._source);
        }
    }
}

