/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.gui;

import com.dassault.cecilia.core.cecilia.stepper.SimStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.core.cecilia.stepper.ViewTransition;
import com.dassault.cecilia.dbobj.mbsa.simul.ResIcoSimul;
import com.dassault.cecilia.dbobj.mbsa.simul.ResMsgSimul;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public abstract class TableModelTransition
extends AbstractTableModel {
    SimStepper _stepper = null;
    private ImageIcon _fireable;
    private ImageIcon _notfireable;

    protected void setModel(ViewStepper vwStep) {
        this._stepper = vwStep != null && vwStep instanceof SimStepper ? (SimStepper)vwStep : null;
        this.fireTableDataChanged();
    }

    protected Object getValue(ViewTransition tr, int arg1) {
        switch (arg1) {
            case 0: {
                Image img;
                if (tr.isValid()) {
                    Image img2;
                    if (this._fireable == null && (img2 = ResIcoSimul.getInstance().getImage("FIRE_ENABLE", 10, 10)) != null) {
                        this._fireable = new ImageIcon(img2);
                    }
                    return this._fireable;
                }
                if (this._notfireable == null && (img = ResIcoSimul.getInstance().getImage("FIRE_DISABLE", 10, 10)) != null) {
                    this._notfireable = new ImageIcon(img);
                }
                return this._notfireable;
            }
            case 1: {
                return tr.getValid();
            }
            case 2: {
                return tr.getFinalName();
            }
            case 3: {
                return tr.getDesc();
            }
        }
        return tr;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResMsgSimul.getString("PAN_STEP_TR_FIRE");
            }
            case 1: {
                return ResMsgSimul.getString("PAN_STEP_TR_TIME");
            }
            case 2: {
                return ResMsgSimul.getString("PAN_STEP_NAME");
            }
            case 3: {
                return ResMsgSimul.getString("PAN_STEP_TR_DESC");
            }
        }
        return "<Error>";
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return ImageIcon.class;
            }
            case 1: {
                return Double.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    public int getColumnWidth(int column) {
        switch (column) {
            case 0: {
                return 320;
            }
            case 1: {
                return 320;
            }
            case 2: {
                return 4000;
            }
            case 3: {
                return 5500;
            }
        }
        return 1;
    }

    public void connectTable(final JTable table) {
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                ViewTransition tr = null;
                if (!lsm.isSelectionEmpty()) {
                    tr = (ViewTransition)table.getValueAt(lsm.getMinSelectionIndex(), -1);
                }
                if (TableModelTransition.this._stepper != null) {
                    TableModelTransition.this._stepper.setSelectTransition(tr);
                }
            }
        });
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 32) {
                    TableModelTransition.this._stepper.triggerSelectTransition();
                }
            }
        });
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                TableModelTransition.this._stepper.triggerSelectTransition();
            }
        });
    }
}

