/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.simul.seq;

import com.dassault.cecilia.core.cecilia.stepper.ViewStepper;
import com.dassault.cecilia.dbobj.mbsa.simul.seq.SeqNode;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import com.dassault.cecilia.lib.util.xmlparser.SAXProcessParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SeqSet {
    private SeqNode _root;
    private SeqNode _current;
    private boolean _endOfSeq;

    public SeqSet() {
        this._current = this._root = new SeqNode();
    }

    void addSequence(List<String> seq) {
        assert (seq.size() < 1000);
        if (seq.size() == 0) {
            return;
        }
        SeqNode current = this._root;
        for (String itemName : seq) {
            SeqNode itemNode = current.getNext(itemName);
            if (itemNode == null) {
                itemNode = new SeqNode(itemName);
                itemNode._parent = current;
                current.nexts().add(itemNode);
            }
            current = itemNode;
        }
        current._idx = 0;
        while (current != null) {
            ++current._number;
            current = current._parent;
        }
    }

    public void finnish() {
        this._root.finnish();
    }

    public void plugWithStepper(ViewStepper stepper, Set<String> unknowEvts) {
        this._current = this._root;
        this._endOfSeq = false;
        this._root.propagateErrorToEnd(false);
        this._root.validWithStepper(stepper, unknowEvts);
    }

    public void defineSelectSeq(String[] seq, ViewStepper stepper) {
        this._endOfSeq = false;
        SeqNode current = seq == null ? null : this._root;
        for (int i = 0; current != null && i < seq.length; ++i) {
            if (current._nexts == null) {
                current = null;
                continue;
            }
            SeqNode find = null;
            for (SeqNode child : current._nexts) {
                if (!child._name.equals(seq[i])) continue;
                find = child;
                break;
            }
            current = find;
        }
        this._current = current;
        if (this._current != null) {
            if (this._current._idx >= 0) {
                this._endOfSeq = true;
            }
            if (this._current._nexts != null) {
                for (SeqNode child : current._nexts) {
                    child.setFireable(stepper);
                }
            }
        }
    }

    public int indexOf(SeqNode current) {
        int idx = -1;
        SeqNode parent = current._parent;
        while (parent != null) {
            SeqNode child;
            if (current._idx >= 0) {
                ++idx;
            }
            if (current == this._current) {
                return idx;
            }
            for (int i = 0; i < parent._nexts.size() && (child = parent._nexts.get(i)) != current; ++i) {
                idx += child._number;
            }
            current = parent;
            parent = parent._parent;
        }
        if (current == this._current) {
            return idx;
        }
        return -1;
    }

    public int getSeqCount() {
        if (this._current == null) {
            return 0;
        }
        return this._current._number;
    }

    public SeqNode getSeqAt(int idx) {
        if (this._current == null) {
            return null;
        }
        return this._current.getSeqAt(idx);
    }

    public String getPrevious() {
        if (this._current == null) {
            return "";
        }
        return this._current.toString();
    }

    public SeqNode getNextAt(int idx) {
        if (this._current == null) {
            return null;
        }
        if (this._endOfSeq) {
            return null;
        }
        return this._current.getNextAt(idx);
    }

    public String getLastAt(int idx) {
        if (this._current == null) {
            return "";
        }
        return this._current.getSeqAt(idx).toString(this._current.getNextAt(idx));
    }

    public int getSeqNumber() {
        return this._root._number;
    }

    public int getCurrentSeqNumber() {
        if (this._current != null) {
            return this._current._number;
        }
        return 0;
    }

    public int getSeqErreur() {
        return this._root._erreur;
    }

    public int getCurrentSeqErreur() {
        if (this._current != null) {
            return this._current._erreur;
        }
        return 0;
    }

    public void load(File file) throws SAXParseException {
        class SeqSetSAXParser
        extends SAXProcessParser {
            List<String> _curSeq;
            int _nbrSeq;
            int _state;

            public SeqSetSAXParser(File XMLFile) {
                super(XMLFile, null);
                this._nbrSeq = 0;
                this._state = 0;
                this._curSeq = new ArrayList<String>();
            }

            protected SAXExtendedHandler createSAXHandler() {
                return new 1SeqSetSAXParser.SeqGenInfoHandler();
            }

            class 1SeqSetSAXParser.SeqGenInfoHandler
            extends SAXExtendedHandler {
                1SeqSetSAXParser.SeqGenInfoHandler() {
                }

                public void startAction(String name, Map<String, String> attrs, boolean startAction) throws SAXParseException {
                    switch (_state) {
                        case 0: {
                            if (!name.equals("seqgen")) break;
                            _state = 1;
                            break;
                        }
                        case 1: {
                            if (!name.equals("result")) break;
                            _state = 2;
                            break;
                        }
                        case 2: {
                            if (!name.equals("seq")) break;
                            _curSeq.clear();
                            _state = 3;
                            break;
                        }
                        case 3: {
                            if (!name.equals("tr")) break;
                            if (!this.findParent("seq")) {
                                throw new SAXParseException("Element 'tr' not in element 'seq'", this.getLocator());
                            }
                            String evt = attrs.get("evt");
                            if (evt == null) {
                                throw new SAXParseException("Attribute 'evt' of element 'tr' not define", this.getLocator());
                            }
                            _curSeq.add(evt);
                        }
                    }
                }

                public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXParseException {
                    switch (_state) {
                        case 2: {
                            if (!name.equals("result")) break;
                            _state = -1;
                            break;
                        }
                        case 3: {
                            if (!name.equals("seq")) break;
                            ++_nbrSeq;
                            SeqSet.this.addSequence(_curSeq);
                            _state = 2;
                        }
                    }
                    return false;
                }

                public void endDocument() throws SAXException {
                    super.endDocument();
                    if (_nbrSeq == 0) {
                        throw new SAXParseException("No sequences found", this.getLocator());
                    }
                }
            }
        }
        SeqSetSAXParser parser = new SeqSetSAXParser(file);
        parser.action();
        this.finnish();
    }
}

