/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system;

import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaTypeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeBool;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.lib.util.AlphaNumComparator;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class AltaColor {
    public static final int PROP_OCAS_COLOR_OK_DEF = 65280;
    public static final String PROP_OCAS_COLOR_OK = "cecilia.mbsa.simul.ColorOK";
    public static final int PROP_OCAS_COLOR_BOF_DEF = 255;
    public static final String PROP_OCAS_COLOR_BOF = "cecilia.mbsa.simul.ColorBOF";
    public static final int PROP_OCAS_COLOR_KO_DEF = 0xFF0000;
    public static final String PROP_OCAS_COLOR_KO = "cecilia.mbsa.simul.ColorKO";
    public static final int PROP_OCAS_COLOR_DEF_DEF = 0;
    public static final String PROP_OCAS_COLOR_DEF = "cecilia.mbsa.simul.ColorDEF";
    Map<AltaType, ColorMap> _mapTypes = new TreeMap<AltaType, ColorMap>(AltaColor.getComparator());
    static Comparator<AltaType> __comparatorName = new Comparator<AltaType>(){
        Comparator<String> _delegate = AlphaNumComparator.getInstance((boolean)false);

        @Override
        public int compare(AltaType o1, AltaType o2) {
            return this._delegate.compare(o1.toLabel(), o2.toLabel());
        }
    };
    private static Color DEF = Color.getColor("cecilia.mbsa.simul.ColorDEF", 0);
    private static Color OK = Color.getColor("cecilia.mbsa.simul.ColorOK", 65280);
    private static Color BOF = Color.getColor("cecilia.mbsa.simul.ColorBOF", 255);
    private static Color KO = Color.getColor("cecilia.mbsa.simul.ColorKO", 0xFF0000);

    public static Comparator<? super AltaType> getComparator() {
        return __comparatorName;
    }

    public AltaColor() {
        this.findOrCreateColorMap(AltaTypeBool.getInstance());
    }

    public AltaColor(AltaColor src) {
        for (AltaType type : src._mapTypes.keySet()) {
            ColorMap colorMap = src._mapTypes.get(type);
            this._mapTypes.put(type.getCopy(), new ColorMap(colorMap));
        }
        this.findOrCreateColorMap(AltaTypeBool.getInstance());
    }

    public void setColors(Map<AltaType, ColorMap> colors) {
        this._mapTypes = new TreeMap<AltaType, ColorMap>(AltaColor.getComparator());
        this._mapTypes.putAll(colors);
        this.findOrCreateColorMap(AltaTypeBool.getInstance());
    }

    public boolean isValidType(AltaType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof DBRecord) {
            return false;
        }
        if (type instanceof AltaTypeInt) {
            return false;
        }
        return !(type instanceof AltaTypeFloat);
    }

    public ColorMap findOrCreateColorMap(AltaType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type instanceof DBRecord) {
            throw new IllegalArgumentException();
        }
        if (type instanceof AltaTypeInt) {
            throw new IllegalArgumentException();
        }
        if (type instanceof AltaTypeFloat) {
            throw new IllegalArgumentException();
        }
        ColorMap colorMap = this._mapTypes.get(type);
        if (colorMap == null) {
            int size = type.getValueCount();
            colorMap = new ColorMap(type, size);
            for (int i = 0; i < size; ++i) {
                String value = type.getValueAt(i).toString();
                Color color = null;
                if (type instanceof DBEnum) {
                    color = ((DBEnum)type).getColorEnumerate(value);
                }
                if (color == null) {
                    if (i == 0) {
                        color = OK;
                    } else if (i == size - 1) {
                        color = KO;
                    } else if (i == (size - 1) / 2) {
                        color = BOF;
                    }
                    if (color == null) {
                        color = DEF;
                    }
                }
                colorMap.putColor(value, color);
            }
            this._mapTypes.put(type, colorMap);
        }
        return colorMap;
    }

    public ColorMap removeColorMap(AltaType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return this._mapTypes.remove(type);
    }

    public void toXML(Appendable out, String indent0) throws IOException {
        String indent1 = indent0 + "  ";
        String indent2 = indent1 + "  ";
        out.append(indent0).append("<").append("alta.colors").append(">\n");
        for (Map.Entry<AltaType, ColorMap> type : this._mapTypes.entrySet()) {
            out.append(indent1).append("<").append("alta.colors.type");
            DBAltaTypeHandlerXml.writeType(type.getKey(), out);
            out.append(">\n");
            type.getValue().toXML(out, indent2);
            out.append(indent1).append("</").append("alta.colors.type").append(">\n");
        }
        out.append(indent0).append("</").append("alta.colors").append(">\n");
    }

    public int getNbrTypes() {
        return this._mapTypes.size();
    }

    public Set<AltaType> getTypes() {
        return this._mapTypes.keySet();
    }

    public Iterator<AltaType> iteratorTypes() {
        return this._mapTypes.keySet().iterator();
    }

    public Iterator<ColorMap> iteratorColors() {
        return this._mapTypes.values().iterator();
    }

    public ColorMap getColorMap(AltaType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type instanceof DBRecord) {
            throw new IllegalArgumentException();
        }
        if (type instanceof AltaTypeInt) {
            return null;
        }
        if (type instanceof AltaTypeFloat) {
            return null;
        }
        for (Map.Entry<AltaType, ColorMap> entry : this._mapTypes.entrySet()) {
            if (!type.equivalents(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean update(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        boolean result = true;
        for (AltaType type : new ArrayList<AltaType>(this._mapTypes.keySet())) {
            if (!(type instanceof DBEnum)) continue;
            DBEnum newType = (DBEnum)DBWrap.createOrFind(daoFactory, ((DBEnum)type).getDBFolder(), logMng, DBEnum.class);
            ColorMap colorMap = this._mapTypes.remove(type);
            if (newType != null) {
                ColorMap newColorMap = new ColorMap(newType, newType.getValueCount());
                for (int i = 0; i < newType.getValueCount(); ++i) {
                    String val = newType.getValueAt(i);
                    Color color = colorMap.getColor(val);
                    if (color == null) {
                        color = newColorMap.getDefaultColor();
                    }
                    newColorMap.putColor(val, color);
                }
                this._mapTypes.put(newType, newColorMap);
                continue;
            }
            result = false;
        }
        return result;
    }

    public static class ColorMap {
        ArrayList<Item> _items;
        AltaType _type;

        public ColorMap(AltaType type, int size) {
            this._type = type;
            this._items = new ArrayList(size);
        }

        public ColorMap(ColorMap src) {
            this._type = src._type;
            this._items = new ArrayList(src.getItems().size());
            for (Item item : src.getItems()) {
                this._items.add(new Item(item.getValue(), item.getColor()));
            }
        }

        public AltaType getType() {
            return this._type;
        }

        public List<Item> getItems() {
            return this._items;
        }

        private int indexOf(String value) {
            for (int i = this.getItems().size() - 1; i >= 0; --i) {
                if (!value.equals(this.getItems().get(i).getValue())) continue;
                return i;
            }
            return -1;
        }

        public Color getColor(String value) {
            int idx = this.indexOf(value);
            if (idx < 0) {
                return null;
            }
            return this.getItems().get(idx).getColor();
        }

        public Color putColor(String value, Color color) {
            int idx = this.indexOf(value);
            if (idx < 0) {
                this.getItems().add(new Item(value, color));
                return null;
            }
            Item item = this.getItems().get(idx);
            Color oldColor = item.getColor();
            item.setColor(color);
            return oldColor;
        }

        public Color getDefaultColor() {
            return DEF;
        }

        public void toXML(Appendable out, String indent0) throws IOException {
            int nbrValue = this.getItems().size();
            for (int i = 0; i < nbrValue; ++i) {
                out.append(indent0).append("<").append("alta.colors.case");
                DBObjectXmlUtility.appendXML(out.append(" ").append("value").append("='"), this.getItems().get(i).getValue()).append("'");
                DBObjectXmlUtility.writeAttrColor(out, "color", true, this.getItems().get(i).getColor());
                out.append("/>\n");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(256);
            int nbrValue = this.getItems().size();
            for (int i = 0; i < nbrValue; ++i) {
                if (i > 0) {
                    sb.append(";");
                }
                sb.append(this.getItems().get(i));
            }
            return sb.toString();
        }

        public static class Item {
            String _value;
            Color _color;

            public Item(String value, Color color) {
                this._value = value;
                this._color = color;
            }

            public String getValue() {
                return this._value;
            }

            public Color getColor() {
                return this._color;
            }

            public void setColor(Color color) {
                this._color = color;
            }

            public String toString() {
                return this._value + "=>" + this._color;
            }
        }
    }
}

