/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.core.swing.table.ArrayTableModel;
import com.dassault.cecilia.core.swing.table.TablePanel;
import com.dassault.cecilia.core.swing.table.WithErrorTableCellRenderer;
import com.dassault.cecilia.core.swing.tree.JTreeUtility;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaEquipmentTreeModel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaEquipmentTreeRenderer;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaInit;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaInitEditDlg;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;

public class AltaConfigEditDlg
extends JDialogCecilia {
    Plugable _plugable;
    JTextField _ctrlName;
    JTextArea _ctrlRemark;
    AltaInitTableModel _ctrlInitsModel;
    AltaInitTablePanel _ctrlInitsPanel;
    JLabel _ctrlSystemPath;
    AltaEquipmentTreeModel _ctrlSystemModel;
    JTree _ctrlSystemTree;
    boolean _bEditable = true;
    AltaInitEditDlg _dlgInitEdit;
    JFileChooser _fileChooser;
    AltaSystem _system;
    String _configInitName;
    HashSet<String> _setNameTaboo = new HashSet();

    public AltaConfigEditDlg(Window owner, Plugable plugable) {
        super(owner);
        this._plugable = plugable;
        this.make();
    }

    protected AltaInitEditDlg getDlgInitEdit() {
        if (this._dlgInitEdit == null) {
            AltaInitEditDlg dlg = new AltaInitEditDlg((Window)this);
            if (this._dlgInitEdit == null) {
                this._dlgInitEdit = dlg;
            }
        }
        return this._dlgInitEdit;
    }

    protected JFileChooser getFileChooser() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            FileFilterExtention defaultFilter = new FileFilterExtention("Initial config file (*.ini,*.txt)", ".ini;.txt").verifyRead(true);
            this._fileChooser.addChoosableFileFilter(defaultFilter);
            this._fileChooser.addChoosableFileFilter(new FileFilterExtention("Generate (seqgen, fmea) XML file (*.xml)", ".xml").verifyRead(true));
            this._fileChooser.setFileFilter(defaultFilter);
            this._fileChooser.setCurrentDirectory(new File(this._plugable.getOption("plugable.option.path")));
        }
        return this._fileChooser;
    }

    protected void make() {
        this.init();
        JPanel north = new JPanel(new GridBagLayout());
        JLabel lblName = new JLabel(ResMsgVoc.getString("VOC_NAME"));
        this._ctrlName = new JTextField();
        JLabel lblRemark = new JLabel(ResMsgVoc.getString("VOC_COMMENTS"));
        this._ctrlRemark = new JTextArea(3, 25);
        JScrollPane scrollRemark = new JScrollPane(this._ctrlRemark);
        north.add((Component)lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)this._ctrlName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)lblRemark, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        north.add((Component)scrollRemark, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        north.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this._ctrlInitsModel = new AltaInitTableModel(new ArrayList<AltaInit>(), north);
        this._ctrlInitsPanel = new AltaInitTablePanel(this, this._ctrlInitsModel);
        this._ctrlInitsPanel.getTableCtrl().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = AltaConfigEditDlg.this._ctrlInitsPanel.getTableCtrl().getSelectedRow();
                if (row < 0) {
                    return;
                }
                AltaInit init = (AltaInit)AltaConfigEditDlg.this._ctrlInitsModel.getItemAt(row);
                TreePath path = AltaConfigEditDlg.this._ctrlSystemModel.constructTreePath(init.getPath());
                if (path != null) {
                    AltaConfigEditDlg.this._ctrlSystemTree.expandPath(path);
                    AltaConfigEditDlg.this._ctrlSystemTree.scrollPathToVisible(path);
                    AltaConfigEditDlg.this._ctrlSystemTree.setSelectionPath(path);
                }
            }
        });
        this._ctrlInitsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10));
        this._ctrlSystemPath = new JLabel("Project/System/Model;1");
        this._ctrlSystemPath.setIcon(ResIcoCore.getImageIcon("FOLDER_MODEL_"));
        this._ctrlSystemPath.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this._ctrlSystemModel = new AltaEquipmentTreeModel();
        this._ctrlSystemModel.setFilter(AltaEquipmentTreeModel.VisibleField.STATES);
        this._ctrlSystemTree = new JTree(this._ctrlSystemModel);
        this._ctrlSystemTree.setRootVisible(false);
        this._ctrlSystemTree.setCellRenderer(new AltaEquipmentTreeRenderer());
        this._ctrlSystemTree.getSelectionModel().setSelectionMode(1);
        this._ctrlSystemTree.setRowHeight(ResIcoAbstract.getIconSize());
        this._ctrlSystemTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!AltaConfigEditDlg.this._bEditable) {
                    return;
                }
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                AltaConfigEditDlg.this.addAltaInit();
            }
        });
        this._ctrlSystemTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AltaConfigEditDlg.this._ctrlInitsPanel.refreshCtrl();
            }
        });
        JPanel southWest = new JPanel(new BorderLayout());
        southWest.add((Component)this._ctrlSystemPath, "North");
        southWest.add((Component)new JScrollPane(this._ctrlSystemTree), "Center");
        southWest.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        JSplitPane southSplit = new JSplitPane(1, southWest, this._ctrlInitsPanel);
        JSplitPane centerSplit = new JSplitPane(0, north, southSplit);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)centerSplit, "Center");
        this.getContentPane().add((Component)this.createButPanel(), "South");
        this.setTitle(ResMsgOcas.getString("VOC_INITIAL_CONFIG"));
        this.setModal(true);
        this.pack();
        Dimension size = this.getSize();
        size.width += 120;
        this.setSize(size);
        southSplit.setDividerLocation(0.33);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    public void setConfig(AltaConfig config, List<AltaConfig> allConfigs, AltaSystem system) {
        this._system = system;
        this._setNameTaboo.clear();
        for (AltaConfig otherConfig : allConfigs) {
            if (otherConfig == config) continue;
            this._setNameTaboo.add(otherConfig.getName());
        }
        this._configInitName = config.getName();
        this._ctrlName.setText(this._configInitName);
        this._ctrlRemark.setText(config.getLabel());
        this._ctrlInitsModel.populateWith(config.getStates(), this._system);
        this._ctrlSystemPath.setText(system.getRefPath());
        JTreeUtility.Configuration treeConfig = JTreeUtility.saveConfiguration(this._ctrlSystemTree);
        this._ctrlSystemModel.setRoot(system, true);
        JTreeUtility.loadConfiguration(this._ctrlSystemTree, treeConfig);
    }

    @Override
    protected boolean verifyParameters() {
        String name = this._ctrlName.getText().trim();
        if (name.isEmpty()) {
            String title = ResMsgVoc.getString("VOC_NAME");
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgCore.msgFormat("MSG_ERR_FIELD_EMPTY", title), this.getTitle(), 0);
            this._ctrlName.requestFocus();
            return false;
        }
        if ((name = AltaConfig.verifyName(name, this._ctrlName)) == null) {
            return false;
        }
        if (this._setNameTaboo.contains(name)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._ctrlName), ResMsgOcas.getString("MSG_ERR_CONFIG_ALREADY"), this.getTitle(), 0);
            this._ctrlName.requestFocus();
            return false;
        }
        return true;
    }

    public void setEditable(boolean editable) {
        this._bEditable = editable;
        this._ctrlName.setEditable(editable);
        this._ctrlRemark.setEditable(editable);
    }

    @Override
    public String getName() {
        return this._ctrlName.getText().trim();
    }

    public String getLabel() {
        return this._ctrlRemark.getText();
    }

    public Map<String, String> getStates() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < this._ctrlInitsModel.getRowCount(); ++i) {
            AltaInit init = (AltaInit)this._ctrlInitsModel.getItemAt(i);
            result.put(init.getPath(), init.getValue());
        }
        return result;
    }

    protected void addAltaInit() {
        TreePath treepath = this._ctrlSystemTree.getSelectionPath();
        if (treepath == null) {
            return;
        }
        if (this._ctrlSystemModel.isLeaf(treepath.getLastPathComponent())) {
            String path = this._ctrlSystemModel.constructPath(treepath);
            AltaInit addInit = null;
            ObjectWithName obj = this._system.findFieldFromPath(path);
            AltaType type = null;
            String value = "";
            if (obj == null || !(obj instanceof AltaState)) {
                return;
            }
            type = ((AltaState)obj).getType();
            value = type.getDefaultValue();
            addInit = new AltaInit(path, type, value);
            int idxInsert = -1;
            for (int i = 0; idxInsert < 0 && i < this._ctrlInitsModel.getRowCount(); ++i) {
                AltaInit init = (AltaInit)this._ctrlInitsModel.getItemAt(i);
                int cmp = path.compareTo(init.getPath());
                if (cmp == 0) {
                    this._ctrlInitsPanel.getTableCtrl().getSelectionModel().setSelectionInterval(i, i);
                    return;
                }
                if (cmp >= 0) continue;
                idxInsert = i;
            }
            AltaInitEditDlg dlg = this.getDlgInitEdit();
            dlg.setInit(path, addInit.getType(), addInit.getValue());
            dlg.setVisible(true);
            if (dlg.getResult()) {
                addInit.setValue(dlg.getValue());
                if (idxInsert < 0) {
                    this._ctrlInitsModel.addData(addInit);
                    idxInsert = this._ctrlInitsModel.getRowCount() - 1;
                } else {
                    this._ctrlInitsModel.insertData(addInit, idxInsert);
                }
                this._ctrlInitsPanel.getTableCtrl().getSelectionModel().setSelectionInterval(idxInsert, idxInsert);
            }
        }
    }

    class AltaInitTableModel
    extends ArrayTableModel<AltaInit> {
        JComponent _owner;

        public AltaInitTableModel(ArrayList<AltaInit> array, JComponent owner) {
            super(array);
            this._owner = owner;
        }

        public void populateWith(Map<String, String> configs, AltaEquipment owner) {
            this.getData().clear();
            TreeMap<String, String> states = new TreeMap<String, String>(configs);
            for (Map.Entry entry : states.entrySet()) {
                String path = (String)entry.getKey();
                AltaType type = null;
                ObjectWithName obj = owner.findFieldFromPath((String)entry.getKey());
                if (obj != null && obj instanceof AltaState) {
                    type = ((AltaState)obj).getType();
                }
                this.getData().add(new AltaInit(path, type, (String)entry.getValue()));
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResMsgVoc.getString("VOC_STATE");
                }
                case 1: {
                    return ResMsgVoc.getString("VOC_TYPE");
                }
                case 2: {
                    return ResMsgVoc.getString("VOC_VALUE");
                }
            }
            return "Error";
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (!AltaConfigEditDlg.this._bEditable) {
                return false;
            }
            if (column != 2) {
                return false;
            }
            AltaInit init = (AltaInit)this.getItemAt(row);
            return init.getType() != null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            AltaInit init = (AltaInit)this.getItemAt(row);
            switch (column) {
                case 0: {
                    return init.getPath();
                }
                case 1: {
                    AltaType type = init.getType();
                    if (type == null) {
                        return "";
                    }
                    return type.toLabel();
                }
                case 2: {
                    return init.getValue();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            AltaInit init = (AltaInit)this.getItemAt(row);
            switch (column) {
                case 0: {
                    if (!(aValue instanceof String)) break;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (!(aValue instanceof String) || init.getType() == null) break;
                    String val = (String)aValue;
                    if (init.getType().valueExist(val)) {
                        boolean oldError = init.withError();
                        init.setValue(val);
                        if (!oldError) break;
                        this.fireTableCellUpdated(row, 0);
                        break;
                    }
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._owner), ResMsgOcas.msgFormat("MSG_ERR_CONFIG_VALUE", init.getPath()), ResMsgOcas.getString("VOC_INITIAL_CONFIG"), 0);
                }
            }
        }
    }

    class AltaInitTablePanel
    extends TablePanel {
        private JTable _ctrlInitTable;
        protected JComboBox _ctrlEditorValue;

        public AltaInitTablePanel(Window window, AltaInitTableModel model) {
            super(window, model, true, true);
        }

        @Override
        protected AltaInitTableModel getTableModel() {
            return (AltaInitTableModel)super.getTableModel();
        }

        public JTable getTableCtrl() {
            return this._ctrlInitTable;
        }

        @Override
        protected JPopupMenu createMenuActions(JPopupMenu popupList) {
            popupList.add(this._ctrlAdd);
            popupList.add(this._ctrlDel);
            return popupList;
        }

        @Override
        protected void createToolBarActions(Container toolbar) {
            toolbar.add(Box.createGlue());
            toolbar.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
            toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
            toolbar.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        }

        @Override
        protected JTable createCtrlCollection() {
            this._ctrlInitTable = super.createCtrlCollection();
            TableColumn column = null;
            block5: for (int i = 0; i < this.getTableModel().getColumnCount(); ++i) {
                column = this._ctrlInitTable.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        column.setPreferredWidth(200);
                        continue block5;
                    }
                    case 1: {
                        column.setPreferredWidth(75);
                        continue block5;
                    }
                    case 2: {
                        column.setPreferredWidth(75);
                    }
                }
            }
            this._ctrlInitTable.setRowHeight(20);
            this._ctrlInitTable.getSelectionModel().setSelectionMode(2);
            this._ctrlInitTable.getColumnModel().getColumn(0).setCellRenderer(new WithErrorTableCellRenderer(){

                @Override
                public boolean withError(JTable table, Object value, int row, int column) {
                    AltaInit init = (AltaInit)AltaInitTablePanel.this.getTableModel().getItemAt(row);
                    return init.withError();
                }
            });
            this._ctrlEditorValue = new JComboBox();
            this._ctrlInitTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this._ctrlEditorValue){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    AltaInitTablePanel.this._ctrlEditorValue.removeAllItems();
                    AltaType type = ((AltaInit)AltaInitTablePanel.this.getTableModel().getItemAt(row)).getType();
                    if (type == null) {
                        AltaInitTablePanel.this._ctrlEditorValue.setEditable(true);
                    } else {
                        int len = type.getValueCount();
                        AltaInitTablePanel.this._ctrlEditorValue.setEditable(len > 0);
                        for (int i = 0; i < len; ++i) {
                            AltaInitTablePanel.this._ctrlEditorValue.addItem(type.getValueAt(i));
                        }
                    }
                    return super.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
            });
            return this._ctrlInitTable;
        }

        @Override
        protected void refreshCtrl() {
            if (!this.isEnabled() || !AltaConfigEditDlg.this._bEditable) {
                this._ctrlDel.setEnabled(false);
            } else {
                TreePath treepath;
                AltaInitTableModel model = this.getTableModel();
                int nbrSelect = this.getSelectedRowCount();
                this._ctrlDel.setEnabled(nbrSelect > 0);
                boolean addEnable = false;
                if (AltaConfigEditDlg.this._ctrlSystemTree != null && AltaConfigEditDlg.this._ctrlSystemModel != null && (treepath = AltaConfigEditDlg.this._ctrlSystemTree.getSelectionPath()) != null && AltaConfigEditDlg.this._ctrlSystemModel.isLeaf(treepath.getLastPathComponent())) {
                    String path = AltaConfigEditDlg.this._ctrlSystemModel.constructPath(treepath);
                    boolean find = false;
                    for (int i = 0; !find && i < model.getRowCount(); ++i) {
                        if (!((AltaInit)model.getItemAt(i)).getPath().equals(path)) continue;
                        find = true;
                    }
                    addEnable = !find;
                }
                this._ctrlAdd.setEnabled(addEnable);
            }
        }

        @Override
        protected void addData(int idx) {
            AltaConfigEditDlg.this.addAltaInit();
        }

        @Override
        protected void delData(int[] viewRows) {
            int i;
            AltaInitTableModel model = this.getTableModel();
            ArrayList<AltaInit> delSheets = new ArrayList<AltaInit>(viewRows.length);
            for (i = 0; i < viewRows.length; ++i) {
                int modelRow = viewRows[i];
                AltaInit init = (AltaInit)model.getItemAt(modelRow);
                delSheets.add(init);
            }
            for (i = delSheets.size() - 1; i >= 0; --i) {
                model.removeData((AltaInit)delSheets.get(i));
            }
        }
    }
}

