/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.lib.util.io.FileUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AltaConfigSelectDlg
extends JDialogCecilia {
    List<AltaConfig> _configs;
    private boolean _onlyFile = false;
    private Plugable _plugable;
    JRadioButton _ctrlChoiceDefined;
    JRadioButton _ctrlChoiceLoaded;
    JList _ctrlSelectConfig;
    JTextField _ctrlSelectFile;
    JButton _ctrlFindFile;
    JFileChooser _fileChooser;
    private static final String OPT_SELECT = AltaConfigSelectDlg.class.getName() + "#Select";
    private static final String OPT_SELECT_COMPIL = AltaConfigSelectDlg.class.getName() + "#SelectCompil";
    private static final String OPT_CONFIG = AltaConfigSelectDlg.class.getName() + "#Config";
    private static final String OPT_FILE = AltaConfigSelectDlg.class.getName() + "#File";
    private static final String OPT_FILE_COMPIL = AltaConfigSelectDlg.class.getName() + "#FileCompil";

    public AltaConfigSelectDlg(Window owner, Plugable plugable) {
        super(owner);
        this.make(plugable, false);
    }

    public AltaConfigSelectDlg(Window owner, Plugable plugable, boolean onlyFile) {
        super(owner);
        this.make(plugable, onlyFile);
    }

    protected JFileChooser getFileChooser() {
        File currentFile;
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            FileFilterExtention defaultFilter = new FileFilterExtention("Initial config file (*.ini,*.txt)", ".ini;.txt").verifyRead(true);
            this._fileChooser.addChoosableFileFilter(defaultFilter);
            this._fileChooser.addChoosableFileFilter(new FileFilterExtention("Generate (seqgen, fmea) XML file (*.xml)", ".xml").verifyRead(true));
            this._fileChooser.setFileFilter(defaultFilter);
        }
        boolean define = false;
        String currentPath = this._ctrlSelectFile.getText();
        if (currentPath.length() != 0 && (currentFile = new File(currentPath).getParentFile()).isDirectory()) {
            define = true;
            this._fileChooser.setCurrentDirectory(currentFile);
        }
        if (!define) {
            this._fileChooser.setCurrentDirectory(new File(this._plugable.getOption("plugable.option.path")));
        }
        return this._fileChooser;
    }

    protected void make(Plugable plugable, boolean onlyFile) {
        this.init();
        this._plugable = plugable;
        this._onlyFile = onlyFile;
        JPanel root = new JPanel(new GridBagLayout());
        int line = 0;
        ButtonGroup group = new ButtonGroup();
        this._ctrlChoiceDefined = new JRadioButton(ResMsgOcas.getString("SIMUL_INIT_FROM_CONFIG"));
        group.add(this._ctrlChoiceDefined);
        if (this._onlyFile) {
            root.add((Component)this._ctrlChoiceDefined, new GridBagConstraints(0, line++, 2, 1, 100.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        } else {
            this._ctrlSelectConfig = new JList();
            this._ctrlSelectConfig.setEnabled(false);
            this._ctrlSelectConfig.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    if (!AltaConfigSelectDlg.this._ctrlChoiceDefined.isSelected()) {
                        return;
                    }
                    AltaConfigSelectDlg.this.valid();
                }
            });
            this._ctrlChoiceDefined.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AltaConfigSelectDlg.this._ctrlSelectConfig.setEnabled(AltaConfigSelectDlg.this._ctrlChoiceDefined.isSelected());
                }
            });
            JPanel panel = new JPanel(new ToggleBorderLayout());
            ToggleBorderLayout.configure(panel, this._ctrlChoiceDefined, new JScrollPane(this._ctrlSelectConfig));
            root.add((Component)panel, new GridBagConstraints(0, line++, 2, 1, 100.0, 100.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        JPanel loaded = this.createLoadedPanel();
        this._ctrlChoiceLoaded = new JRadioButton(ResMsgOcas.getString("SIMUL_INIT_FROM_FILE"));
        this._ctrlChoiceLoaded.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AltaConfigSelectDlg.this._ctrlSelectFile.setEnabled(AltaConfigSelectDlg.this._ctrlChoiceLoaded.isSelected());
                AltaConfigSelectDlg.this._ctrlFindFile.setEnabled(AltaConfigSelectDlg.this._ctrlChoiceLoaded.isSelected());
            }
        });
        group.add(this._ctrlChoiceLoaded);
        JPanel panel = new JPanel(new ToggleBorderLayout());
        ToggleBorderLayout.configure(panel, this._ctrlChoiceLoaded, loaded);
        root.add((Component)panel, new GridBagConstraints(0, line++, 2, 1, 100.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        JPanel buts = new JPanel(new GridLayout(1, 2));
        buts.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        AbstractAction okAct = new AbstractAction(ResMsgVoc.getString("VOC_VALIDATE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaConfigSelectDlg.this.valid();
            }
        };
        this._ctrlOK = new JButton(okAct);
        buts.add(this._ctrlOK);
        this.putAction("CECILIA_ENTER", okAct);
        AbstractAction escAct = new AbstractAction(ResMsgVoc.getString("VOC_CANCEL")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaConfigSelectDlg.this.setVisible(false);
            }
        };
        buts.add(new JButton(escAct));
        this.putAction("CECILIA_CANCEL", escAct);
        JPanel panel2 = new JPanel();
        panel2.add(buts);
        root.add((Component)panel2, new GridBagConstraints(0, line++, 2, 1, 100.0, 0.0, 10, 3, new Insets(0, 10, 0, 10), 0, 0));
        this._ctrlChoiceDefined.setSelected(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(root);
        this.setTitle(ResMsgOcas.getString("KEY_1158"));
        this.setModal(true);
        this.pack();
        Dimension size = this.getSize();
        size.height += 20;
        this.setSize(size);
        this.setResizable(false);
        this.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
    }

    private JPanel createLoadedPanel() {
        JPanel loaded = new JPanel(new BorderLayout());
        this._ctrlSelectFile = new JTextField(20);
        this._ctrlSelectFile.setEnabled(false);
        loaded.add((Component)this._ctrlSelectFile, "Center");
        this._ctrlFindFile = new JButton("...");
        this._ctrlFindFile.setEnabled(false);
        this._ctrlFindFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = AltaConfigSelectDlg.this.getFileChooser();
                if (fc.showOpenDialog(AltaConfigSelectDlg.this._ctrlSelectFile) == 0) {
                    File f = fc.getSelectedFile();
                    AltaConfigSelectDlg.this._ctrlSelectFile.setText(f.getPath());
                }
            }
        });
        loaded.add((Component)this._ctrlFindFile, "East");
        return loaded;
    }

    protected boolean testValid() {
        if (this._ctrlChoiceDefined.isSelected()) {
            if (this._onlyFile) {
                return true;
            }
            return this._ctrlSelectConfig.getSelectedValue() != null;
        }
        String file = this._ctrlSelectFile.getText();
        return FileUtility.verifyPath((String)file, (boolean)false, (Component)this._ctrlSelectFile, (String)ResMsgOcas.getString("KEY_1158"));
    }

    protected void valid() {
        if (this.testValid()) {
            this._result = true;
            this.setVisible(false);
        }
    }

    public boolean display(List<AltaConfig> configs) {
        this._result = false;
        String strSelect = this._plugable.getOption(this._onlyFile ? OPT_SELECT_COMPIL : OPT_SELECT);
        boolean select = true;
        if (strSelect != null && strSelect.length() > 0) {
            select = strSelect.equalsIgnoreCase("true");
        }
        if (select) {
            this._ctrlChoiceDefined.setSelected(true);
        } else {
            this._ctrlChoiceLoaded.setSelected(true);
        }
        if (!this._onlyFile && configs != null) {
            String strConfig = this._plugable.getOption(OPT_CONFIG);
            this._configs = new ArrayList<AltaConfig>(configs);
            this._ctrlSelectConfig.setModel(new AbstractListModel(){

                @Override
                public int getSize() {
                    return AltaConfigSelectDlg.this._configs.size();
                }

                @Override
                public Object getElementAt(int i) {
                    return AltaConfigSelectDlg.this._configs.get(i);
                }
            });
            this._ctrlSelectConfig.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof AltaConfig) {
                        this.setText(((AltaConfig)value).getName());
                        this.setToolTipText(((AltaConfig)value).getLabel());
                    }
                    return this;
                }
            });
            int idx = -1;
            for (int i = 0; i < configs.size() && idx == -1; ++i) {
                if (!configs.get(i).getName().equals(strConfig)) continue;
                idx = i;
            }
            if (idx == -1 && configs.size() == 1) {
                idx = 0;
            }
            if (idx != -1) {
                this._ctrlSelectConfig.setSelectedIndex(idx);
                this._ctrlSelectConfig.scrollRectToVisible(this._ctrlSelectConfig.getCellBounds(idx, idx));
            }
        }
        String strFile = this._plugable.getOption(this._onlyFile ? OPT_FILE_COMPIL : OPT_FILE);
        this._ctrlSelectFile.setText(strFile);
        this._ctrlOK.requestFocus();
        this.setVisible(true);
        this._plugable.setOption(this._onlyFile ? OPT_FILE_COMPIL : OPT_FILE, this._ctrlSelectFile.getText());
        if (!this._onlyFile) {
            AltaConfig opt = (AltaConfig)this._ctrlSelectConfig.getSelectedValue();
            this._plugable.setOption(OPT_CONFIG, opt == null ? "" : opt.getName());
        }
        this._plugable.setOption(this._onlyFile ? OPT_SELECT_COMPIL : OPT_SELECT, Boolean.toString(this._ctrlChoiceDefined.isSelected()));
        return this._result;
    }

    public AltaConfig getSelectedConfiguration() {
        if (!this._ctrlChoiceDefined.isSelected()) {
            return null;
        }
        if (this._onlyFile) {
            return null;
        }
        return (AltaConfig)this._ctrlSelectConfig.getSelectedValue();
    }

    public File getLoadedConfiguration() {
        if (!this._ctrlChoiceLoaded.isSelected()) {
            return null;
        }
        return new File(this._ctrlSelectFile.getText());
    }
}

