/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.ObjectWithName;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEventPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaEquipmentTreeModel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaEquipmentTreeRenderer;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaModifiedEventPanel;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AltaModifiedEventTreePanel
extends JPanel {
    private CeciliaAppl _appl;
    private AltaModifiedEventPanel _modifiedEventPanel;
    private AltaEquipmentTreeModel _treeModel;
    private JTree _tree;
    private CeciliaAction _addAction;
    private CeciliaAction _editAction;
    private CeciliaAction _deleteAction;
    private CeciliaAction _extendAction;
    private Map<Object, Object> _bidirectionalMap;

    public AltaModifiedEventTreePanel(CeciliaAppl appl, AltaModifiedEventPanel modifiedEventPanel) {
        super(new GridBagLayout());
        this._modifiedEventPanel = modifiedEventPanel;
        this._appl = appl;
        this._bidirectionalMap = new HashMap<Object, Object>();
        this.defineActions();
        this.doCreate();
    }

    private void doCreate() {
        this._treeModel = new AltaEquipmentTreeModel();
        this._treeModel.setFilter(AltaEquipmentTreeModel.VisibleField.EVENTS);
        this._treeModel.setOnlySub(true);
        this._treeModel.setWithoutEmptySub(true);
        this._tree = new JTree(this._treeModel){

            @Override
            public void expandPath(TreePath path) {
                super.expandPath(path);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                for (int i = 0; i < node.getChildCount(); ++i) {
                    TreeNode child = node.getChildAt(i);
                    TreePath childPath = new TreePath(AltaModifiedEventTreePanel.this._treeModel.getPathToRoot(child));
                    if (!AltaModifiedEventTreePanel.this.containsEventOnMap(childPath)) continue;
                    AltaModifiedEventTreePanel.this._treeModel.nodeChanged(child);
                }
            }
        };
        this._tree.setRootVisible(false);
        this._tree.setCellRenderer(new AltaModifiedEventsTreeRenderer());
        this._tree.getSelectionModel().setSelectionMode(4);
        this._tree.setRowHeight(ResIcoAbstract.getIconSize());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this._addAction);
        popupMenu.add(this._editAction);
        popupMenu.add(this._deleteAction);
        popupMenu.addSeparator();
        popupMenu.add(this._extendAction);
        this._tree.setComponentPopupMenu(popupMenu);
        this._tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    AltaModifiedEventTreePanel.this.addAltaEvent();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    TreePath tp = AltaModifiedEventTreePanel.this._tree.getPathForLocation(e.getX(), e.getY());
                    AltaModifiedEventTreePanel.this._tree.addSelectionPath(tp);
                }
                AltaModifiedEventTreePanel.this.updateActions();
            }
        });
        this._tree.addTreeSelectionListener(e -> {
            TreePath[] paths = this._tree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            if (this._modifiedEventPanel.isBlocking()) {
                return;
            }
            try {
                this._modifiedEventPanel.setBlocking(true);
                ArrayList<AltaEvent> events = new ArrayList<AltaEvent>();
                for (TreePath path : paths) {
                    Object obj = this._bidirectionalMap.get(path);
                    if (!(obj instanceof AltaEvent)) continue;
                    events.add((AltaEvent)obj);
                }
                if (paths.length > 0) {
                    TreePath lastPath = paths[paths.length - 1];
                    this._modifiedEventPanel.getCtrlEventName().setText(this._treeModel.constructPath(lastPath));
                }
                AltaEventPanel.EventTable table = this._modifiedEventPanel.getTable();
                AltaEventPanel.EventTableModel tableModel = (AltaEventPanel.EventTableModel)table.getModel();
                table.getSelectionModel().clearSelection();
                Rectangle rectToVisible = null;
                for (int idxModel = 0; idxModel < tableModel.getRowCount(); ++idxModel) {
                    AltaEvent eventTable = tableModel.getAltaEvent(idxModel);
                    if (!events.contains(eventTable)) continue;
                    int idxTable = table.convertRowIndexToView(idxModel);
                    table.getSelectionModel().addSelectionInterval(idxTable, idxTable);
                    if (rectToVisible != null) continue;
                    rectToVisible = table.getCellRect(idxTable, 1, true);
                }
                if (rectToVisible != null) {
                    table.scrollRectToVisible(rectToVisible);
                }
            }
            finally {
                this._modifiedEventPanel.setBlocking(false);
            }
        });
        this.add((Component)new JScrollPane(this._tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void defineActions() {
        this._addAction = new CeciliaAction(ResIcoCore.getImageIcon("BUT_ADD"), ResMsgVoc.getString("VOC_ADD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaModifiedEventTreePanel.this.addAltaEvent();
            }
        };
        this._editAction = new CeciliaAction(ResIcoCore.getImageIcon("BUT_EDIT"), ResMsgVoc.getString("VOC_EDIT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaModifiedEventTreePanel.this._modifiedEventPanel.doEditEvents();
            }
        };
        this._deleteAction = new CeciliaAction(ResIcoCore.getImageIcon("BUT_DEL"), ResMsgVoc.getString("VOC_DELETE")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AltaModifiedEventTreePanel.this._modifiedEventPanel.deleteEvents();
            }
        };
        this._extendAction = new CeciliaAction(null, ResMsgObj.getString("ACTION_EXPAND_MENU")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] paths;
                for (TreePath path : paths = AltaModifiedEventTreePanel.this._tree.getSelectionPaths()) {
                    AltaModifiedEventTreePanel.this._tree.expandPath(path);
                    AltaModifiedEventTreePanel.this.expandNode((DefaultMutableTreeNode)path.getLastPathComponent());
                }
            }
        };
    }

    private void updateActions() {
        TreePath[] paths = this._tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        boolean withAdd = false;
        boolean withEdit = false;
        boolean withDel = false;
        boolean withExtend = false;
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            boolean isInMap = this._bidirectionalMap.containsKey(path);
            boolean isLeaf = node.isLeaf();
            withAdd |= !isInMap && isLeaf;
            withDel |= isInMap;
            withEdit |= isInMap;
            withExtend |= !isLeaf;
        }
        this._addAction.setEnabled(withAdd && !this._appl.isReader());
        this._deleteAction.setEnabled(withDel && !this._appl.isReader());
        this._editAction.setEnabled(withEdit);
        this._extendAction.setEnabled(withExtend);
    }

    private AltaSystem getAltaComponent() {
        return this._modifiedEventPanel != null ? this._modifiedEventPanel.getAltaComponent() : null;
    }

    public void setComponent(AltaComponent currentComponent) {
        this._bidirectionalMap.clear();
        if (currentComponent == null) {
            return;
        }
        this._treeModel.setRoot((AltaSystem)currentComponent, true);
        this._treeModel.reload();
        for (AltaEvent evt : ((AltaSystem)currentComponent).getEvents()) {
            this.addEventOnMap(evt, evt.getName());
        }
        if (this._modifiedEventPanel != null) {
            this._modifiedEventPanel.refreshSelectedEvents();
        }
    }

    public void updateTree(List<AltaEvent> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        TreePath[] paths = new TreePath[events.size()];
        for (int i = 0; i < events.size(); ++i) {
            Object obj = this._bidirectionalMap.get(events.get(i));
            if (!(obj instanceof TreePath)) continue;
            paths[i] = (TreePath)obj;
        }
        this._tree.setSelectionPaths(paths);
        this._tree.scrollPathToVisible(paths[0]);
    }

    public void addEventOnMap(AltaEvent event, String namePath) {
        TreePath path = this._treeModel.constructTreePath(namePath);
        if (path != null) {
            this.addEventOnMap(event, path);
        }
    }

    private void addEventOnMap(AltaEvent event, TreePath treePath) {
        this._bidirectionalMap.put(event, treePath);
        this._bidirectionalMap.put(treePath, event);
        this._treeModel.nodeChanged((TreeNode)treePath.getLastPathComponent());
    }

    public void deleteEventOnMap(AltaEvent event) {
        TreePath path = (TreePath)this._bidirectionalMap.remove(event);
        if (path != null) {
            this._bidirectionalMap.remove(path);
            this._treeModel.nodeChanged((TreeNode)path.getLastPathComponent());
        }
    }

    public boolean containsEventOnMap(TreePath path) {
        return this._bidirectionalMap.containsKey(path);
    }

    private void addAltaEvent() {
        AltaSystem system = this.getAltaComponent();
        TreePath[] paths = this._tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        int lastEvent = system.getEvents().size();
        LinkedHashMap<TreePath, AltaEvent> pathsToEvents = new LinkedHashMap<TreePath, AltaEvent>();
        for (TreePath path : paths) {
            AltaEvent event;
            if (this._bidirectionalMap.containsKey(path) || (event = this.getAltaEvent(path)) == null) continue;
            event = event.getCopy();
            for (int i = 0; i < system.getEvents().size(); ++i) {
                AltaEvent existingEvent = system.getEvents().get(i);
                TreePath existingTreePath = (TreePath)this._bidirectionalMap.get(existingEvent);
                if (existingTreePath == null || !existingTreePath.equals(path) || paths.length != 1) continue;
                AltaEventPanel.EventTable table = this._modifiedEventPanel.getTable();
                table.getSelectionModel().setSelectionInterval(i, i);
                this._modifiedEventPanel.doEditEvents();
                return;
            }
            event.setName(this._treeModel.constructPath(path));
            pathsToEvents.put(path, event);
        }
        if (pathsToEvents.isEmpty()) {
            return;
        }
        if (!this._modifiedEventPanel.displayDlgEventsEdit(pathsToEvents.values(), this._appl)) {
            return;
        }
        for (Map.Entry entry : pathsToEvents.entrySet()) {
            system.getEvents().add((AltaEvent)entry.getValue());
            this.addEventOnMap((AltaEvent)entry.getValue(), (TreePath)entry.getKey());
        }
        int newLastEvent = system.getEvents().size() - 1;
        this._modifiedEventPanel.refreshTable();
        ListSelectionModel listSelectionModel = this._modifiedEventPanel.getTable().getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        listSelectionModel.clearSelection();
        for (int i = lastEvent; i <= newLastEvent; ++i) {
            int rowView = this._modifiedEventPanel.getTable().convertRowIndexToView(i);
            listSelectionModel.addSelectionInterval(rowView, rowView);
        }
        listSelectionModel.setValueIsAdjusting(false);
        system.setModified(true);
        system.updateDependTimeUpdt(this._appl.getDAOFactory(), this.getAltaComponent().getWorkingRelations());
    }

    private AltaEvent getAltaEvent(TreePath treepath) {
        AltaSystem system = this.getAltaComponent();
        if (system == null) {
            return null;
        }
        if (treepath == null) {
            return null;
        }
        if (!this._treeModel.isLeaf(treepath.getLastPathComponent())) {
            return null;
        }
        String path = this._treeModel.constructPath(treepath);
        ObjectWithName obj = system.findFieldFromPath(path);
        if (!(obj instanceof AltaEvent)) {
            return null;
        }
        return obj instanceof AltaEvent ? (AltaEvent)obj : null;
    }

    private void expandNode(DefaultMutableTreeNode node) {
        Object[] objs = this._treeModel.getPathToRoot(node);
        TreePath path = new TreePath(objs);
        this._tree.expandPath(path);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.expandNode((DefaultMutableTreeNode)node.getChildAt(i));
        }
    }

    private class AltaModifiedEventsTreeRenderer
    extends AltaEquipmentTreeRenderer {
        Font _defaultFont;
        Font _boldFont;

        private AltaModifiedEventsTreeRenderer() {
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this._defaultFont = UIManager.getFont("Label.font");
            this._boldFont = new Font(this._defaultFont.getName(), 1, this._defaultFont.getSize());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            TreePath path;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object obj = node.getUserObject();
            this.setFont(this._defaultFont);
            if (!(obj instanceof AltaEvent) && !(obj instanceof AltaSynchro)) {
                return this;
            }
            TreeModel model = tree.getModel();
            if (model instanceof AltaEquipmentTreeModel && AltaModifiedEventTreePanel.this.containsEventOnMap(path = tree.getPathForRow(row))) {
                this.setFont(this._boldFont);
            }
            return this;
        }
    }
}

