/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.error.GeneralDlgDisplayError;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.dbobj.folder.DBFolderThreadClose;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.AltaInfoStepper;
import com.dassault.cecilia.dbobj.mbsa.GenerateAltaricaCode;
import com.dassault.cecilia.dbobj.mbsa.ResIcoOcas;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.UtilOcas;
import com.dassault.cecilia.dbobj.mbsa.component.AltaComponent;
import com.dassault.cecilia.dbobj.mbsa.component.gui.AltaEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaEquipment;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSub;
import com.dassault.cecilia.dbobj.mbsa.equipment.AltaSynchro;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaContentEditPanel;
import com.dassault.cecilia.dbobj.mbsa.equipment.gui.AltaSynchroPanel;
import com.dassault.cecilia.dbobj.mbsa.export.XPortCfgSystem;
import com.dassault.cecilia.dbobj.mbsa.node.AltaEvent;
import com.dassault.cecilia.dbobj.mbsa.node.AltaFlow;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.node.AltaState;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaCodeFrame;
import com.dassault.cecilia.dbobj.mbsa.node.gui.AltaPropertiesPanel;
import com.dassault.cecilia.dbobj.mbsa.node.gui.EditorInterface;
import com.dassault.cecilia.dbobj.mbsa.node.gui.HelperLabel;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.AltaSystem;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaColorPanel;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaConfigPanel;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaConfigSelectDlg;
import com.dassault.cecilia.dbobj.mbsa.system.gui.AltaModifiedEventPanel;
import com.dassault.cecilia.dbobj.mbsa.system.io.config.ConfigIOUtility;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlg;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapSaveAsDlgWithVirtual;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.CeciliaGUI;
import com.dassault.cecilia.main.cecilia.actions.search.SearchAction;
import com.dassault.cecilia.main.cecilia.actions.search.SearchDlg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class AltaSystemFrame
extends AltaCodeFrame
implements EditorInterface {
    private static Logger _LOG = Logger.getLogger(AltaSystemFrame.class.getPackage().getName());
    private static final int IDX_CONT = 0;
    private static final int IDX_SYNC = 1;
    private static final int IDX_CODE = 2;
    private static final int IDX_INIT = 3;
    private static final int IDX_EVTS = 4;
    private static final int IDX_COLS = 5;
    private static final int IDX_PROP = 6;
    Component _oldTabSelected = null;
    AltaSynchroPanel _syncPanel;
    AltaContentEditPanel _contentPanel;
    AltaConfigPanel _configPanel;
    AltaModifiedEventPanel _eventPanel;
    AltaColorPanel _colorPanel;
    AltaPropertiesPanel _propertiesPanel;
    private CeciliaGUI _gui;
    Map<String, AltaInfoStepper> _altaInfoStepper = new LinkedHashMap<String, AltaInfoStepper>();

    public AltaSystemFrame(CeciliaAppl appl, AltaSystem dbSystem) {
        super(dbSystem.getCopy(), appl);
        this._gui = appl.getTopWindow();
        this.makePanel();
        this.editSystem(this.getAltaNode());
        this.setModified(false);
    }

    @Override
    protected AltaSystem getAltaNode() {
        return (AltaSystem)super.getAltaNode();
    }

    public AltaContentEditPanel getEditPanel() {
        return this._contentPanel;
    }

    public void focusTreatment() {
        this.requestFocus();
        if (this._tabPane != null) {
            switch (this._tabPane.getSelectedIndex()) {
                case 0: {
                    break;
                }
                case 1: {
                    this._syncPanel.requestFocus();
                    break;
                }
                case 2: {
                    this._codeEditor.getEditorComponent().requestFocus();
                    break;
                }
                case 3: {
                    this._configPanel.focusTreatment();
                    break;
                }
                case 4: {
                    this._eventPanel.focusTreatment();
                    break;
                }
                case 5: {
                    this._colorPanel.focusTreatment();
                    break;
                }
                case 6: {
                    this._propertiesPanel.requestFocus();
                }
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.focusTreatment();
    }

    private void makePanel() {
        this._contentPanel = new AltaContentEditPanel(this.getApplication());
        this._contentPanel.make();
        this._tabPane.addTab(ResMsgVoc.getString("VOC_CONTENT"), this._contentPanel);
        this._syncPanel = new AltaSynchroPanel(this.getApplication());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_SYNCS"), ResIcoCore.getImageIcon("MBSA_SYNC"), this._syncPanel);
        this._tabPane.addTab(ResMsgOcas.getString("MODEL_EDIT_ALTARICA_CODE"), ResIcoOcas.getImageIcon("CODE_PI"), this.createAltaEditor());
        this._configPanel = new AltaConfigPanel(this.getApplication());
        this._tabPane.addTab(ResMsgOcas.getString("VOC_INITIAL_CONFIGS"), this._configPanel);
        this._eventPanel = new AltaModifiedEventPanel(this.getApplication());
        this._tabPane.addTab(ResMsgOcas.getString("VOC_MODIFIED_EVENTS"), ResIcoCore.getImageIcon("MBSA_EVENT"), this._eventPanel);
        this._colorPanel = new AltaColorPanel(this.getApplication());
        this._tabPane.addTab(ResMsgOcas.getString("MENU_LINK_COLORS"), ResIcoCore.getImageIcon("PALETTE"), this._colorPanel);
        this._propertiesPanel = new AltaPropertiesPanel(this.getDBFolder());
        this._propertiesPanel.setEditable(!this.getApplication().isReader());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_PROPERTIES"), this._propertiesPanel);
        JPanel content = new JPanel(new BorderLayout());
        this.getContentPane().add(content);
        this._tabPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        content.add((Component)this._tabPane, "Center");
        content.add(this.createAndPlugLogsButtonAt(this.createCodeAndClosePanel()), "South");
        this.defineActions();
        this.setSize(950, 600);
    }

    @Override
    protected int getTabIndex(AltaCodeFrame.CodeTabType tabType) {
        switch (tabType) {
            case CONTENT: {
                return 0;
            }
            case SYNC: {
                return 1;
            }
            case CODE: {
                return 2;
            }
            case INIT: {
                return 3;
            }
            case EVENT: {
                return 4;
            }
            case COLOR: {
                return 5;
            }
            case GENERAL: {
                return 6;
            }
        }
        return -1;
    }

    @Override
    public void changePreferencies(Preferencies prefs) {
        super.changePreferencies(prefs);
        this._contentPanel.changePreferencies(prefs);
        this._syncPanel.changePreferencies(prefs);
        PluginWithOptions opts = prefs.getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            this._propertiesPanel.setDateFormat(((GeneralTextPreferencies)opts).getDateFormat());
        }
    }

    @Override
    public String getHelpRoots(Vector list) {
        AltaSystem model = this.getAltaNode();
        for (AltaSynchro sync : model.getSynchros()) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(sync.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_SYNC"), ""));
        }
        for (AltaSub sub : model.getSubs()) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(sub.getName(), (Icon)(sub.getNode() instanceof AltaEquipment ? ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_") : ResIcoCore.getImageIcon("FOLDER_COMPONENT_")), ""));
        }
        for (AltaEvent event : model.getEvents()) {
            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(event.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_EVENT"), ""));
        }
        return model.getDBFolder().getRefPath();
    }

    @Override
    public String analyseString(String str, char car, Vector list) {
        String resultString = "";
        switch (car) {
            case '^': {
                AltaFlow flow;
                String[] componentsSplited = str.split("\\.");
                AltaComponent component = this.getAltaNode();
                if (componentsSplited.length > 1) {
                    for (int i = 0; i < componentsSplited.length - 1; ++i) {
                        if (!(component instanceof AltaEquipment) || ((AltaEquipment)component).getSub(componentsSplited[i]) == null) {
                            return null;
                        }
                        component = ((AltaEquipment)component).getSub(componentsSplited[i]).getNode();
                    }
                }
                if ((flow = component.getFlow(componentsSplited[componentsSplited.length - 1])) == null || !(flow.getType() instanceof DBRecord)) break;
                DBRecord dbRecord = (DBRecord)flow.getType();
                for (int i = dbRecord.getValueCount() - 1; i >= 0; --i) {
                    DBRecordField field = dbRecord.getFieldAt(i);
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(field.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FIELD"), field.getType()));
                }
                resultString = ((DBType)flow.getType()).getDBFolder().getRefPath();
                break;
            }
            case '.': {
                String[] componentsSplited = str.split("\\.");
                AltaNode model = null;
                for (String component : componentsSplited) {
                    if (model == null) {
                        model = this.getAltaNode();
                    }
                    if (!(model instanceof AltaEquipment) || ((AltaEquipment)model).getSub(component) == null) {
                        return null;
                    }
                    model = ((AltaEquipment)model).getSub(component).getNode();
                }
                if (model == null) break;
                if (model instanceof AltaComponent) {
                    for (AltaFlow port : model.getFlows()) {
                        if (port.getOrientation() == AltaFlow.Orientation.IN) {
                            UtilOcas.addInAlphabeticOrder(list, new HelperLabel(port.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_INPUT"), port.getType()));
                            continue;
                        }
                        UtilOcas.addInAlphabeticOrder(list, new HelperLabel(port.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_FLOW_OUTPUT"), port.getType()));
                    }
                    for (AltaState state : ((AltaComponent)model).getStates()) {
                        UtilOcas.addInAlphabeticOrder(list, new HelperLabel(state.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_STATE"), state.getType()));
                    }
                    for (AltaEvent event : ((AltaComponent)model).getEvents()) {
                        UtilOcas.addInAlphabeticOrder(list, new HelperLabel(event.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_EVENT"), ""));
                    }
                    if (((AltaComponent)model).getSimuls().size() > 0) {
                        UtilOcas.addInAlphabeticOrder(list, new HelperLabel("icone", (Icon)ResIcoOcas.getImageIcon("ICONE_PI"), ""));
                    }
                    resultString = model.getDBFolder().getRefPath();
                }
                if (!(model instanceof AltaEquipment)) break;
                for (AltaSynchro sync : ((AltaEquipment)model).getSynchros()) {
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(sync.getName(), (Icon)ResIcoCore.getImageIcon("MBSA_SYNC"), ""));
                }
                for (AltaSub sub : ((AltaEquipment)model).getSubs()) {
                    UtilOcas.addInAlphabeticOrder(list, new HelperLabel(sub.getName(), (Icon)(sub.getNode() instanceof AltaEquipment ? ResIcoCore.getImageIcon("FOLDER_EQUIPMENT_") : ResIcoCore.getImageIcon("FOLDER_COMPONENT_")), ""));
                }
                resultString = model.getDBFolder().getRefPath();
            }
        }
        return resultString;
    }

    private void defineActions() {
        this._tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component tabSelected;
                if (AltaSystemFrame.this._oldTabSelected == AltaSystemFrame.this._editorTabPane) {
                    AltaSystemFrame.this.getAltaNode().setCode(AltaSystemFrame.this._codeEditor.getText());
                }
                if (AltaSystemFrame.this._oldTabSelected instanceof AltaEditPanel) {
                    ((AltaEditPanel)AltaSystemFrame.this._oldTabSelected).toDoWhenDeActivated();
                }
                if ((tabSelected = AltaSystemFrame.this._tabPane.getSelectedComponent()) == AltaSystemFrame.this._editorTabPane) {
                    AltaSystemFrame.this._editorTabPane.setSelectedIndex(0);
                    try {
                        AltaSystemFrame.this._codeEditor.setHeader(AltaSystemFrame.this.getAltaNode().getHeader(true));
                    }
                    catch (IOException ioe) {
                        AltaSystemFrame.this._codeEditor.setHeader("/*Exception: " + ioe.getMessage() + "*/");
                    }
                    AltaSystemFrame.this._codeEditor.setText(AltaSystemFrame.this.getAltaNode().getCode());
                    try {
                        AltaSystemFrame.this._codeEditor.setBottom(AltaSystemFrame.this.getAltaNode().getFooter());
                    }
                    catch (IOException ioe) {
                        AltaSystemFrame.this._codeEditor.setBottom("/*Exception: " + ioe.getMessage() + "*/");
                    }
                } else if (tabSelected instanceof AltaEditPanel) {
                    ((AltaEditPanel)tabSelected).toDoWhenActivated();
                }
                AltaSystemFrame.this.focusTreatment();
                AltaSystemFrame.this._oldTabSelected = tabSelected;
            }
        });
    }

    private void editSystem(AltaSystem node) {
        super.editNode(node);
        this._contentPanel.setComponent(node);
        this._syncPanel.setComponent(node);
        this._configPanel.setComponent(node);
        this._eventPanel.setComponent(node);
        this._colorPanel.setComponent(node);
        this._propertiesPanel.setDBFolder(node.getDBFolder());
    }

    @Override
    public void updateLangage() {
        this._syncPanel.updateLangage();
        this._configPanel.updateLangage();
        this._eventPanel.updateLangage();
        this._colorPanel.updateLangage();
        this._propertiesPanel.updateLangage();
        super.updateLangage();
    }

    @Override
    public boolean verifyData() {
        if (this.getAltaNode().getConfigs().isEmpty()) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), ResMsgOcas.getString("MSG_XML_CONFIG_NONE"), this.getTitle(), 0);
            this._tabPane.setSelectedIndex(3);
            return false;
        }
        return super.verifyData();
    }

    @Override
    protected String getDescription() {
        return this._propertiesPanel.getComment();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.getAltaNode().getConfigs().isEmpty()) {
            return false;
        }
        if (this._oldTabSelected == this._editorTabPane) {
            this.getAltaNode().setCode(this._codeEditor.getText());
        }
        this.updateSelectedOperator();
        if (!this.doSave()) {
            return false;
        }
        this._propertiesPanel.updateDBFolder(this.getDBFolder());
        return true;
    }

    @Override
    protected DBWrapSaveAsDlg saveAsPrepareDialog() {
        return new DBWrapSaveAsDlgWithVirtual(JOptionCecilia.getWindowOf(this), this.getApplication(), this.getDBFolder().getFamily());
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this._propertiesPanel.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        this._propertiesPanel.setModified(modified);
    }

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_COMPONENT");
    }

    @Override
    public boolean toDoWhenClosing() {
        if (!super.toDoWhenClosing()) {
            return false;
        }
        if (!this.verifyClose()) {
            return false;
        }
        new DBFolderThreadClose(this.getDBFolder(), this.getApplication(), this._ctrlClose){

            @Override
            protected void firstDo() {
                super.firstDo();
                AltaSystemFrame.this._editorHelper.hideWindow();
                AltaSystemFrame.this._eventPanel.hideEditor();
            }
        }.realiseDo();
        return true;
    }

    @Override
    protected void toDoWhenDeActivated() {
        this._oldTabSelected = this._tabPane.getSelectedComponent();
        if (this._oldTabSelected instanceof AltaEditPanel) {
            ((AltaEditPanel)this._oldTabSelected).toDoWhenDeActivated();
        }
        if (this._oldTabSelected == this._contentPanel) {
            this._gui.setEnabledAction("SEARCH", false);
        }
        ((SearchAction)this._gui.getAction("SEARCH")).saveContextDlg(this.getApplication(), this, SearchDlg.SearchType.ARCHITECTURE, this.getAltaNode().getRefPath());
        if (this._editorHelper != null) {
            this._editorHelper.hideWindow();
        }
        this._eventPanel.hideEditor();
        super.toDoWhenDeActivated();
    }

    @Override
    protected void toDoWhenActivated() {
        boolean canBeUpdated = this.getUpdateUtility().canBeUpdated();
        super.toDoWhenActivated();
        if (canBeUpdated && !this.getUpdateUtility().canBeUpdated()) {
            this._eventPanel.refreshTree();
        }
        ((SearchAction)this._gui.getAction("SEARCH")).updateContextDlg(this.getApplication(), this, SearchDlg.SearchType.ARCHITECTURE, this._contentPanel.getAltaComponent().getRefPath());
        this._oldTabSelected = this._tabPane.getSelectedComponent();
        if (this._oldTabSelected instanceof AltaEditPanel) {
            ((AltaEditPanel)this._oldTabSelected).toDoWhenActivated();
        }
        if (this._oldTabSelected == this._contentPanel) {
            this._gui.setEnabledAction("SEARCH", true);
        }
        this._configPanel.refresh();
        this.focusTreatment();
    }

    @Override
    public boolean isEditable() {
        return !this.isReadOnly();
    }

    protected AltaConfig choiceConfig(List<AltaConfig> configurations) {
        Window win = SwingUtilities.getWindowAncestor(this);
        AltaConfigSelectDlg dlg = new AltaConfigSelectDlg(win, this.getApplication().getPlugable());
        if (!dlg.display(configurations)) {
            return null;
        }
        File file = dlg.getLoadedConfiguration();
        if (file != null) {
            Map<String, String> inits = null;
            ConfigIOUtility utility = new ConfigIOUtility();
            try {
                inits = utility.getReadConfig(file.getAbsolutePath());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this), e.getMessage(), ResMsgOcas.getString("KEY_0857"), 0);
                return null;
            }
            AltaConfig config = new AltaConfig().setStates(inits);
            config.setName("[loaded]").setLabel(file.getAbsolutePath());
            ArrayList errors = new ArrayList();
            config.verify(errors, this.getAltaNode());
            if (errors.size() > 0) {
                GeneralDlgDisplayError<String> dlgError = new GeneralDlgDisplayError<String>(win){

                    @Override
                    protected Class<?> getSourceClass() {
                        return String.class;
                    }

                    @Override
                    protected String getSourceName() {
                        return ResMsgOcas.getString("OCAS_INIT_STATES");
                    }

                    @Override
                    protected TableCellRenderer getSourceRenderer() {
                        return new DefaultTableCellRenderer();
                    }
                };
                dlgError.setErrors(errors);
                dlgError.setModal(true);
                dlgError.setLocationRelativeTo(JOptionCecilia.getTopContainerOf(this));
                dlgError.setVisible(true);
                return null;
            }
            return config;
        }
        return dlg.getSelectedConfiguration();
    }

    protected GenerateAltaricaCode generateCode(AltaConfig config) {
        if (config == null) {
            boolean alwaysDisplayDlg = Boolean.parseBoolean(this.getApplication().getPlugable().getOption(AltaConfig.OPTION_CONFIG_ALWAYS_SELECT));
            List<AltaConfig> configurations = this.getAltaNode().getConfigs();
            if (configurations.size() != 0 || alwaysDisplayDlg) {
                if (configurations.size() > 0) {
                    config = configurations.get(0);
                }
                if (configurations.size() > 1 || alwaysDisplayDlg) {
                    config = this.choiceConfig(configurations);
                }
                if (config == null) {
                    return null;
                }
            }
        }
        if (this._oldTabSelected == this._editorTabPane) {
            this.getAltaNode().setCode(this._codeEditor.getText());
        }
        this.updateSelectedOperator();
        AltaSystem node = this.getAltaNode();
        GenerateAltaricaCode generator = node.generateCode(this.getAltaOcasFile(), this.getApplication().getDAOFactory(), new GenerateAltaricaCode.GenerateAltaRicaCodeUtility.Default(config));
        if (generator.getFile() == null) {
            this.displayErrors(generator.getErrors(), JOptionCecilia.getTopTitleOf(this));
            return null;
        }
        node.setCurrentConfig(config);
        return generator;
    }

    @Override
    protected GenerateAltaricaCode generateCode() {
        return this.generateCode(null);
    }

    @Override
    public InfoDatum getDatum(String key) {
        GenerateAltaricaCode code;
        if (!key.startsWith("Stepper.")) {
            return null;
        }
        AltaSystem node = this.getAltaNode();
        if (node == null) {
            return null;
        }
        String stepperKey = key.substring("Stepper.".length());
        AltaConfig altaConfig = null;
        if (stepperKey.indexOf("@") != -1) {
            int idx = stepperKey.indexOf("@");
            String strConfig = stepperKey.substring(idx + 1);
            stepperKey = stepperKey.substring(0, idx);
            altaConfig = node.getConfig(strConfig);
            if (altaConfig == null) {
                _LOG.info("Le modele MBSA '" + node.getDBFolder().getRefPath() + "' n'a pas de configuration initiale : " + strConfig);
                return null;
            }
        }
        if ((code = this.generateCode(altaConfig)) == null || code.getFile() == null) {
            return null;
        }
        String config = node.getInitialConfiguration().getName();
        String mapKey = new StringBuilder(128).append(stepperKey).append(".").append(config).toString();
        String nature = DBObjModel.constructNature("system.stepper", config, stepperKey);
        AltaInfoStepper istepper = this._altaInfoStepper.get(mapKey);
        if (istepper == null) {
            DBObjModel modelXTra = this.getDBFolder().getObject().getModel(nature);
            if (modelXTra == null) {
                _LOG.finest(StringUtilities.STR((String[])new String[]{"Pas de stepper de sauvegarde : ", this.getDBFolder().getRefPath(), ", ", stepperKey, ", ", config}));
            } else if (!modelXTra.getCRC().equals(code.getCRC())) {
                _LOG.fine(StringUtilities.STR((String[])new String[]{"CRC different pour le stepper de sauvegarde : ", this.getDBFolder().getRefPath(), ", ", stepperKey, ", ", config, ", ", modelXTra.getCRC(), ", ", code.getCRC()}));
            } else {
                InputStream stream = this.getApplication().getDAOFactory().createObjModelDAO().getBinaryStream(modelXTra);
                if (stream == null) {
                    _LOG.warning(StringUtilities.STR((String[])new String[]{"Probleme de lecture DAO pour le stepper de sauvegarde : ", this.getDBFolder().getRefPath(), ", ", stepperKey, ", ", config, ", ", modelXTra.getCRC()}));
                } else {
                    try {
                        istepper = new AltaInfoStepper(stream);
                    }
                    catch (IOException ex) {
                        _LOG.log(Level.WARNING, StringUtilities.STR((String[])new String[]{"Probleme lors de la lecture d'un stepper sauvegarde en base : ", this.getDBFolder().getRefPath(), ", ", stepperKey, ", ", config}), ex);
                    }
                    if (istepper != null && istepper.getKey() != null) {
                        this._altaInfoStepper.put(mapKey, istepper);
                        istepper.getInputFiles().put("altarica.file", code.getFile());
                        Map<String, String> params = istepper.getParameters();
                        params.put("ID", Long.toString(this.getDBFolder().getID()));
                        params.put("CRC", code.getCRC());
                        params.put("Config", config);
                        params.put("Main", node.getAltaRicaName());
                        params.put("IsLoadedConfig", "true");
                        return istepper;
                    }
                }
            }
        }
        if (istepper != null) {
            if (code.getCRC().equals(istepper.getParameters().get("CRC"))) {
                return istepper;
            }
            _LOG.fine(StringUtilities.STR((String[])new String[]{"CRC different pour le stepper en cache : ", this.getDBFolder().getRefPath(), ", ", stepperKey, ", ", config, ", ", istepper.getParameters().get("CRC"), ", ", code.getCRC()}));
            istepper.clean();
            this._altaInfoStepper.remove(mapKey);
        }
        istepper = new AltaInfoStepper(key, stepperKey, this.getDBFolder().getID());
        istepper.getInputFiles().put("altarica.file", code.getFile());
        Map<String, String> params = istepper.getParameters();
        params.put("CRC", code.getCRC());
        params.put("Config", config);
        params.put("Main", node.getAltaRicaName());
        return istepper;
    }

    @Override
    public void setDatum(InfoDatum idatum, Plugable srcPlugable) {
        String config;
        String mapKey;
        AltaInfoStepper istepper;
        if (this.getApplication().isReader()) {
            return;
        }
        if (idatum.getModel().getUID() != this.getDBFolder().getID()) {
            _LOG.info("setDatum(...) with bad ID for equation '" + this.getDBFolder().getRefPath() + "'");
            return;
        }
        String key = idatum.getKey();
        if (!key.startsWith("Stepper.")) {
            return;
        }
        String stepperKey = key.substring("Stepper.".length());
        if (stepperKey.indexOf("@") != -1) {
            int idx = stepperKey.indexOf("@");
            stepperKey = stepperKey.substring(0, idx);
        }
        if ((istepper = this._altaInfoStepper.get(mapKey = stepperKey + "." + (config = idatum.getParameters().get("Config")))) != null) {
            istepper.clean();
            this._altaInfoStepper.remove(mapKey);
        }
        istepper = new AltaInfoStepper(idatum);
        this._altaInfoStepper.put(mapKey, istepper);
        if (!Boolean.parseBoolean(istepper.getParameters().get("IsLoadedConfig"))) {
            byte[] data = istepper.generateData();
            if (data == null) {
                _LOG.fine(StringUtilities.STR((String[])new String[]{"Non generation des donnees de la sauvegarde du strepper : ", this.getDBFolder().getRefPath(), ", ", stepperKey, ", ", config}));
            } else {
                String nature = DBObjModel.constructNature("system.stepper", config, stepperKey);
                DBObjModel modelXTra = this.getDBFolder().getObject().getModel(nature);
                if (!DBObjModel.validXTraSize(data.length)) {
                    _LOG.info(StringUtilities.STR((String[])new String[]{"La sauvegarde du simulateur compile n'est pas effective a cause de la taille du flux : ", this.getDBFolder().getRefPath(), ", ", stepperKey, ", ", config, ", ", Integer.toString(data.length)}));
                    if (modelXTra != null) {
                        this.getDBFolder().getObject().delModel(modelXTra);
                    }
                } else {
                    if (modelXTra == null) {
                        modelXTra = new DBObjModel();
                        modelXTra.setNature(nature);
                        this.getDBFolder().getObject().addModel(modelXTra);
                    }
                    modelXTra.setFormat("ZIP");
                    modelXTra.setEncoding("");
                    modelXTra.setCRC(istepper.getParameters().get("CRC"));
                    modelXTra.setSize(data.length);
                    modelXTra.setStreamToSave(new ByteArrayInputStream(data));
                    this.getAltaNode().setModified(true);
                }
            }
        }
    }

    @Override
    public IModel getModel(String key) {
        if (key.equals("docbook.file") || key.equals("word.file")) {
            return this.getModel(key, "MBSA_");
        }
        return super.getModel(key);
    }

    @Override
    protected void configBook(ExpBook book) {
        XPortCfgSystem xport = new XPortCfgSystem();
        xport.configBook(book, this.getAltaNode());
    }

    @Override
    protected void updateEdit() {
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), this.getAltaNode().getLogs());
        this.getAltaNode().update(this.getApplication().getDAOFactory(), logMng);
        this._syncPanel.refreshTable();
        this.getAltaNode().computeControlPoints();
        this._contentPanel.refreshContent();
        this._colorPanel.setComponent(this.getAltaNode());
        this._configPanel.refresh();
        this._eventPanel.refreshTable();
        this.getAltaNode().prepareDependTimeUpdt(this.getApplication().getDAOFactory(), this.getAltaNode().getUseRelations());
        this.updateLogs(this.getAltaNode().getUseRelations(), oldLevel, oldNbr);
    }

    @Override
    protected void updatePrivateLogs() {
        this.getAltaNode().updateLinksLogs(this.getApplication().getDBUser().getLogin(), this.getAltaNode().getLinks());
    }
}

