/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaTypeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import java.awt.Color;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBAltaColorHandlerXml
extends DBAltaTypeHandlerXml {
    public static final String ELT_ALTA_COLORS = "alta.colors";
    public static final String ELT_ALTA_TYPE = "alta.colors.type";
    public static final String ELT_ALTA_CASE = "alta.colors.case";
    AltaColor _altaColor = null;
    AltaColor.ColorMap _currentMap;
    AltaType _currentType;

    protected DBAltaColorHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory cecFactory) {
        super(manager, locator, cecFactory);
    }

    public AltaColor getColors() {
        return this._altaColor;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            if (!ELT_ALTA_COLORS.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", ELT_ALTA_COLORS), this.getLocator()));
            }
            this._altaColor = new AltaColor();
        } else if (this._currentMap == null && ELT_ALTA_TYPE.equals(key)) {
            this._currentType = this.readType(key, attrs);
            if (this._altaColor.isValidType(this._currentType)) {
                this._currentMap = this._altaColor.findOrCreateColorMap(this._currentType);
            } else {
                this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COLOR_TYPE_UNCOMPATIBLE", this._currentType), this.getLocator()));
            }
        } else if (this._currentMap != null && ELT_ALTA_CASE.equals(key)) {
            String value = attrs.get("value");
            if (value == null || value.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "value"), this.getLocator()));
            }
            if (!this._currentType.valueExist(value)) {
                this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COLOR_BADVALUE", value, this._currentType), this.getLocator()));
            }
            Color color = null;
            String attr = attrs.get("color");
            if (attr == null || attr.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "color"), this.getLocator()));
            }
            try {
                color = DBObjectXmlUtility.readColor(attr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (color == null) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "color", attr), this.getLocator()));
            }
            if (value != null && color != null) {
                this._currentMap.putColor(value, color);
            }
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXParseException {
        if (this._currentMap != null && ELT_ALTA_TYPE.equals(key)) {
            this._currentType = null;
            this._currentMap = null;
            return false;
        }
        return ELT_ALTA_COLORS.equals(key);
    }
}

