/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.io;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBObjectReaderRaw;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeFloat;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeInt;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeParser;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.io.ocas51.CoreUtil;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class DBColorsReaderRaw
extends DBObjectReaderRaw {
    Map<AltaType, AltaColor.ColorMap> _colors = new LinkedHashMap<AltaType, AltaColor.ColorMap>();

    public DBColorsReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        super(dbFolder, logMng);
    }

    public Map<AltaType, AltaColor.ColorMap> getColors() {
        return this._colors;
    }

    @Override
    public boolean readRaw(String data, CECFactory cecFactory) throws IOException {
        String line;
        BufferedReader inData = new BufferedReader(new StringReader(data));
        while ((line = inData.readLine()) != null) {
            if (!line.startsWith("<type ")) continue;
            this.readType(inData, line, cecFactory);
        }
        return true;
    }

    protected void readType(BufferedReader inData, String line, CECFactory cecFactory) throws IOException {
        String name = "";
        int position = line.indexOf("name=");
        if (position != -1) {
            name = CoreUtil.searchString(line.substring(position));
        }
        AltaType altaType = null;
        if (!name.isEmpty()) {
            altaType = AltaTypeParser.getType(name);
        }
        if (altaType == null) {
            altaType = AltaTypeParser.getDBType(name, -1L, cecFactory);
        }
        AltaColor.ColorMap colorsRead = new AltaColor.ColorMap(altaType, 3);
        this.readColors(inData, colorsRead, cecFactory);
        if (altaType == null) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_RAW_COLOR_TYPE_UNKNOWN", name));
        } else if (altaType instanceof DBRecord || altaType instanceof AltaTypeInt || altaType instanceof AltaTypeFloat) {
            this._logManager.addLog(DBLogs.DBLevel.WARNING, ResMsgOcas.msgFormat("MSG_XML_COLOR_TYPE_UNCOMPATIBLE", name));
        } else if (this._colors.get(altaType) != null) {
            this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_RAW_COLOR_TYPE_ALREADY", name));
        } else {
            int nbrValue = altaType.getValueCount();
            if (nbrValue != colorsRead.getItems().size()) {
                this.logMsg(Level.INFO, "Le panel des couleurs n'est pas totalement compatible avec le type:" + altaType.toString());
            }
            AltaColor.ColorMap colors = new AltaColor.ColorMap(altaType, nbrValue);
            for (int i = 0; i < nbrValue; ++i) {
                String value = altaType.getValueAt(i).toString();
                Color col = colorsRead.getColor(value);
                if (col == null) {
                    this.logMsg(Level.INFO, "Pas de couleur de d\u00e9fini pour la valeur:" + value);
                    col = colorsRead.getDefaultColor();
                }
                colors.putColor(value, col);
            }
            this._colors.put(altaType, colors);
        }
    }

    private void readColors(BufferedReader inData, AltaColor.ColorMap colors, CECFactory cecFactory) throws IOException {
        String line;
        while ((line = inData.readLine()) != null && line.indexOf("</type>") == -1) {
            if (line.indexOf("<value") == -1) continue;
            String value = CoreUtil.searchString(line, "name=");
            int red = -1;
            int green = -1;
            int blue = -1;
            int position = line.indexOf("red=");
            if (position != -1) {
                red = CoreUtil.searchValue(line.substring(position));
            }
            if (red < 0 || red > 255) {
                this.logMsg(Level.INFO, "La partie 'red' de la couleur n'a pas de sens" + line);
                red = 0;
            }
            if ((position = line.indexOf("green=")) != -1) {
                green = CoreUtil.searchValue(line.substring(position));
            }
            if (green < 0 || green > 255) {
                this.logMsg(Level.INFO, "La partie 'green' de la couleur n'a pas de sens" + line);
                green = 0;
            }
            if ((position = line.indexOf("blue=")) != -1) {
                blue = CoreUtil.searchValue(line.substring(position));
            }
            if (blue < 0 || blue > 255) {
                this.logMsg(Level.INFO, "La partie 'blue' de la couleur n'a pas de sens" + line);
                blue = 0;
            }
            colors.putColor(value, new Color(red, green, blue));
        }
    }
}

