/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.component.io.DBAltaEventHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.equipment.io.DBEquipmentHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.system.AltaColor;
import com.dassault.cecilia.dbobj.mbsa.system.AltaConfig;
import com.dassault.cecilia.dbobj.mbsa.system.io.DBAltaColorHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.system.io.DBAltaConfigHandlerXml;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBSystemHandlerXml
extends DBEquipmentHandlerXml {
    private static Logger _LOG = Logger.getLogger(DBSystemHandlerXml.class.getPackage().getName());
    public static final String ELT_CEC_MODEL = "cec.mbsa";
    Map<String, AltaConfig> _mapConfigs = new LinkedHashMap<String, AltaConfig>();
    AltaColor _altaColor;
    DBAltaConfigHandlerXml _configHandler = null;
    DBAltaColorHandlerXml _colorHandler = null;

    public DBSystemHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory cecFactory) {
        super(manager, locator, cecFactory, ELT_CEC_MODEL);
    }

    public Collection<AltaConfig> getConfigs() {
        return this._mapConfigs.values();
    }

    public AltaColor getColors() {
        return this._altaColor;
    }

    @Override
    protected void readAttributesComponent(String key, Map<String, String> attrs) throws SAXParseException {
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (this._eventHandler != null) {
            this._eventHandler.startAction(key, attrs, false);
        } else if (this._configHandler != null) {
            this._configHandler.startAction(key, attrs, false);
        } else if (this._colorHandler != null) {
            this._colorHandler.startAction(key, attrs, false);
        } else if (this._syncHandler != null) {
            this._syncHandler.startAction(key, attrs, false);
        } else if (this._contentHandler != null) {
            this._contentHandler.startAction(key, attrs, false);
        } else if (startAction) {
            if (!this._topElement.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", this._topElement), this.getLocator()));
            }
            this.readAttributesComponent(key, attrs);
        } else if ("alta.event".equals(key)) {
            this._eventHandler = new DBAltaEventHandlerXml(this.getLogManager(), this.getLocator(), this._cecFactory, this);
            this._eventHandler.setNameCanBePath(true);
            this._eventHandler.startAction(key, attrs, true);
        } else if ("alta.config".equals(key)) {
            this._configHandler = new DBAltaConfigHandlerXml(this.getLogManager(), this.getLocator());
            this._configHandler.startAction(key, attrs, true);
        } else if ("alta.colors".equals(key)) {
            this._colorHandler = new DBAltaColorHandlerXml(this.getLogManager(), this.getLocator(), this._cecFactory);
            this._colorHandler.startAction(key, attrs, true);
        } else {
            this.startEquipmentAction(key, attrs, startAction);
        }
    }

    @Override
    protected void startComponentAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        this.startNodeAction(key, attrs, startAction);
    }

    @Override
    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._eventHandler != null) {
            return this.endEvent(key, attrs, txt);
        }
        if (this._configHandler != null) {
            boolean result = this._configHandler.endAction(key, attrs, txt);
            if (result) {
                if ("alta.config".equals(key)) {
                    AltaConfig config = this._configHandler.getConfig();
                    if (config != null) {
                        String name = config.getName();
                        if (this._mapConfigs.containsKey(name)) {
                            this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_COMPONENT_CONFIG_ALREADY", name), this.getLocator()));
                        }
                        this._mapConfigs.put(name, config);
                    }
                } else {
                    _LOG.severe("Erreur interne \u00e0 la fermeture de l'\u00e9l\u00e9ment '" + key + "'");
                }
                this._configHandler = null;
            }
            return false;
        }
        if (this._colorHandler != null) {
            boolean result = this._colorHandler.endAction(key, attrs, txt);
            if (result) {
                if ("alta.colors".equals(key)) {
                    this._altaColor = this._colorHandler.getColors();
                } else {
                    _LOG.severe("Erreur interne \u00e0 la fermeture de l'\u00e9l\u00e9ment '" + key + "'");
                }
                this._colorHandler = null;
            }
            return false;
        }
        return super.endAction(key, attrs, txt);
    }
}

