/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.system.io.config;

import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.system.io.config.ConfigParser;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigIOUtility {
    public Map<String, String> readTxt(File input) throws IOException {
        FileReader reader = new FileReader(input);
        ConfigParser parser = new ConfigParser(reader);
        parser.run();
        Map<String, String> result = parser.getConfig();
        if (result != null) {
            return result;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ResMsgOcas.msgFormat("MSG_ERR_CONFIG_TXT_FILE", input.getAbsolutePath()));
        sb.append(parser.getError());
        throw new IOException(sb.toString());
    }

    public Map<String, String> readXml(File input) throws IOException {
        class InitHandler
        extends SAXExtendedHandler {
            Map<String, String> _config = new TreeMap<String, String>();
            int _XMLRoot = -1;
            String _state = null;

            InitHandler() {
            }

            public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXParseException {
                switch (this._XMLRoot) {
                    default: {
                        if (key.equals("seqgen")) {
                            this._XMLRoot = 1;
                            break;
                        }
                        if (key.equals("fmeagen")) {
                            this._XMLRoot = 2;
                            break;
                        }
                        if (key.equals("propagategen")) {
                            this._XMLRoot = 3;
                            break;
                        }
                        throw new SAXParseException(ResMsgOcas.msgFormat("MSG_ERR_CONFIG_XML_DOC", key, "{seqgen, fmeagen, propagategen}"), this.getLocator());
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!key.equals("model")) break;
                        this._XMLRoot = 4;
                        break;
                    }
                    case 4: {
                        String value;
                        if (key.equals("state")) {
                            this._state = attrs.get("name");
                            if (this._state == null || this._state.trim().length() != 0) break;
                            this._state = null;
                            break;
                        }
                        if (!key.equals("init") || this._state == null || (value = attrs.get("value")) == null || value.trim().length() <= 0) break;
                        this._config.put(this._state, value);
                    }
                }
            }

            public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXParseException {
                switch (this._XMLRoot) {
                    case 4: {
                        if (key.equals("state")) {
                            this._state = null;
                            break;
                        }
                        if (!key.equals("model")) break;
                        this._XMLRoot = -1;
                    }
                }
                return false;
            }
        }
        InitHandler handler = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            handler = new InitHandler();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(input, (DefaultHandler)((Object)handler));
            return handler._config;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            Locator loc;
            int row = -1;
            int col = -1;
            if (handler != null && (loc = handler.getLocator()) != null) {
                row = loc.getLineNumber();
                col = loc.getColumnNumber();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(ResMsgOcas.msgFormat("MSG_ERR_CONFIG_XML_SYNTAX", row, col));
            sb.append("\n");
            sb.append(e.getMessage());
            throw new IOException(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findExtention(File input) throws IOException {
        try (BufferedReader read = new BufferedReader(new FileReader(input));){
            String line = read.readLine();
            while (line != null) {
                if (line.startsWith("<?xml")) {
                    String string = "xml";
                    return string;
                }
                if (line.trim().length() > 0) {
                    break;
                }
                line = read.readLine();
            }
        }
        return "txt";
    }

    public Map<String, String> getReadConfig(String path) throws IOException {
        File input = new File(path);
        String ext = this.findExtention(input);
        if (ext.equalsIgnoreCase("xml")) {
            return this.readXml(input);
        }
        if (ext.equalsIgnoreCase("txt")) {
            return this.readTxt(input);
        }
        throw new IOException(ResMsgOcas.getString("MSG_ERR_CONFIG_FORMAT") + " : " + input.getPath());
    }
}

