/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type;

import com.dassault.cecilia.db.DBFactory;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeAbstract;
import java.util.StringTokenizer;

public class AltaTypeBound
extends AltaTypeAbstract {
    int _min;
    int _max;
    String _define;
    String _default;

    public AltaTypeBound(int min, int max) {
        this._min = min;
        this._max = max;
        this.init();
    }

    public int getMin() {
        return this._min;
    }

    public int getMax() {
        return this._max;
    }

    public AltaTypeBound(String value) {
        value = value.substring(1, value.length() - 1);
        StringTokenizer token = new StringTokenizer(value, ",");
        this._min = Integer.parseInt(token.nextToken());
        this._max = Integer.parseInt(token.nextToken());
        this.init();
    }

    private void init() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this._min).append(",").append(this._max).append("]");
        this._define = sb.toString();
        this._default = Integer.toString(this._min);
    }

    public String toString() {
        return this._define;
    }

    @Override
    public AltaType getCopy() {
        return new AltaTypeBound(this._min, this._max);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AltaTypeBound)) {
            return false;
        }
        return this.equivalents((AltaTypeBound)obj);
    }

    public int hashCode() {
        return this._define.hashCode();
    }

    @Override
    public String getValue() {
        return this._define;
    }

    @Override
    public String getDefaultValue() {
        return this._default;
    }

    @Override
    public int getValueCount() {
        return this._max - this._min + 1;
    }

    @Override
    public String getValueAt(int index) {
        return Integer.toString(this._min + index);
    }

    @Override
    public boolean valueExist(String value) {
        int val;
        return DBFactory.verifyInteger(value) && (val = Integer.parseInt(value)) >= this._min && val <= this._max;
    }

    @Override
    public int getValueIndex(Object value) {
        int val;
        if (DBFactory.verifyInteger((String)value) && (val = Integer.parseInt((String)value)) >= this._min && val <= this._max) {
            return val - this._min;
        }
        return -1;
    }

    @Override
    public boolean equivalents(AltaType type) {
        if (type == null) {
            return false;
        }
        if (type == this) {
            return true;
        }
        if (type instanceof AltaTypeBound) {
            if (this._min != ((AltaTypeBound)type)._min) {
                return false;
            }
            return this._max == ((AltaTypeBound)type)._max;
        }
        return false;
    }
}

