/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.DBLogsWrap;
import com.dassault.cecilia.dbobj.mbsa.node.io.AltaFileHeader;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.AltaTypeEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.mbsa.type.io.DBEnumHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.type.io.DBEnumReaderRaw;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.compareConflict.CompareResultType;
import com.dassault.cecilia.dbobj.wrap.compareConflict.DBComparaisons;
import com.dassault.cecilia.lib.util.xmlparser.SAXExtendedHandler;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.xml.sax.SAXException;

public class DBEnum
extends DBType {
    public static final String PROP_DB_ENUM_EQUIVALENT = "cecilia.mbsa.dbenum.Equivalent";
    private static boolean __DBENUM_EQUIVALENT = Boolean.getBoolean("cecilia.mbsa.dbenum.Equivalent");
    private List<String> _values = new ArrayList<String>();
    private Map<String, Color> _mapEnumerateToColor = new LinkedHashMap<String, Color>();
    private String _define;

    public DBEnum(DBFolder dbFolder) {
        super(dbFolder);
    }

    @Override
    public boolean equivalents(AltaType type) {
        if (type == null) {
            return false;
        }
        if (type == this) {
            return true;
        }
        if (!__DBENUM_EQUIVALENT && type instanceof DBEnum) {
            return this.equals(type);
        }
        int size = this._values.size();
        if (type.getValueCount() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            String elt = type.getValueAt(i);
            if (this._values.contains(elt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DBEnum getCopy() {
        DBEnum res = new DBEnum(this._dbFolder);
        res.copy(this);
        return res;
    }

    @Override
    protected void copy(DBLogsWrap src) {
        super.copy(src);
        if (src instanceof DBEnum) {
            DBEnum dbEnum = (DBEnum)src;
            this._define = dbEnum._define;
            this._values.clear();
            this._values.addAll(dbEnum._values);
            this._mapEnumerateToColor.clear();
            this._mapEnumerateToColor.putAll(dbEnum._mapEnumerateToColor);
        }
    }

    public void update(DBEnum type) {
        this.copy(type);
    }

    @Override
    public short getFamilyFlag() {
        return 1;
    }

    @Override
    protected String getNature() {
        return "type.enumerated";
    }

    @Override
    public Collection<DBRelation> getUseRelations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void toXML(Appendable outData, String indent) throws IOException {
        outData.append("<").append("cec.type.enum").append(">\n");
        for (int i = 0; i < this._values.size(); ++i) {
            outData.append("  <").append("enum.field");
            String enumerateName = this._values.get(i);
            DBObjectXmlUtility.appendXML(outData.append(" ").append("value").append("='"), enumerateName).append("'");
            Color color = this._mapEnumerateToColor.get(enumerateName);
            if (color != null) {
                DBObjectXmlUtility.writeAttrColor(outData, "color", true, color);
            }
            outData.append("/>\n");
        }
        outData.append("</").append("cec.type.enum").append(">\n");
    }

    @Override
    protected SAXExtendedHandler createXMLHandler(CECFactory daoFactory, DBLogs.DBLogsManager logMng) {
        return new DBEnumHandlerXml(logMng, null){

            public void endDocument() throws SAXException {
                super.endDocument();
                DBEnum.this._values.clear();
                DBEnum.this._values.addAll(this.getEnums());
                DBEnum.this._mapEnumerateToColor.clear();
                DBEnum.this._mapEnumerateToColor.putAll(this.getMapEnumerateToColor());
            }
        };
    }

    @Override
    public void readFromFile(String input, CECFactory cecFactory, DBLogs.DBLogsManager logMng) throws IOException {
        DBEnumReaderRaw readerRaw = new DBEnumReaderRaw(this._dbFolder, logMng);
        if (readerRaw.readRaw(input, cecFactory)) {
            this._values.clear();
            this._values.addAll(readerRaw.getValues());
            AltaFileHeader properties = readerRaw.getProperties();
            if (properties != null) {
                properties.convertToDBFolder(this._dbFolder, cecFactory, logMng);
            }
        }
    }

    @Override
    public void writeAltaRicaDefine(Appendable out) throws IOException {
        super.writeAltaRicaDefine(out);
        out.append(this.getValue());
        out.append(";\n");
    }

    public void setColorToEnumerate(String enumerate, Color color) {
        this._mapEnumerateToColor.put(enumerate, color);
    }

    public Color getColorEnumerate(String enumerate) {
        return this._mapEnumerateToColor.get(enumerate);
    }

    @Override
    public String getValue() {
        if (this._define == null) {
            this._define = AltaTypeEnum.toDefine(this._values);
        }
        return this._define;
    }

    @Override
    public String getDefaultValue() {
        if (this._values.size() > 0) {
            return this._values.get(0);
        }
        return null;
    }

    @Override
    public int getValueCount() {
        return this._values.size();
    }

    @Override
    public String getValueAt(int index) {
        return this._values.get(index);
    }

    @Override
    public boolean valueExist(String value) {
        return this._values.contains(value);
    }

    @Override
    public int getValueIndex(Object value) {
        return this._values.indexOf(value);
    }

    public void setValueAt(String value, int idx) {
        String oldVal = this._values.get(idx);
        Color colorEnumerate = this._mapEnumerateToColor.get(oldVal);
        this._values.set(idx, value);
        this._mapEnumerateToColor.remove(oldVal);
        this._mapEnumerateToColor.put(value, colorEnumerate);
        this._define = null;
    }

    public void addValue(String value, int idx) {
        this._values.add(idx, value);
        if (this._values.size() == 1) {
            this._mapEnumerateToColor.put(value, Color.GREEN);
        } else if (this._values.size() == 2) {
            this._mapEnumerateToColor.put(value, Color.RED);
        } else {
            this._mapEnumerateToColor.put(value, Color.BLACK);
        }
        this._define = null;
    }

    public void removeValue(int idx) {
        this._mapEnumerateToColor.remove(this._values.get(idx));
        this._values.remove(idx);
        this._define = null;
    }

    @Override
    public DBComparaisons getCompareConflict(DAOFactory factoryWrap, DBWrap wrap, boolean forImport) {
        DBComparaisons comparaisons = super.getCompareConflict(factoryWrap, wrap, forImport);
        DBEnum ref = this;
        DBEnum toBeCompared = (DBEnum)wrap;
        HashSet set = new HashSet();
        BiPredicate<DBEnum, Integer> pred = (dbenum, idx) -> {
            if (idx >= dbenum.getValueCount()) {
                return false;
            }
            String val = dbenum.getValueAt((int)idx);
            if (set.add(val)) {
                comparaisons.addConflict(new CompareResultType(ref, toBeCompared, val));
            }
            return !set.contains(val);
        };
        for (int i = 0; i < ref.getValueCount() || i < toBeCompared.getValueCount(); ++i) {
            pred.test(ref, i);
            pred.test(toBeCompared, i);
        }
        return comparaisons;
    }

    @Override
    public String getAbstract() {
        return this.getDBFolder().getRefPath();
    }
}

