/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type.gui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import com.dassault.cecilia.dbobj.mbsa.type.gui.AltaTypeFrame;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.DBWrapCmdEdit;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.gui.DBInternalFrame;
import java.awt.Component;
import java.awt.Dimension;

public class DBTypeCmdEdit
extends DBWrapCmdEdit {
    public static final int DEFAULT_MAX_ROWS_VIEW = 15;
    public static final String PROP_MAX_ROWS_VIEW = "cecilia.mbsa.type.MaxRowsView";

    public DBTypeCmdEdit(CeciliaAppl appl, Component c, DBFolder folder, boolean readOnly) {
        super(appl, c, folder, readOnly);
    }

    @Override
    protected DBFolder.Family getFamily() {
        return DBFolder.Family.TYPE;
    }

    @Override
    protected String getLabel() {
        return ResMsgVoc.getString("VOC_TYPE");
    }

    @Override
    protected DBInternalFrame editWrap(DBWrap wrap, boolean readOnly) {
        DBType dbType = (DBType)wrap;
        AltaTypeFrame iframe = new AltaTypeFrame(dbType, this.getAppl());
        this.verifyLogsLevel(iframe.getLogs().getMaxLevel());
        iframe.setEditable(!readOnly);
        int nbRow = dbType.getValueCount();
        int rowHeight = 20;
        int max = Integer.getInteger(PROP_MAX_ROWS_VIEW, 15);
        int dialogSize = 5 * rowHeight;
        if (nbRow >= max) {
            dialogSize = (max + 1) * rowHeight;
        } else if (nbRow > 5) {
            dialogSize = (nbRow + 1) * rowHeight;
        }
        iframe.getTable().setPreferredScrollableViewportSize(new Dimension(350, dialogSize));
        iframe.pack();
        iframe.showView(this.getAppl().getTopWindow().getDesktop());
        return iframe;
    }
}

