/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type.gui;

import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.demo.DemoLimitedFactory;
import com.dassault.cecilia.dbobj.folder.DBFolderCmdProperty;
import com.dassault.cecilia.dbobj.folder.DBFolderPropertiesPanel;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeEditable;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.type.DBEnum;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBType;
import java.util.Collections;
import java.util.Date;
import javax.swing.JOptionPane;

public class DBTypeCmdInsert
extends DBFolderCmdProperty {
    short _familyFlag;

    public DBTypeCmdInsert(CAppl appl, DBFolderTreeEditable ctrlTree, short familyFlag) {
        super(appl, ctrlTree, false);
        this._familyFlag = familyFlag;
    }

    @Override
    protected boolean configurePanel(DBFolderPropertiesPanel dlg) {
        if (!super.configurePanel(dlg)) {
            return false;
        }
        if (!this.isEditProperties()) {
            DBFolder create = dlg.getDBFolder();
            create.setFlags(DBFolder.createFlagsModel(create.getFamily(), this._familyFlag, (short)0));
            switch (this._familyFlag) {
                case 1: {
                    dlg.setQuestion(ResMsgVoc.getString("VOC_ENUM"));
                    dlg.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_ENUM"));
                    break;
                }
                case 2: {
                    dlg.setQuestion(ResMsgVoc.getString("VOC_RECORD"));
                    dlg.setTitle(ResMsgObj.getString("TITLE_GEN_CREATE_RECORD"));
                }
            }
        }
        return true;
    }

    @Override
    protected void createModelFolder(DBFolderPropertiesPanel dlg) {
        DBFolder model = dlg.getDBFolder();
        DBFolder version = new DBFolder(model, this._dbUser);
        version.setName("1");
        version.setDescription(model.getDescription());
        version.setFlags(DBFolder.createFlagsVersion(model.getFamily(), this._familyFlag, (short)0));
        version.setObject(this.createObject(version));
        model.setChildren(Collections.singletonList(version));
        this.createDBFolder(model);
    }

    @Override
    protected DBObject createObject(DBFolder dbFolderVersion) {
        DBObject dbObject = super.createObject(dbFolderVersion);
        DBType dbType = null;
        dbType = dbFolderVersion.getFamilyFlag() == 1 ? new DBEnum(dbFolderVersion) : new DBRecord(dbFolderVersion);
        dbType.getLogs().addLog(new Date(), this.getAppl().getDBUser().getLogin(), DBLogs.DBLevel.INIT, ResMsgObj.getString("MSG_ERR_OBJ_NOT_INITIALIZED")).setPrivate(true);
        dbType.configureModels(dbObject);
        return dbObject;
    }

    @Override
    protected boolean verifyCreateNewModel() {
        if (ConfigManager.getVersion() == ConfigManager.TypeVersion.DEMO) {
            DBFolder dbFolder = new DBFolder(this._dbFolder);
            dbFolder.setFamilyFlag(this._familyFlag);
            if (!((DemoLimitedFactory)this._application.getDAOFactory()).verifyCreateNewModel(dbFolder)) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this.getSource()), ResMsgCore.getString("DEMO_ERROR_CREATE"), this._application.getTitle(), 0);
                return false;
            }
        }
        return true;
    }
}

