/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.general.DBObjectXmlConstant;
import com.dassault.cecilia.dbobj.general.DBObjectXmlUtility;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.log.io.SAXLogHandler;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBEnumHandlerXml
extends SAXLogHandler
implements DBObjectXmlConstant {
    public static final String ELT_CEC_TYPE_ENUM = "cec.type.enum";
    public static final String ELT_TYPE_ENUM_VALUE = "enum.field";
    public static final String ELT_TYPE_COLOR_VALUE = "enum.color";
    List<String> _enums;
    Map<String, Color> _mapEnumToColor;

    public DBEnumHandlerXml(DBLogs.DBLogsManager logMng, Locator locator) {
        super(logMng);
        if (locator != null) {
            this.setLocator(locator);
        }
        this._enums = new ArrayList<String>();
        this._mapEnumToColor = new LinkedHashMap<String, Color>();
    }

    public List<String> getEnums() {
        return this._enums;
    }

    public Map<String, Color> getMapEnumerateToColor() {
        return this._mapEnumToColor;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            if (!ELT_CEC_TYPE_ENUM.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", ELT_CEC_TYPE_ENUM), this.getLocator()));
            }
        } else if (ELT_TYPE_ENUM_VALUE.equals(key)) {
            String name = attrs.get("value");
            if (name == null || name.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "value"), this.getLocator()));
            }
            if (this._enums.contains(name)) {
                this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_TYPE_ENUM_VALUE_ALREADY", name), this.getLocator()));
            } else {
                this._enums.add(name);
            }
            String colorStr = attrs.get("color");
            if (colorStr != null) {
                Color color = null;
                try {
                    color = DBObjectXmlUtility.readColor(colorStr);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this._mapEnumToColor.put(name, color);
            }
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXParseException {
        return ELT_CEC_TYPE_ENUM.equals(name);
    }
}

