/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type.io;

import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.io.AltaFileHeader;
import com.dassault.cecilia.io.ocas51.CoreUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class DBEnumReaderRaw {
    protected DBFolder _dbFolder;
    DBLogs.DBLogsManager _logManager;
    AltaFileHeader _properties = null;
    List<String> _enums = new ArrayList<String>();

    public DBEnumReaderRaw(DBFolder dbFolder, DBLogs.DBLogsManager logMng) {
        this._dbFolder = dbFolder;
        this._logManager = logMng;
    }

    public AltaFileHeader getProperties() {
        return this._properties;
    }

    public List<String> getValues() {
        return this._enums;
    }

    private void addValue(String value) {
        if (this._enums.contains(value)) {
            this._logManager.addLog(DBLogs.DBLevel.INFO, ResMsgOcas.msgFormat("MSG_XML_TYPE_ENUM_VALUE_ALREADY", value));
        } else {
            this._enums.add(value);
        }
    }

    public boolean readRaw(String data, CECFactory cecFactory) throws IOException {
        String line;
        BufferedReader inData = new BufferedReader(new StringReader(data));
        boolean find = false;
        while ((line = inData.readLine()) != null) {
            int position = line.indexOf("<");
            if (position == -1) continue;
            if (line.indexOf("<header") != -1) {
                this._properties = AltaFileHeader.loadFromFile(inData);
            }
            if ((position = (line = line.substring(position + 1)).indexOf(" ")) != -1) {
                String name;
                String field = line.substring(0, position);
                if (!find) {
                    if (!field.equals("type")) continue;
                    name = "";
                    if ((position = (line = line.substring(position)).indexOf("name=")) != -1) {
                        field = line.substring(position);
                        name = CoreUtil.searchString(field);
                    }
                    if (name.isEmpty()) continue;
                    find = true;
                    continue;
                }
                if (!field.equals("field")) continue;
                name = "";
                position = line.indexOf("name=");
                if (position != -1) {
                    field = line.substring(position);
                    name = CoreUtil.searchString(field);
                }
                if (name.isEmpty()) continue;
                this.addValue(name);
                continue;
            }
            if (line.indexOf("/type") != 0) continue;
            break;
        }
        return true;
    }
}

