/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.mbsa.type.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.ResMsgOcas;
import com.dassault.cecilia.dbobj.mbsa.node.io.DBAltaNodeHandlerXml;
import com.dassault.cecilia.dbobj.mbsa.type.AltaType;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecord;
import com.dassault.cecilia.dbobj.mbsa.type.DBRecordField;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBLinkHandlerXml
extends DBAltaNodeHandlerXml {
    public static final String ELT_CEC_TYPE_LINK = "cec.type.link";
    public static final String ELT_TYPE_LINK_FIELD = "link.field";
    public static final String ATT_DIRECTION = "direction";
    public static final String ATT_CROSS = "cross";
    public static final String ATT_LINK_DISPLAY = "LinkDisplay";
    DBRecord.LinkType _type;
    Map<String, DBRecordField> _mapFields = new LinkedHashMap<String, DBRecordField>();
    DBRecordField _linkToDisplay;

    public DBLinkHandlerXml(DBLogs.DBLogsManager manager, Locator locator, CECFactory cecFactory) {
        super(manager, locator, cecFactory);
    }

    public DBRecord.LinkType getType() {
        return this._type;
    }

    public Collection<DBRecordField> getFields() {
        return this._mapFields.values();
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            String type;
            if (!ELT_CEC_TYPE_LINK.equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", ELT_CEC_TYPE_LINK), this.getLocator()));
            }
            if ((type = attrs.get("type")) == null || type.isEmpty()) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "type"), this.getLocator()));
            }
            this._type = (DBRecord.LinkType)DBLinkHandlerXml.valueOfEnum(DBRecord.LinkType.class, (String)type.toUpperCase());
            if (this._type == null) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "type", type), this.getLocator()));
            }
        } else if (ELT_TYPE_LINK_FIELD.equals(key)) {
            String name = attrs.get("name");
            if (name == null || name.isEmpty()) {
                throw new SAXParseException("La balise 'link.field' n'a pas d'attribut 'name'", this.getLocator());
            }
            if (this._mapFields.containsKey(name)) {
                this.warning(new SAXParseException(ResMsgOcas.msgFormat("MSG_XML_TYPE_LINK_FIELD_ALREADY", name), this.getLocator()));
            } else {
                AltaType typeField = this.readType(key, attrs);
                String direction = attrs.get(ATT_DIRECTION);
                String cross = attrs.get(ATT_CROSS);
                String isLinkToDisplay = attrs.get(ATT_LINK_DISPLAY);
                DBRecordField.Direction direct = null;
                if (direction != null && !direction.isEmpty() && (direct = (DBRecordField.Direction)DBLinkHandlerXml.valueOfEnum(DBRecordField.Direction.class, (String)direction.toUpperCase())) == null) {
                    this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, ATT_DIRECTION, direction), this.getLocator()));
                }
                long id = -1L;
                String attr = attrs.get("id");
                if (attr != null && !attr.isEmpty()) {
                    id = -2L;
                    try {
                        id = Long.parseLong(attr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (id < -1L) {
                        this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, "id", attr), this.getLocator()));
                    }
                }
                DBRecordField altaField = new DBRecordField(name, typeField);
                if (direct != null) {
                    altaField.setDirection(direct);
                }
                if (cross != null && !cross.isEmpty()) {
                    altaField.setCrossField(cross);
                }
                if (isLinkToDisplay != null && Boolean.parseBoolean(isLinkToDisplay)) {
                    altaField.setLinkToDisplay(true);
                }
                if (id >= 0L) {
                    altaField.setID(id);
                }
                this._mapFields.put(name, altaField);
            }
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXParseException {
        return ELT_CEC_TYPE_LINK.equals(name);
    }
}

