/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.modellaw.io;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.law.Law;
import com.dassault.cecilia.dbobj.general.law.io.LawHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.modellaw.io.DBModelLawXmlConstants;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import java.util.Map;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBModelLawHandlerXml
extends SAXWrapHandler
implements DBModelLawXmlConstants {
    CECFactory _cecFactory;
    DBFolder _dbApplication;
    DBFolder _dbAuthor;
    DBFolder _dbSubstantiation;
    Law _law;
    LawHandlerXml _lawHandler = null;

    public DBModelLawHandlerXml(DBLogs.DBLogsManager logMng, Locator locator, CECFactory cecFactory) {
        super(logMng, locator);
        this._cecFactory = cecFactory;
    }

    public DBFolder getApplication() {
        return this._dbApplication;
    }

    public DBFolder getAuthor() {
        return this._dbAuthor;
    }

    public DBFolder getSubstantiation() {
        return this._dbSubstantiation;
    }

    public Law getLaw() {
        return this._law;
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            if (!"cec.event".equals(key)) {
                this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "cec.event"), this.getLocator()));
            }
        } else if (this._lawHandler != null) {
            this._lawHandler.startAction(key, attrs, false);
        } else if ("application".equals(key)) {
            this._dbApplication = this.readDBFolder(key, attrs, this._cecFactory.createFolderDAO(), "BTP_APPLICATIONS", false);
            if (this._dbApplication != null && this._dbApplication.getFamily() != DBFolder.Family.BTP_APPLICATION) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{"application", DBFolder.Family.BTP_APPLICATION}), this.getLocator()));
                this._dbApplication = null;
            }
        } else if ("author".equals(key)) {
            this._dbAuthor = this.readDBFolder(key, attrs, this._cecFactory.createFolderDAO(), "BTP_AUTHORS", false);
            if (this._dbAuthor != null && this._dbAuthor.getFamily() != DBFolder.Family.BTP_AUTHOR) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{"author", DBFolder.Family.BTP_AUTHOR}), this.getLocator()));
                this._dbAuthor = null;
            }
        } else if ("subtantiation".equals(key)) {
            this._dbSubstantiation = this.readDBFolder(key, attrs, this._cecFactory.createFolderDAO(), "BTP_SUBSTANTIATIONS", false);
            if (this._dbSubstantiation != null && this._dbSubstantiation.getFamily() != DBFolder.Family.BTP_SUBSTANTIATION) {
                this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{"subtantiation", DBFolder.Family.BTP_SUBSTANTIATION}), this.getLocator()));
                this._dbSubstantiation = null;
            }
        } else if ("law".equals(key)) {
            this._lawHandler = new LawHandlerXml(this.getLogManager(), this.getLocator(), this._cecFactory, this._cecFactory.getLawManager()){

                @Override
                protected String getOwnerObject() {
                    return ResMsgVoc.getString("VOC_FRB");
                }
            };
            this._lawHandler.startAction(key, attrs, true);
        } else {
            this.errorElementUnknown(key);
        }
    }

    public boolean endAction(String name, Map<String, String> attrs, String txt) throws SAXException {
        if (this._lawHandler != null) {
            boolean result = this._lawHandler.endAction(name, attrs, txt);
            if (result) {
                if ("law".equals(name)) {
                    this._law = this._lawHandler.getLaw();
                }
                this._lawHandler = null;
            }
            return false;
        }
        boolean result = "cec.event".equals(name);
        if (result && this._law == null) {
            this.warning(new SAXParseException(ResMsgObj.getString("MSG_ERR_DBMOD_LAW_NO_DISTRIB"), this.getLocator()));
            this._law = this._cecFactory.getLawManager().createLaw(-1);
        }
        return result;
    }
}

