/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.swing.table.TableDecoredItem;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBRelation;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.lib.util.io.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.table.TableCellEditor;

public class AverageAttributeCriterion
implements TableDecoredItem {
    AttrCriterion _criterion;
    ProbabilityChoice _choice;
    Param _parameter;
    List<Param> _parameters;
    JComboBox _ctrlComboProbability;

    public AverageAttributeCriterion() {
        this._criterion = null;
        this._choice = ProbabilityChoice.AVG;
        this._parameter = null;
    }

    public AverageAttributeCriterion(AttrCriterion criterion, ProbabilityChoice choice, Param parameter) {
        this._criterion = criterion;
        this._choice = choice;
        this._parameter = parameter;
    }

    @Override
    public AverageAttributeCriterion getCopy() {
        return new AverageAttributeCriterion(this._criterion == null ? null : this._criterion.getCopy(), this._choice, this._parameter == null ? null : this._parameter.getCopy());
    }

    public AttrCriterion getCriterion() {
        return this._criterion;
    }

    public ProbabilityChoice getChoice() {
        return this._choice;
    }

    public Param getDefaultParameter() {
        return this._parameter;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return AttrCriterion.class;
            }
            case 1: {
                return ProbabilityChoice.class;
            }
            case 2: {
                return Param.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return ResMsgVoc.getString("VOC_CONDITION");
            }
            case 1: {
                return ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_RISK");
            }
            case 2: {
                return ResMsgObj.getString("DLG_ATTRIBUTEDRIVEAVG_PARAM");
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int c) {
        switch (c) {
            case 0: {
                return this._criterion;
            }
            case 1: {
                return this._choice;
            }
            case 2: {
                return this._parameter;
            }
        }
        return null;
    }

    @Override
    public boolean setValueAt(Object item, int c) {
        switch (c) {
            case 0: {
                if (!(item instanceof AttrCriterion)) break;
                this._criterion = (AttrCriterion)item;
                return true;
            }
            case 1: {
                if (!(item instanceof ProbabilityChoice)) break;
                this._choice = (ProbabilityChoice)((Object)item);
                if (this._choice == ProbabilityChoice.DEF) {
                    this._parameter = null;
                }
                return true;
            }
            case 2: {
                if (item == null) {
                    this._parameter = null;
                    return true;
                }
                if (!(item instanceof Param)) break;
                this._parameter = (Param)item;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDefaultWidth(int c) {
        switch (c) {
            case 0: {
                return 120;
            }
            case 1: {
                return 25;
            }
            case 2: {
                return 75;
            }
        }
        return 0;
    }

    @Override
    public boolean withError(int c) {
        return false;
    }

    @Override
    public boolean isCellEditable(int c) {
        switch (c) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public void refreshParameters() {
        this._parameters = new ArrayList<Param>();
        this._parameters.add(ParamRef.__UNKNOWN);
    }

    @Override
    public TableCellEditor getEditor(int c) {
        switch (c) {
            case 0: {
                break;
            }
            case 1: {
                if (this._ctrlComboProbability == null) {
                    this._ctrlComboProbability = new JComboBox();
                    this._ctrlComboProbability.addItem(ProbabilityChoice.DEF);
                    this._ctrlComboProbability.addItem(ProbabilityChoice.AVG);
                    this._ctrlComboProbability.addItem(ProbabilityChoice.MAX);
                    this._ctrlComboProbability.setEditable(false);
                    this._ctrlComboProbability.setRenderer(new DefaultListCellRenderer(){

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                            ProbabilityChoice choice = (ProbabilityChoice)((Object)value);
                            if (choice != null) {
                                this.setText(choice.getLabel());
                            }
                            return result;
                        }
                    });
                }
                return new DefaultCellEditor(this._ctrlComboProbability);
            }
        }
        return null;
    }

    public void toXML(Appendable out, String indent, boolean withID) throws IOException {
        out.append(indent).append("<").append("cec.params.average.compute.item");
        if (this.getCriterion().getType() != AttrType.ALIAS) {
            out.append(" op='").append(XMLWriter.toXML((String)this.getCriterion().getOperator().toString().toLowerCase())).append("'");
            out.append(" data='").append(XMLWriter.toXML((String)this.getCriterion().getData())).append("'");
        }
        out.append(" choice='").append(XMLWriter.toXML((String)this.getChoice().toString().toLowerCase())).append("'");
        if (this.getDefaultParameter() == null) {
            out.append("/>\n");
        } else {
            out.append(">\n");
            this.getDefaultParameter().toXML(out, indent + "  ", withID);
            out.append(indent).append("</").append("cec.params.average.compute.item").append(">\n");
        }
    }

    public void addRelation(DBFolder dbSrcFolder, String typeSrcRelation, Set<DBRelation> relations) {
        if (this.getDefaultParameter() != null) {
            this.getDefaultParameter().addRelation(dbSrcFolder, typeSrcRelation, relations);
        }
    }

    public static enum ProbabilityChoice {
        DEF(ResMsgObj.getString("DLG_RISK_DEFAULT")),
        MAX(ResMsgObj.getString("DLG_RISK_MAX")),
        AVG(ResMsgObj.getString("DLG_RISK_AVG"));

        String _strLabel;

        private ProbabilityChoice(String strLabel) {
            this._strLabel = strLabel;
        }

        public String getLabel() {
            return this._strLabel;
        }
    }
}

