/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.gui;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.general.law.LawManager;
import com.dassault.cecilia.dbobj.general.law.Param;
import com.dassault.cecilia.dbobj.general.law.ParamRef;
import com.dassault.cecilia.dbobj.general.law.TypeParam;
import com.dassault.cecilia.dbobj.general.law.io.ParamHandlerXml;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.general.nparam.DBParam;
import com.dassault.cecilia.dbobj.project.AverageAttributeCriterion;
import com.dassault.cecilia.dbobj.project.AverageAttributeDriver;
import com.dassault.cecilia.dbobj.project.io.DBProjectXmlConstants;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.dbobj.wrap.io.SAXWrapHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AADPanelHandlerXml
extends SAXWrapHandler
implements DBProjectXmlConstants {
    private static Logger _LOG = Logger.getLogger(AADPanelHandlerXml.class.getPackage().getName());
    private static DBLogs.DBLogsManager _LOG_MANAGER = new DBLogs.DBLogsManager(){

        @Override
        public void addLog(DBLogs.DBLevel dbLvl, String msg, boolean bPrivate) {
            _LOG.log(dbLvl.getJavaLevel(), msg);
        }

        @Override
        public void addLog(DBLogs.Log log) {
            _LOG.log(log.getLevel().getJavaLevel(), log.getMessage());
        }

        @Override
        public boolean withLogs(DBLogs.DBLevel limit) {
            return false;
        }
    };
    CECFactory _cecFactory;
    Map<DBAttrib, AverageAttributeDriver> _avgAttributeDrivers;
    boolean _bOldFormat = false;
    boolean _bReadAverage;
    DBAttrib _currentAttribute;
    List<AverageAttributeCriterion> _currentCriteriums;
    AACHandlerXML _childAAC;

    public Collection<AverageAttributeDriver> getAAD() {
        return this._avgAttributeDrivers.values();
    }

    public AADPanelHandlerXml(CECFactory cecFactory, Locator locator) {
        super(_LOG_MANAGER, locator);
        this._cecFactory = cecFactory;
        this._bReadAverage = false;
        this._currentAttribute = null;
        this._currentCriteriums = null;
        this._avgAttributeDrivers = new LinkedHashMap<DBAttrib, AverageAttributeDriver>();
    }

    public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
        if (startAction) {
            if (!"cec.params.averages".equals(key)) {
                if ("ATTRIBUTE_DRIVE_OPTIONS".equals(key)) {
                    this._bOldFormat = true;
                } else {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_START", "cec.params.averages"), this.getLocator()));
                }
            }
        } else if (this._bOldFormat) {
            if ("ATTRIBUTE_DRIVE_SELECT".equals(key)) {
                DBFolder dbFolder;
                String attrPath = attrs.get("ATTRIBUTE_PATH");
                if (attrPath == null || attrPath.isEmpty()) {
                    this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, "ATTRIBUTE_PATH"), this.getLocator()));
                }
                if ((dbFolder = this._cecFactory.createFolderDAO().findFolder(-1L, attrPath, "ATTRIBUTES")) == null) {
                    this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNKNOWN", attrPath), this.getLocator()));
                } else {
                    DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
                    if (dbWrap == null) {
                        this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_RAW_ATTRIB_READ", attrPath), this.getLocator()));
                    } else {
                        this._bReadAverage = true;
                        this._currentAttribute = (DBAttrib)dbWrap;
                        if (this._avgAttributeDrivers.get(this._currentAttribute) != null) {
                            this.getLogManager().addLog(DBLogs.DBLevel.WARNING, "Il y a d\u00e9j\u00e0 une matrice des risques moyens avec cet attribut: " + this._currentAttribute.getRefPath());
                        }
                        this._currentCriteriums = new ArrayList<AverageAttributeCriterion>();
                    }
                }
            } else if ("ATTRIBUTE_DRIVE_DEFINE".equals(key)) {
                if (!this._bReadAverage) {
                    this.errorElementUnknown(key);
                }
                ParamRef paramRef = null;
                String paramPath = attrs.get("PARAMETER_PATH");
                if (paramPath != null && !paramPath.isEmpty()) {
                    DBFolder dbFolder = this._cecFactory.createFolderDAO().findFolder(-1L, paramPath, "LAW_PARAMETERS");
                    if (dbFolder == null) {
                        this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_RAW_ATTRIB_UNKNOWN", paramPath), this.getLocator()));
                    } else {
                        DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
                        if (dbWrap == null) {
                            this.warning(new SAXParseException(ResMsgObj.msgFormat("MSG_RAW_ATTRIB_READ", paramPath), this.getLocator()));
                        } else {
                            DBParam parameter = (DBParam)dbWrap;
                            paramRef = new ParamRef(parameter.getType(), parameter.getDBFolder());
                        }
                    }
                }
                AverageAttributeCriterion aac = this.readAAC(key, attrs, this._currentAttribute, "CHOICE", "OP", "DATA", paramRef);
                this._currentCriteriums.add(aac);
            } else {
                this.errorElementUnknown(key);
            }
        } else if (this._childAAC != null) {
            this._childAAC.startAction(key, attrs, startAction);
        } else if ("cec.params.average.compute".equals(key)) {
            DBFolder dbFolder = this.readDBFolder(key, attrs, this._cecFactory.createFolderDAO(), "ATTRIBUTES", false);
            this._bReadAverage = true;
            this._currentAttribute = null;
            if (dbFolder != null) {
                if (dbFolder.getFamily() != DBFolder.Family.ATTRIBUTE) {
                    this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{"cec.params.average.compute", DBFolder.Family.ATTRIBUTE}), this.getLocator()));
                } else {
                    DBWrap dbWrap = this._cecFactory.findOrCreateWrap(dbFolder);
                    if (dbWrap != null) {
                        if (dbWrap instanceof DBAttrib) {
                            this._currentAttribute = (DBAttrib)dbWrap;
                        } else {
                            this.warning(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_FOLDER_FAMILY", new Object[]{"cec.params.average.compute", DBFolder.Family.ATTRIBUTE}), this.getLocator()));
                        }
                        if (this._avgAttributeDrivers.get(this._currentAttribute) != null) {
                            this.getLogManager().addLog(DBLogs.DBLevel.WARNING, "Il y a d\u00e9j\u00e0 une matrice des risques moyens avec cet attribut: " + this._currentAttribute.getRefPath());
                        }
                        this._currentCriteriums = new ArrayList<AverageAttributeCriterion>();
                    }
                }
            }
        } else if ("cec.params.average.compute.item".equals(key)) {
            if (!this._bReadAverage) {
                this.errorElementUnknown(key);
            } else if (this._currentAttribute != null) {
                this._childAAC = new AACHandlerXML(this.getLogManager(), this.getLocator(), this._cecFactory, this._cecFactory.getLawManager().getParameterManager());
                this._childAAC.startAction(key, attrs, true);
            }
        } else {
            this.errorElementUnknown(key);
        }
    }

    @Override
    public long readID(String eltName, String attrName, Map<String, String> attrs) throws SAXException {
        String refID = attrs.get(attrName);
        if (refID == null || refID.isEmpty()) {
            return -1L;
        }
        if (refID.trim().equals("-1")) {
            return -1L;
        }
        return super.readID(eltName, attrName, attrs);
    }

    public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
        if (this._childAAC != null) {
            boolean result = this._childAAC.endAction(key, attrs, txt);
            if (result) {
                AverageAttributeCriterion aac = this.readAAC(key, attrs, this._currentAttribute, "choice", "op", "data", this._childAAC._param);
                this._currentCriteriums.add(aac);
                this._childAAC = null;
            }
            return false;
        }
        if ("cec.params.average.compute".equals(key) || "ATTRIBUTE_DRIVE_SELECT".equals(key)) {
            this._bReadAverage = false;
            this._avgAttributeDrivers.put(this._currentAttribute, new AverageAttributeDriver(this._currentAttribute, this._currentCriteriums));
            this._currentAttribute = null;
            this._currentCriteriums = null;
        }
        return "cec.project".equals(key);
    }

    private AverageAttributeCriterion readAAC(String key, Map<String, String> attrs, DBAttrib dbAttrib, String attrChoice, String attrOp, String attrData, Param param) throws SAXException {
        AverageAttributeCriterion.ProbabilityChoice choice = null;
        String attr = attrs.get(attrChoice);
        if (attr == null || attr.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, attrChoice), this.getLocator()));
        }
        if ((choice = (AverageAttributeCriterion.ProbabilityChoice)AADPanelHandlerXml.valueOfEnum(AverageAttributeCriterion.ProbabilityChoice.class, (String)attr.toUpperCase())) == null) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, attrChoice, attr), this.getLocator()));
        }
        AttrCriterion criterion = null;
        AttrCriterion.Operator op = null;
        String attr2 = attrs.get(attrOp);
        if (attr2 == null || attr2.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, attrOp), this.getLocator()));
        }
        if ((op = (AttrCriterion.Operator)AADPanelHandlerXml.valueOfEnum(AttrCriterion.Operator.class, (String)attr2.toUpperCase())) == null) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_FORMAT", key, attrOp, attr2), this.getLocator()));
        }
        String data = null;
        data = attrs.get(attrData);
        if (data == null || data.isEmpty()) {
            this.error(new SAXParseException(ResMsgCore.msgFormat("MSG_ERR_DBMOD_XML_ATTR_NO", key, attrData), this.getLocator()));
        }
        criterion = new AttrCriterion(dbAttrib, op, data);
        if (choice == AverageAttributeCriterion.ProbabilityChoice.DEF) {
            param = null;
        }
        return new AverageAttributeCriterion(criterion, choice, param);
    }

    class AACHandlerXML
    extends ParamHandlerXml
    implements DBProjectXmlConstants {
        Param _param;

        protected AACHandlerXML(DBLogs.DBLogsManager logMng, Locator locator, CECFactory cecFactory, LawManager lawManager) {
            super(logMng, locator, cecFactory, lawManager);
        }

        @Override
        public void startAction(String key, Map<String, String> attrs, boolean startAction) throws SAXException {
            if (!startAction) {
                super.startAction(key, attrs, startAction);
            }
        }

        public boolean endAction(String key, Map<String, String> attrs, String txt) throws SAXException {
            if (this._childHandler != null) {
                boolean result = this._childHandler.endAction(key, attrs, txt);
                if (result) {
                    this.manageChildEndAction(key);
                    this._childHandler = null;
                }
                return false;
            }
            return "cec.params.average.compute.item".equals(key);
        }

        @Override
        protected TypeParam getCurrentType() {
            return TypeParam.DELAY;
        }

        @Override
        protected void manageCreateParam(Param param) {
            this._param = param;
        }

        @Override
        protected Param createDefaultParam() {
            return null;
        }

        @Override
        protected String getOwnerObject() {
            return AADPanelHandlerXml.this._currentAttribute.getRefPath();
        }
    }
}

