/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.dbobj.project.gui;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.project.gui.AttributeAverageDriverPanel;
import com.dassault.cecilia.dbobj.project.gui.AverageFlightDurationPanel;
import com.dassault.cecilia.dbobj.project.gui.LatentProbabilityPanel;
import com.dassault.cecilia.dbobj.project.gui.ProjectCriticityPanel;
import com.dassault.cecilia.dbobj.wrap.gui.DBWrapFrameEdit;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class DBProjectFrameEdit
extends DBWrapFrameEdit {
    JTabbedPane _tabPane;
    LatentProbabilityPanel _ctrlTypeProbability;
    AverageFlightDurationPanel _ctrlFlightDuration;
    AttributeAverageDriverPanel _ctrlAverageAttributeDrivers;
    ProjectCriticityPanel _ctrlCriticity;

    @Override
    protected String getDBLabel() {
        return ResMsgVoc.getString("VOC_PROJECT");
    }

    @Override
    public DBProject getDBWrap() {
        return (DBProject)super.getDBWrap();
    }

    public DBProjectFrameEdit(DBProject dbProject, CeciliaAppl appl) {
        super(dbProject.getCopy(), appl, ResIcoCore.getImageIcon("FOLDER_DEFAULT_O"), dbProject.getDBFolder().getName(), dbProject.getDBFolder().getPathUntilSystem(new StringBuilder().append(ResMsgVoc.getString("VOC_PROJECT")).append(" : ")).toString());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.createCenterPanel(), "Center");
        this.getContentPane().add(this.createAndPlugLogsButtonAt(this.createSaveAndClosePanel()), "South");
        this.setFrameIcon(ResIcoCore.getImageIcon("FOLDER_DEFAULT_O"));
        this.pack();
        this.refreshControl();
        this.setModified(false);
    }

    @Override
    public boolean isModified() {
        if (this.getDBWrap().isModified()) {
            return true;
        }
        if (this._ctrlFlightDuration.isModified()) {
            return true;
        }
        return super.isModified();
    }

    @Override
    public void setModified(boolean value) {
        this.getDBWrap().setModified(value);
        super.setModified(value);
    }

    @Override
    public boolean verifyData() {
        if (!this.verifyDescription()) {
            this._tabPane.setSelectedIndex(2);
            return false;
        }
        return super.verifyData();
    }

    @Override
    public boolean save() {
        if (this.isReadOnly()) {
            return false;
        }
        this._ctrlAverageAttributeDrivers.save();
        this._ctrlFlightDuration.save();
        this._ctrlTypeProbability.save();
        return this.doSave();
    }

    @Override
    protected void refreshControl() {
        this._ctrlPath.setEnabled(false);
        this._ctrlName.setEnabled(false);
        this._ctrlVersion.setEnabled(false);
        this._ctrlDescription.setEnabled(true);
        this._ctrlVersion.setText(this.getDBFolder().getName());
        this._ctrlDescription.setText(this.getDBFolder().getDescription());
        boolean isAdmin = this.getApplication().getDBUser().isAdmin();
        this._ctrlTypeProbability.init(this.getDBWrap(), isAdmin);
        this._ctrlFlightDuration.init(this.getDBWrap(), isAdmin);
        this._ctrlAverageAttributeDrivers.init(this.getDBWrap(), isAdmin);
    }

    private Component createCenterPanel() {
        this._tabPane = new JTabbedPane();
        this._tabPane.addTab(ResMsgVoc.getString("VOC_COMPUTE"), this.createComputeCtrl());
        this._tabPane.addTab(ResMsgVoc.getString("VOC_CRITICITY"), this.createCriticityCtrl());
        JPanel result = new JPanel(new GridBagLayout());
        result.add(this.createPathCtrl(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        result.add(this.createTitlePanel(this.createDescriptionCtrl(), ResMsgVoc.getString("VOC_DESCRIPTION")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this._tabPane.addTab(ResMsgVoc.getString("VOC_GENERAL"), result);
        this._tabPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return this._tabPane;
    }

    @Override
    protected Component createPathCtrl(boolean bPath) {
        JPanel panel = new JPanel(new GridBagLayout());
        this._ctrlPath = new JTextField();
        this._ctrlName = new JTextField();
        this._ctrlVersion = new JTextField();
        int posY = 0;
        panel.add((Component)new JLabel(ResMsgVoc.getString("VOC_NAME")), new GridBagConstraints(0, posY, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this._ctrlVersion, new GridBagConstraints(1, posY, 1, 1, 0.33, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private Component createComputeCtrl() {
        JPanel panel = new JPanel(new GridBagLayout());
        int posY = 0;
        this._ctrlTypeProbability = new LatentProbabilityPanel();
        panel.add((Component)this._ctrlTypeProbability, new GridBagConstraints(0, posY++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this._ctrlFlightDuration = new AverageFlightDurationPanel();
        panel.add((Component)this._ctrlFlightDuration, new GridBagConstraints(0, posY++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this._ctrlAverageAttributeDrivers = new AttributeAverageDriverPanel(this.getApplication());
        panel.add((Component)this._ctrlAverageAttributeDrivers, new GridBagConstraints(0, posY++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        return panel;
    }

    private Component createCriticityCtrl() {
        JPanel panel = new JPanel(new GridBagLayout());
        int posY = 0;
        this._ctrlCriticity = new ProjectCriticityPanel(this.getDBWrap(), this.getApplication().getDBUser().isAdmin());
        panel.add((Component)this._ctrlCriticity, new GridBagConstraints(0, posY++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        return panel;
    }

    @Override
    protected boolean withUpdateEdit() {
        return false;
    }

    @Override
    protected void updateEdit() {
        DBLogs.DBLevel oldLevel = this.getLogs().getMaxLevel();
        int oldNbr = this.getLogs().getNbrLogs();
        DBLogs.DefaultManager logMng = new DBLogs.DefaultManager(this.getApplication().getDBUser().getLogin(), this.getDBWrap().getLogs());
        this.getDBWrap().update(this.getApplication().getDAOFactory(), logMng);
        this.refreshControl();
        this.getDBWrap().prepareDependTimeUpdt(this.getApplication().getDAOFactory(), this.getDBWrap().getUseRelations());
        this.updateLogs(this.getDBWrap().getUseRelations(), oldLevel, oldNbr);
    }
}

